/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.csp.ProbaTimeManager;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.composition.DynamicAttribute;
import fr.inra.sad.bagap.apiland.core.composition.TemporalValue;
import fr.inra.sad.bagap.apiland.core.time.Future;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import fr.inra.sad.bagap.apiland.core.time.MultiInterval;
import fr.inra.sad.bagap.apiland.core.time.Time;
import java.util.Set;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;

public class DurationConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;
    private String durationMode;
    private boolean hasMax;

    public DurationConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<Integer, Integer> domain, String durationMode, boolean hasMax) {
        super(code, checkOnly, ConstraintType.Duration, mode, covers, parcels, domain);
        this.durationMode = durationMode;
        this.hasMax = hasMax;
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        int min = (Integer)this.domain().minimum();
        int max = (Integer)this.domain().maximum();
        for (CoverUnit c : this.covers()) {
            block5: for (Parcel p : this.location()) {
                int ip = cap.parcels().get(p);
                if (cap.previous(ip) == null || !c.equals(cap.previous(ip).getValue())) continue;
                int count = cap.getTime().year() - cap.previous(ip).getTime().start().year();
                switch (this.mode()) {
                    case ONLY: {
                        int nbyear;
                        int duration;
                        if (count < min) {
                            if (!cap.previous(ip).equals(cap.first(ip))) {
                                cap.solver().post(ICF.arithm((IntVar)cap.parcelsImplantedCoverContinue(ip), (String)"=", (int)1));
                                break;
                            }
                            if (!((double)count < (double)min * Math.random() / 2.0)) continue block5;
                            cap.solver().post(ICF.arithm((IntVar)cap.parcelsImplantedCoverContinue(ip), (String)"=", (int)1));
                            break;
                        }
                        if (!this.hasMax) continue block5;
                        if (count >= max) {
                            cap.solver().post(ICF.arithm((IntVar)cap.parcelsImplantedCoverContinue(ip), (String)"=", (int)0));
                            break;
                        }
                        int rp = (int)(Math.random() * 100.0);
                        if (!((double)rp > ProbaTimeManager.getProba(this.durationMode, duration = max - min + 1, nbyear = count - min) / (100.0 - ProbaTimeManager.getCumul(this.durationMode, duration, nbyear)) * 100.0)) continue block5;
                        cap.solver().post(ICF.arithm((IntVar)cap.parcelsImplantedCoverContinue(ip), (String)"=", (int)1));
                        break;
                    }
                    case NEVER: {
                        if (!this.domain().accept(count)) continue block5;
                        cap.solver().post(ICF.arithm((IntVar)cap.parcelsImplantedCoverContinue(ip), (String)"=", (int)1));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                    }
                }
            }
        }
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        Interval actif = new Interval(start, end);
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        int supermin = Integer.MAX_VALUE;
        int supermax = Integer.MIN_VALUE;
        for (Parcel p : this.location()) {
            block5: for (TemporalValue tv : (DynamicAttribute)p.getAttribute("cover")) {
                int min = Integer.MAX_VALUE;
                int max = Integer.MIN_VALUE;
                if (this.covers().contains(tv.getValue()) && actif.intersects(tv.getTime())) {
                    int d;
                    Time t;
                    if (!tv.equals(p.getAttribute("cover").getFirst()) && !tv.equals(p.getAttribute("cover").getLast())) {
                        t = tv.getTime();
                        if (t instanceof Interval) {
                            if (!(((Interval)t).end() instanceof Future)) {
                                d = ((Interval)t).yearInterval();
                                min = Math.min(min, d);
                            }
                        } else {
                            for (Interval i : (MultiInterval)t) {
                                if (i.end() instanceof Future) continue;
                                d = i.yearInterval();
                                min = Math.min(min, d);
                            }
                        }
                    }
                    if ((t = tv.getTime()) instanceof Interval) {
                        if (!(((Interval)t).end() instanceof Future)) {
                            d = ((Interval)t).yearInterval();
                            max = Math.max(max, d);
                        }
                    } else {
                        for (Interval i : (MultiInterval)t) {
                            if (i.end() instanceof Future) continue;
                            d = i.yearInterval();
                            max = Math.max(max, d);
                        }
                    }
                }
                supermin = Math.min(supermin, min);
                supermax = Math.max(supermax, max);
                switch (this.mode()) {
                    case ONLY: {
                        if (min == Integer.MAX_VALUE || this.domain().accept(min) && this.domain().accept(max)) continue block5;
                        ok = false;
                        if (verbose) {
                            sb.append("BAD  - cover " + tv.getValue() + " has duration time between min = " + min + " and max = " + max + "\n");
                            continue block5;
                        }
                        return ok;
                    }
                    case NEVER: {
                        if (min == Integer.MAX_VALUE || !this.domain().accept(min) && !this.domain().accept(max)) continue block5;
                        ok = false;
                        if (verbose) {
                            sb.append("BAD  - cover " + tv.getValue() + " has duration time between min = " + min + " and max = " + max + "\n");
                            continue block5;
                        }
                        return ok;
                    }
                }
                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
            }
        }
        if (verbose) {
            if (ok) {
                if (supermin == Integer.MAX_VALUE) {
                    sb.append("GOOD - Duration " + (Object)((Object)this.mode()) + " cover " + this.covers().toString() + " has good duration");
                } else if (supermin == supermax) {
                    sb.append("GOOD - Duration " + (Object)((Object)this.mode()) + " cover " + this.covers().toString() + " has duration time = " + supermin);
                } else {
                    sb.append("GOOD - Duration " + (Object)((Object)this.mode()) + " cover " + this.covers().toString() + " has duration time between min = " + supermin + " and max = " + supermax);
                }
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

