/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.SetDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.composition.DynamicAttribute;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import java.util.HashSet;
import java.util.Set;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class NextCoverConstraint
extends CoverAllocationConstraint<CoverUnit, CoverUnit> {
    private static final long serialVersionUID = 1L;

    public NextCoverConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<CoverUnit, CoverUnit> domain) {
        super(code, checkOnly, ConstraintType.NextCover, mode, covers, parcels, domain);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        block4: for (Parcel p : this.location()) {
            int ip = cap.parcels().get(p);
            if (cap.previous(ip) == null || !this.covers().contains(cap.previous(ip).getValue())) continue;
            switch (this.mode()) {
                case ONLY: {
                    int i;
                    Constraint[] cons;
                    if (((SetDomain)this.domain()).set().size() > 0) {
                        cons = new Constraint[((SetDomain)this.domain()).set().size()];
                        i = 0;
                        for (CoverUnit cu : ((SetDomain)this.domain()).set()) {
                            cons[i++] = ICF.arithm((IntVar)cap.coversAndParcels(cap.covers().get(cu), ip), (String)"=", (int)1);
                        }
                        if (cons.length <= 0) continue block4;
                        LCF.ifThen((BoolVar)cap.parcelsImplantedCoverContinue(ip).not(), (Constraint)LCF.or((Constraint[])cons));
                        continue block4;
                    }
                    cap.solver().post(ICF.arithm((IntVar)cap.parcelsImplantedCoverContinue(ip), (String)"=", (int)1));
                    continue block4;
                }
                case NEVER: {
                    Constraint[] cons = new Constraint[((SetDomain)this.domain()).set().size()];
                    int i = 0;
                    for (CoverUnit cu : ((SetDomain)this.domain()).set()) {
                        cons[i++] = ICF.arithm((IntVar)cap.coversAndParcels(cap.covers().get(cu), ip), (String)"=", (int)0);
                    }
                    if (cons.length <= 0) continue block4;
                    LCF.ifThen((BoolVar)cap.parcelsImplantedCoverContinue(ip).not(), (Constraint)LCF.and((Constraint[])cons));
                    continue block4;
                }
            }
            throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
        }
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        HashSet<CoverUnit> next = new HashSet<CoverUnit>();
        Interval t = new Interval(start, end);
        for (Parcel p : this.location()) {
            CoverUnit prec = null;
            for (CoverUnit c : ((DynamicAttribute)p.getAttribute("cover")).values(t)) {
                if (this.covers().contains(prec)) {
                    switch (this.mode()) {
                        case ONLY: {
                            if (!this.domain().accept(c)) {
                                ok = false;
                                if (verbose) {
                                    sb.append(this.covers().toString() + " BAD : Next Cover " + c + "\n");
                                    break;
                                }
                                return ok;
                            }
                            next.add(c);
                            break;
                        }
                        case NEVER: {
                            if (this.domain().accept(c)) {
                                ok = false;
                                if (verbose) {
                                    sb.append(this.covers().toString() + " BAD : Next Cover " + c + "\n");
                                    break;
                                }
                                return ok;
                            }
                            next.add(c);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                        }
                    }
                }
                prec = c;
            }
        }
        if (verbose) {
            if (ok) {
                sb.append("GOOD : cover " + this.covers().toString() + " has next transitions in " + next);
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

