/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.territory;

import fr.inra.sad.bagap.apiland.capfarm.model.CoverManager;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.Farm;
import fr.inra.sad.bagap.apiland.capfarm.model.FarmsAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.AgriculturalArea;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Facility;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.FarmTerritory;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Territory;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.TrameArea;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.TrameUnit;
import fr.inra.sad.bagap.apiland.core.element.AbstractDynamicElement;
import fr.inra.sad.bagap.apiland.core.element.DefaultDynamicFeature;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementTypeFactory;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicFeatureType;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicLayerType;
import fr.inra.sad.bagap.apiland.core.space.Surface;
import fr.inra.sad.bagap.apiland.core.space.impl.GeometryImplType;
import fr.inra.sad.bagap.apiland.core.structure.DynamicRepresentationType;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.files.ShpFiles;

public class TerritoryFactory {
    public static void init(Territory territory, Farm farm) {
        for (FarmTerritory ft : (AgriculturalArea)territory.get("AA")) {
            if (!ft.getId().equalsIgnoreCase(farm.getCode())) continue;
            farm.setTerritory(ft);
            return;
        }
        throw new IllegalArgumentException("wrong farm code under territory");
    }

    public static void init(Territory territory, FarmsAllocator farmsAllocator) {
        farmsAllocator.setTerritory((AgriculturalArea)territory.get("AA"));
    }

    public static Territory init(String shape, Instant t) {
        HashMap conditions = new HashMap();
        try {
            ShpFiles sf = shape.endsWith(".shp") ? new ShpFiles(shape) : new ShpFiles(shape + ".shp");
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.add("id");
            treeSet.add("farm");
            treeSet.add("area");
            treeSet.add("type");
            treeSet.add("facility");
            treeSet.add("occsol");
            for (int f = 0; f < dfh.getNumFields(); ++f) {
                if (treeSet.contains(dfh.getFieldName(f).toLowerCase())) continue;
                if (!conditions.containsKey(dfh.getFieldClass(f))) {
                    conditions.put(dfh.getFieldClass(f), new HashSet());
                }
                ((Set)conditions.get(dfh.getFieldClass(f))).add(dfh.getFieldName(f).toLowerCase());
            }
            dfr.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DynamicFeatureType parcelType = new DynamicFeatureType("id", Parcel.class);
        parcelType.addRepresentationType(new DynamicRepresentationType("raster", Interval.class, Surface.class, GeometryImplType.RASTER));
        parcelType.addAttributeType(DynamicElementTypeFactory.createAttributeType("type", null, String.class));
        parcelType.addAttributeType(DynamicElementTypeFactory.createAttributeType("seq_cover", null, String.class));
        parcelType.addAttributeType(DynamicElementTypeFactory.createAttributeType("strict_seq", null, String.class));
        parcelType.addAttributeType(DynamicElementTypeFactory.createAttributeType("seq_year", null, String.class));
        parcelType.addAttributeType(DynamicElementTypeFactory.createAttributeType("length", null, Integer.class));
        parcelType.addAttributeType(DynamicElementTypeFactory.createAttributeType("repet", null, Integer.class));
        parcelType.addAttributeType(DynamicElementTypeFactory.createAttributeType("cover", Interval.class, CoverUnit.class));
        parcelType.addAttributeType(DynamicElementTypeFactory.createAttributeType("area", Interval.class, Double.class));
        for (Map.Entry entry : conditions.entrySet()) {
            for (String c : (Set)entry.getValue()) {
                parcelType.addAttributeType(DynamicElementTypeFactory.createAttributeType(c, null, (Class)entry.getKey()));
            }
        }
        parcelType.setCondition("parcel");
        DynamicFeatureType facilityType = new DynamicFeatureType("id", Facility.class);
        facilityType.addRepresentationType(new DynamicRepresentationType("raster", Interval.class, Surface.class, GeometryImplType.RASTER));
        facilityType.addAttributeType(DynamicElementTypeFactory.createAttributeType("type", null, String.class));
        facilityType.addAttributeType(DynamicElementTypeFactory.createAttributeType("facility", null, String.class));
        facilityType.addAttributeType(DynamicElementTypeFactory.createAttributeType("cover", Interval.class, CoverUnit.class));
        facilityType.setCondition("facility");
        DynamicLayerType dynamicLayerType = new DynamicLayerType("farm", (Class<? extends DynamicLayer>)FarmTerritory.class);
        dynamicLayerType.addAttributeType(DynamicElementTypeFactory.createAttributeType("system", null, String.class));
        dynamicLayerType.addAttributeType(DynamicElementTypeFactory.createAttributeType("seed", Interval.class, Long.class));
        dynamicLayerType.addAttributeType(DynamicElementTypeFactory.createAttributeType("profit", Interval.class, Integer.class));
        dynamicLayerType.addAttributeType(DynamicElementTypeFactory.createAttributeType("zoneprofit", Interval.class, Integer.class));
        dynamicLayerType.addElementType(parcelType);
        dynamicLayerType.addElementType(facilityType);
        DynamicLayerType agriculturalAreaType = new DynamicLayerType("area", (Class<? extends DynamicLayer>)AgriculturalArea.class);
        agriculturalAreaType.addAttributeType(DynamicElementTypeFactory.createAttributeType("prairies", Interval.class, Integer.class));
        agriculturalAreaType.addElementType(dynamicLayerType);
        DynamicFeatureType trameUnitType = new DynamicFeatureType("id", TrameUnit.class);
        trameUnitType.addRepresentationType(new DynamicRepresentationType("raster", Interval.class, Surface.class, GeometryImplType.RASTER));
        trameUnitType.addAttributeType(DynamicElementTypeFactory.createAttributeType("type", null, String.class));
        trameUnitType.addAttributeType(DynamicElementTypeFactory.createAttributeType("cover", Interval.class, CoverUnit.class));
        trameUnitType.setCondition("trame");
        DynamicLayerType trameAreaType = new DynamicLayerType("area", (Class<? extends DynamicLayer>)TrameArea.class);
        trameAreaType.addElementType(trameUnitType);
        DynamicLayerType territoryType = new DynamicLayerType(Territory.class);
        territoryType.addRepresentationType(new DynamicRepresentationType("raster", Interval.class, Surface.class, GeometryImplType.RASTER));
        territoryType.addElementType(agriculturalAreaType);
        territoryType.addElementType(trameAreaType);
        Territory territory = (Territory)DynamicLayerFactory.initWithShape(shape, t, territoryType, "type", parcelType, facilityType, trameUnitType);
        for (FarmTerritory ft : (AgriculturalArea)territory.get("AA")) {
            for (Object fu : ft) {
                if (!(fu instanceof Parcel)) continue;
                ((AbstractDynamicElement)fu).getAttribute("area").setValue(t, Double.valueOf(((DefaultDynamicFeature)fu).getArea(t)));
            }
        }
        for (FarmTerritory ft : (AgriculturalArea)territory.get("AA")) {
            for (Facility b : ft.facilities()) {
                if (b.getAttribute("facility").isActive(t)) {
                    String[] mp;
                    for (String m : mp = ((String)b.getAttribute("facility").getValue(t)).split(";")) {
                        b.addFacility(m);
                    }
                }
                b.getAttribute("cover").setValue(t, CoverManager.getCoverUnit("MP", "MP"));
            }
        }
        if (territory.contains("TA")) {
            for (TrameUnit tu : (TrameArea)territory.get("TA")) {
                String occsol;
                switch (occsol = (String)tu.getAttribute("occsol").getValue(t)) {
                    case "Bati": {
                        tu.getAttribute("cover").setValue(t, CoverManager.getCoverUnit("BA", "BA"));
                        break;
                    }
                    case "BE": {
                        tu.getAttribute("cover").setValue(t, CoverManager.getCoverUnit("BE", "BE"));
                        break;
                    }
                    case "Bois": {
                        tu.getAttribute("cover").setValue(t, CoverManager.getCoverUnit("WO", "WO"));
                        break;
                    }
                    case "Eau": {
                        tu.getAttribute("cover").setValue(t, CoverManager.getCoverUnit("WA", "WA"));
                        break;
                    }
                    case "Prairie": {
                        tu.getAttribute("cover").setValue(t, CoverManager.getCoverUnit("PP", "PP"));
                        break;
                    }
                    case "Route": {
                        tu.getAttribute("cover").setValue(t, CoverManager.getCoverUnit("RO", "RO"));
                        break;
                    }
                    case "Haie": {
                        tu.getAttribute("cover").setValue(t, CoverManager.getCoverUnit("HA", "Haie"));
                        break;
                    }
                    case "Chemin": {
                        tu.getAttribute("cover").setValue(t, CoverManager.getCoverUnit("CH", "Chemin"));
                    }
                }
            }
        }
        return territory;
    }
}

