/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul;

import fr.inra.sad.bagap.apiland.capfarm.CAPFarm;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Territory;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmMode;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmProcessMode;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.YearDelay;
import fr.inra.sad.bagap.apiland.simul.OutputAnalysis;
import fr.inra.sad.bagap.apiland.simul.SimulationManager;
import java.net.URL;
import java.util.LinkedList;

public class CfmManager
extends SimulationManager {
    private static final long serialVersionUID = 1L;
    private Territory territory;
    private LinkedList<OutputAnalysis> outputs;
    private CfmMode mode = CfmMode.IDLE;
    private CfmProcessMode processMode = CfmProcessMode.ACTIVATE;
    private String paramProcessMode;
    private String methodProcessMode;
    private String probaTimeFolder;
    private String economicProfil;
    private String workProfil;
    private String distanceCoversProfil;
    private boolean check;

    public CfmManager(int s) {
        super(s);
        this.setDelay(new YearDelay(1));
        this.outputs = new LinkedList();
        this.check = false;
        URL url = CfmManager.class.getResource("proba_times/");
        System.out.println(url);
        if (url != null) {
            this.probaTimeFolder = url.toString();
        }
    }

    @Override
    public void setStart(Instant t) {
        CAPFarm.t = t;
        super.setStart(t);
    }

    public void setMode(CfmMode mode) {
        this.mode = mode;
    }

    public void setProcessMode(CfmProcessMode mode, String paramProcessMode, String methodProcessMode) {
        this.processMode = mode;
        this.paramProcessMode = paramProcessMode;
        this.methodProcessMode = methodProcessMode;
    }

    public void setProcessMode(CfmProcessMode mode, String paramProcessMode) {
        this.processMode = mode;
        this.paramProcessMode = paramProcessMode;
    }

    public String methodProcessMode() {
        return this.methodProcessMode;
    }

    public String paramProcessMode() {
        return this.paramProcessMode;
    }

    public void setTerritory(Territory territory) {
        this.territory = territory;
    }

    public void setEconomicProfil(String economicProfil) {
        this.economicProfil = economicProfil;
    }

    public void setManagmentProfil(String workProfil, String distanceCoversProfil) {
        this.workProfil = workProfil;
        this.distanceCoversProfil = distanceCoversProfil;
    }

    public void addOutput(OutputAnalysis output) {
        this.outputs.add(output);
    }

    public Territory territory() {
        return this.territory;
    }

    public LinkedList<OutputAnalysis> outputs() {
        return this.outputs;
    }

    public CfmMode mode() {
        return this.mode;
    }

    public CfmProcessMode processMode() {
        return this.processMode;
    }

    public String probaTimeFolder() {
        return this.probaTimeFolder;
    }

    public boolean checkConstraints() {
        return this.check;
    }

    public void checkConstraints(boolean check) {
        this.check = check;
    }

    public String economicProfil() {
        return this.economicProfil;
    }

    public String workProfil() {
        return this.workProfil;
    }

    public String distanceCoversProfil() {
        return this.distanceCoversProfil;
    }

    public void setProbaTimeFolder(String probaTimeFolder) {
        this.probaTimeFolder = probaTimeFolder;
    }
}

