/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintBuilder;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CSPCoverLocationStrategy;
import fr.inra.sad.bagap.apiland.capfarm.simul.graph.Arc;
import fr.inra.sad.bagap.apiland.capfarm.simul.graph.Graph;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.search.strategy.ISF;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.util.tools.ArrayUtils;

public class DecoupageCSPCoverLocationStrategy
extends CSPCoverLocationStrategy {
    private ConstraintBuilder cb;
    private static final int max = 5;
    private Graph<Parcel> graph;

    public DecoupageCSPCoverLocationStrategy(CoverAllocator allocator) {
        this.init(allocator);
    }

    private void init(CoverAllocator allocator) {
        this.cb = new ConstraintBuilder(allocator);
        HashMap pgps = new HashMap();
        for (Parcel p : allocator.parcels()) {
            int pgp = p.getPGP();
            if (pgp == -1) continue;
            if (!pgps.containsKey(pgp)) {
                pgps.put(pgp, new HashSet());
            }
            ((Set)pgps.get(pgp)).add(p);
        }
        this.graph = new Graph();
        HashSet<Parcel> ever = new HashSet<Parcel>();
        for (Set set : pgps.values()) {
            ever.clear();
            for (Parcel p1 : set) {
                ever.add(p1);
                for (Parcel p2 : set) {
                    if (ever.contains(p2) || !p1.getShape().intersects(p2.getShape())) continue;
                    this.graph.addArc(p1, p2);
                }
            }
        }
        this.graph.detectCycles();
    }

    private ArrayList<Arc<Parcel>> getDecoupage(int nb) {
        Solver solver = new Solver("decoupage");
        BoolVar[] boolArcs = new BoolVar[this.graph.countArcs()];
        for (int i = 0; i < this.graph.countArcs(); ++i) {
            boolArcs[i] = VF.bool((String)("ba_" + i), (Solver)solver);
        }
        IntVar sum = VF.bounded((String)"sum", (int)0, (int)this.graph.countArcs(), (Solver)solver);
        solver.post(ICF.sum((BoolVar[])boolArcs, (IntVar)sum));
        solver.post(ICF.arithm((IntVar)sum, (String)"=", (int)nb));
        long r = new Double(Math.random() * 1.0E9).longValue();
        solver.set(new AbstractStrategy[]{ISF.random((IntVar[])((IntVar[])ArrayUtils.append((Object[][])new BoolVar[][]{boolArcs})), (long)r)});
        ArrayList<Arc<Parcel>> liaisons = new ArrayList<Arc<Parcel>>();
        if (solver.findSolution()) {
            for (int i = 0; i < this.graph.countArcs(); ++i) {
                if (boolArcs[i].getValue() != 0) continue;
                liaisons.add(this.graph.getArc(i));
            }
        }
        return liaisons;
    }

    @Override
    public boolean make(CoverAllocationProblemFactory factory, CoverAllocator allocator, Instant t) {
        for (int a = 0; a < this.graph.countArcs(); ++a) {
            for (int i = 0; i < 5; ++i) {
                ArrayList<Arc<Parcel>> liaisons = this.getDecoupage(a);
                for (Arc<Parcel> arc : liaisons) {
                }
                if (!factory.create(allocator, t).execute()) continue;
                return true;
            }
        }
        return false;
    }
}

