/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul;

import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.Farm;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmSimulator;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverLocationModel;
import fr.inra.sad.bagap.apiland.core.composition.DynamicAttribute;
import fr.inra.sad.bagap.apiland.core.composition.DynamicAttributeType;
import fr.inra.sad.bagap.apiland.core.composition.TemporalValue;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Map;
import java.util.TreeMap;

public class MemoryCoverLocationModel
extends CoverLocationModel {
    private static final long serialVersionUID = 1L;
    private Map<String, DynamicAttribute<CoverUnit>> covers = new TreeMap<String, DynamicAttribute<CoverUnit>>();
    private boolean quiet;

    public MemoryCoverLocationModel(CfmSimulator simulator, Farm farm) {
        this(simulator, farm, false);
    }

    public MemoryCoverLocationModel(CfmSimulator simulator, Farm farm, boolean quiet) {
        super(simulator, farm);
        this.quiet = quiet;
    }

    @Override
    public boolean make(Instant t) {
        if (!this.quiet) {
            for (Parcel p : this.getCoverAllocator().parcels()) {
                if (!((TemporalValue)this.covers.get(p.getId()).getActive(t)).getTime().start().equals(t)) continue;
                p.getAttribute("cover").setValue(t, this.covers.get(p.getId()).getValue(t));
            }
        }
        return true;
    }

    public void initParcel(String id, DynamicAttributeType type) {
        this.covers.put(id, new DynamicAttribute(type));
    }

    public void setCover(String parcel, CoverUnit cover, Instant year) {
        this.covers.get(parcel).setValue(year, cover);
    }

    public CoverUnit getCover(String parcel, Instant t) {
        return this.covers.get(parcel).getValue(t);
    }
}

