/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.ecological;

import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.simul.ecological.EcologicalModelAnalysis;
import fr.inra.sad.bagap.apiland.capfarm.simul.ecological.EcologicalModelManager;
import fr.inra.sad.bagap.apiland.capfarm.simul.ecological.EcologicalModelMetric;
import java.util.ArrayList;
import java.util.List;

public class EcologicalModelBuilder {
    private String name;
    private double intercept;
    private List<EcologicalModelMetric> metrics = new ArrayList<EcologicalModelMetric>();
    private List<Double> coeffs = new ArrayList<Double>();

    public EcologicalModelBuilder() {
        this.reset();
    }

    private void reset() {
        this.name = null;
        this.intercept = Double.NaN;
        this.metrics.clear();
        this.coeffs.clear();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIntercept(double intercept) {
        this.intercept = intercept;
    }

    public void setMetric(String metric, int buffer, double coeff) {
        this.metrics.add(new EcologicalModelMetric(metric, buffer));
        this.coeffs.add(coeff);
    }

    public void setFilter(Cover cover) {
    }

    public EcologicalModelAnalysis build() {
        EcologicalModelAnalysis model = new EcologicalModelAnalysis(this.name, this.intercept, null, null, this.coeffs.toArray(new Double[this.coeffs.size()]), this.metrics.toArray(new EcologicalModelMetric[this.metrics.size()]));
        EcologicalModelManager.add(model);
        this.reset();
        return model;
    }
}

