/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.output;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.simul.OutputAnalysis;
import fr.inra.sad.bagap.apiland.simul.Scenario;
import fr.inra.sad.bagap.apiland.simul.Simulation;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class CoverSurfaceOutput
extends OutputAnalysis {
    private DecimalFormat format;
    private String csv;
    private CsvWriter cw;

    public CoverSurfaceOutput(String csv) {
        this.csv = csv;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        this.format = new DecimalFormat("0.00", symbols);
    }

    @Override
    public void init(Scenario scenario) {
        try {
            for (CoverLocationModel model : (GlobalCoverLocationModel)scenario.model().get("agriculture")) {
                this.cw = new CsvWriter(this.csv);
                this.cw.setDelimiter(';');
                this.cw.write("simulation");
                this.cw.write("farm");
                this.cw.write("year");
                for (Cover cover : model.getCoverAllocator().coverUnits()) {
                    this.cw.write(cover + "");
                }
                this.cw.endRecord();
            }
        }
        catch (CsvWriter.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close(Scenario scenario) {
        this.cw.close();
    }

    @Override
    public void close(Simulation simulation) {
        if (!simulation.isCancelled()) {
            try {
                for (CoverLocationModel model : (GlobalCoverLocationModel)simulation.model().get("agriculture")) {
                    for (int y = simulation.manager().start().year(); y <= simulation.manager().end().year(); ++y) {
                        this.cw.write("" + simulation.number());
                        this.cw.write("" + model.getCoverAllocator().getCode());
                        this.cw.write(y + "");
                        for (Cover cover : model.getCoverAllocator().coverUnits()) {
                            double area = 0.0;
                            for (Parcel p : model.getCoverAllocator().parcels()) {
                                if (cover instanceof CoverUnit) {
                                    if (!p.getAttribute("cover").hasValue(cover, new Instant(simulation.manager().start().dayOfYear(), simulation.manager().start().month(), y))) continue;
                                    area += (double)p.getArea() / 10000.0;
                                    continue;
                                }
                                for (CoverUnit cu : (CoverGroup)cover) {
                                    if (!p.getAttribute("cover").hasValue(cu, new Instant(simulation.manager().start().dayOfYear(), simulation.manager().start().month(), y))) continue;
                                    area += (double)p.getArea() / 10000.0;
                                }
                            }
                            this.cw.write("" + this.format.format(area));
                        }
                        this.cw.endRecord();
                    }
                }
            }
            catch (CsvWriter.FinalizedException | IOException e) {
                e.printStackTrace();
            }
        }
    }
}

