/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.output;

import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverManager;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.core.composition.StaticAttribute;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementTypeFactory;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.simul.OutputAnalysis;
import fr.inra.sad.bagap.apiland.simul.Simulation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ShapefileBySimulationOutput
extends OutputAnalysis {
    @Override
    public void close(Simulation simulation) {
        if (!simulation.isCancelled()) {
            HashMap count = new HashMap();
            for (CoverLocationModel model : (GlobalCoverLocationModel)simulation.model().get("agriculture")) {
                for (Parcel p : model.getCoverAllocator().parcels()) {
                    count.put(p, new HashMap());
                    for (CoverUnit coverUnit : CoverManager.coverUnits()) {
                        if (!p.getType().hasAttributeType("nb_" + coverUnit.getCode())) {
                            p.getType().addAttributeType(DynamicElementTypeFactory.createAttributeType("nb_" + coverUnit.getCode(), null, Integer.class));
                        }
                        p.getComposition().addAttribute(new StaticAttribute(DynamicElementTypeFactory.createAttributeType("nb_" + coverUnit.getCode(), null, Integer.class)));
                        ((Map)count.get(p)).put(coverUnit, 0);
                    }
                }
            }
            for (CoverLocationModel model : (GlobalCoverLocationModel)simulation.model().get("agriculture")) {
                for (Parcel p : model.getCoverAllocator().parcels()) {
                    Instant t = simulation.manager().start();
                    while (t.isBefore(simulation.manager().end()) || t.equals(simulation.manager().end())) {
                        CoverUnit coverUnit = (CoverUnit)p.getAttribute("cover").getValue(t);
                        ((Map)count.get(p)).put(coverUnit, (Integer)((Map)count.get(p)).get(coverUnit) + 1);
                        t = simulation.manager().delay().next(t);
                    }
                    for (CoverUnit c : CoverManager.coverUnits()) {
                        p.getAttribute("nb_" + c.getCode()).setValue(simulation.manager().start(), (Serializable)((Map)count.get(p)).get(c));
                    }
                }
            }
            for (CoverLocationModel model : (GlobalCoverLocationModel)simulation.model().get("agriculture")) {
                DynamicLayerFactory.exportShape(model.getCoverAllocator().getTerritory(), simulation.manager().start(), simulation.scenario().folder() + "count_cover_by_simulation");
            }
            for (CoverLocationModel model : (GlobalCoverLocationModel)simulation.model().get("agriculture")) {
                Parcel p;
                Iterator<Parcel> iterator = model.getCoverAllocator().parcels().iterator();
                if (!iterator.hasNext()) continue;
                p = iterator.next();
                for (Cover cover : CoverManager.coverUnits()) {
                    model.getCoverAllocator().getTerritory().getType().removeAttributeType("nb_" + cover.getCode());
                }
            }
        }
    }
}

