/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.cluster;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import java.util.HashSet;
import java.util.Set;

public class Cluster {
    private int value;
    private int[] filter;
    private int width;
    private int height;
    private Pixel corner;
    private int minx;
    private int maxx;
    private int miny;
    private int maxy;
    private Set<Pixel> pixels;
    private int theoriticalSize;
    private boolean isInit;

    public Cluster(int value) {
        this.value = value;
        this.minx = Integer.MAX_VALUE;
        this.maxx = -1;
        this.miny = Integer.MAX_VALUE;
        this.maxy = -1;
        this.pixels = new HashSet<Pixel>();
        this.isInit = false;
    }

    public Cluster(int value, int width, int height, int minx, int miny, int size, int[] filter) {
        this.value = value;
        this.width = width;
        this.height = height;
        this.corner = new Pixel(minx, miny);
        this.theoriticalSize = size;
        this.filter = filter;
        this.isInit = true;
    }

    public int getValue() {
        return this.value;
    }

    public int width() {
        if (!this.isInit) {
            this.init();
        }
        return this.width;
    }

    public int height() {
        if (!this.isInit) {
            this.init();
        }
        return this.height;
    }

    public Pixel getCorner() {
        if (!this.isInit) {
            this.init();
        }
        return this.corner;
    }

    public int theoriticalSize() {
        if (!this.isInit) {
            this.init();
        }
        return this.theoriticalSize;
    }

    public int minx() {
        if (!this.isInit) {
            this.init();
        }
        return this.minx;
    }

    public int miny() {
        if (!this.isInit) {
            this.init();
        }
        return this.miny;
    }

    public void setPixel(Pixel p) {
        this.pixels.add(p);
        this.theoriticalSize = this.pixels.size();
        this.minx = Math.min(this.minx, p.x());
        this.maxx = Math.max(this.maxx, p.x());
        this.miny = Math.min(this.miny, p.y());
        this.maxy = Math.max(this.maxy, p.y());
    }

    private void init() {
        if (!this.isInit) {
            int x;
            int y;
            this.corner = new Pixel(this.minx, this.miny);
            this.width = this.maxx - this.minx + 1;
            this.height = this.maxy - this.miny + 1;
            this.filter = new int[this.width * this.height];
            int index = 0;
            for (y = this.miny; y < this.miny + this.height; ++y) {
                for (x = this.minx; x < this.minx + this.width; ++x) {
                    Pixel p = new Pixel(x, y);
                    this.filter[index++] = this.pixels.contains(p) ? 1 : 0;
                }
            }
            this.pixels.clear();
            this.pixels = null;
            index = 0;
            for (int x2 = 0; x2 < this.width; ++x2) {
                if (x2 == 0) {
                    if (this.filter[index] != 0) {
                        this.filter[index] = 4;
                    }
                } else if (this.filter[index] != 0) {
                    this.filter[index] = this.filter[index - 1] != 0 ? 2 : 4;
                }
                ++index;
            }
            for (y = 1; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    if (x == 0) {
                        if (this.filter[index] != 0) {
                            this.filter[index] = this.filter[index - this.width] != 0 ? 3 : 4;
                        }
                    } else if (this.filter[index] != 0) {
                        if (this.filter[index - 1] == 0) {
                            this.filter[index] = this.filter[index - this.width] == 0 ? 4 : 3;
                        } else if (this.filter[index - this.width] == 0) {
                            this.filter[index] = 2;
                        }
                    }
                    ++index;
                }
            }
            this.isInit = true;
        }
    }

    public int filter(int wx, int wy) {
        if (!this.isInit) {
            this.init();
        }
        return this.filter[wy * this.width() + wx];
    }
}

