/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.element;

import fr.inra.sad.bagap.apiland.core.change.Changeable;
import fr.inra.sad.bagap.apiland.core.change.ChangeableObject;
import fr.inra.sad.bagap.apiland.core.change.ChangeableObserver;
import fr.inra.sad.bagap.apiland.core.composition.Attribute;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.element.IdManager;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementType;
import fr.inra.sad.bagap.apiland.core.structure.Representation;
import fr.inra.sad.bagap.apiland.core.structure.Structure;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.TimeException;

public abstract class AbstractDynamicElement
implements DynamicElement {
    private static final long serialVersionUID = 1L;
    private String id;
    private Composition composition;
    private Structure structure;
    private DynamicElementType type;
    private DynamicLayer<?> layer;
    private ChangeableObject changeable;

    public AbstractDynamicElement(DynamicElementType type) {
        this.setType(type);
        this.changeable = new ChangeableObject();
        this.id = IdManager.get().getId();
    }

    @Override
    public int compareTo(DynamicElement e) {
        return this.id.compareTo(e.getId());
    }

    @Override
    public AbstractDynamicElement clone() {
        try {
            AbstractDynamicElement clone = (AbstractDynamicElement)super.clone();
            if (this.composition != null) {
                clone.composition = this.composition.clone();
            }
            if (this.structure != null) {
                clone.structure = this.structure.clone();
            }
            clone.type = this.type.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getInheritedId(String idName) {
        if (this.type.getIdName().equalsIgnoreCase(idName)) {
            return this.id;
        }
        if (this.getLayer() != null) {
            return this.getLayer().getInheritedId(idName);
        }
        return "";
    }

    @Override
    public Attribute<?> getInheritedAttribute(String attName) {
        if (this.getType().hasAttributeType(attName)) {
            return this.getAttribute(attName);
        }
        if (this.getLayer() != null) {
            return this.getLayer().getInheritedAttribute(attName);
        }
        throw new IllegalArgumentException("attribute '" + attName + "' does not exist");
    }

    @Override
    public void setLayer(DynamicLayer<?> layer) {
        this.layer = layer;
    }

    @Override
    public DynamicLayer<?> getLayer() {
        return this.layer;
    }

    @Override
    public void setType(DynamicElementType type) {
        this.type = type;
    }

    @Override
    public DynamicElementType getType() {
        return this.type;
    }

    @Override
    public void update(Instant t, Changeable c, Object o) {
        this.notifyObservers(t, this, o);
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        this.changeable.addObserver(o);
        this.composition.addObserver(o);
        this.structure.addObserver(o);
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        this.changeable.removeObserver(o);
        this.composition.removeObserver(o);
        this.structure.removeObserver(o);
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        this.changeable.notifyObservers(t, c, o);
    }

    @Override
    public void kill(Instant t) throws TimeException {
        this.composition.kill(t);
        this.structure.kill(t);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.composition.hasAttribute(name);
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        if (this.composition.hasAttribute(name)) {
            return this.composition.getAttribute(name);
        }
        if (this.layer != null) {
            return this.layer.getAttribute(name);
        }
        throw new IllegalArgumentException("attribute '" + name + "' does not exist");
    }

    @Override
    public Composition getComposition() {
        return this.composition;
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public boolean hasRepresentation(String name) {
        return this.structure.hasRepresentation(name);
    }

    @Override
    public void setComposition(Composition composition) {
        this.composition = composition;
        this.composition.addObserver(this);
    }

    @Override
    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    @Override
    public Representation<?> getDefaultRepresentation() {
        return this.structure.getDefaultRepresentation();
    }

    @Override
    public Representation<?> getRepresentation(String name) {
        return this.structure.getRepresentation(name);
    }

    @Override
    public int count(Instant t, DynamicElementType ... types) {
        for (DynamicElementType type : types) {
            if (!this.getType().equals(type)) continue;
            if (this.isActive(t)) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public Instant getLastChange() {
        if (this.getComposition() != null) {
            return this.getComposition().getLastChange();
        }
        return null;
    }

    @Override
    public double maxX() {
        return this.structure.maxX();
    }

    @Override
    public double maxY() {
        return this.structure.maxY();
    }

    @Override
    public double minX() {
        return this.structure.minX();
    }

    @Override
    public double minY() {
        return this.structure.minY();
    }

    @Override
    public void delete() {
        this.id = null;
        if (this.composition != null) {
            this.composition.delete();
            this.composition = null;
        }
        if (this.structure != null) {
            this.structure.delete();
            this.structure = null;
        }
        this.layer = null;
        this.changeable.delete();
        this.changeable = null;
        this.type = null;
    }
}

