/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.element.decorator;

import fr.inra.sad.bagap.apiland.core.change.Changeable;
import fr.inra.sad.bagap.apiland.core.change.ChangeableObject;
import fr.inra.sad.bagap.apiland.core.change.ChangeableObserver;
import fr.inra.sad.bagap.apiland.core.composition.Attribute;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.decorator.AbstractDynamicElementDecorator;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementType;
import fr.inra.sad.bagap.apiland.core.structure.Structure;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Time;

public abstract class CompositionDecorator<E extends DynamicElement>
extends AbstractDynamicElementDecorator<E> {
    private static final long serialVersionUID = 1L;
    protected Composition composition = new Composition();
    private ChangeableObject changeable = new ChangeableObject();
    private Time time;

    public CompositionDecorator(E element, DynamicElementType type) {
        super(element, type);
    }

    @Override
    public CompositionDecorator<E> clone() {
        CompositionDecorator clone = (CompositionDecorator)super.clone();
        clone.changeable = new ChangeableObject();
        clone.composition = this.composition.clone();
        clone.decorate = this.decorate;
        clone.time = this.time;
        return clone;
    }

    @Override
    public void setStructure(Structure structure) {
        throw new UnsupportedOperationException("set no structure to the composition decorator");
    }

    @Override
    public void setComposition(Composition composition) {
        this.composition = composition;
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        if (this.decorate.hasAttribute(name)) {
            return this.decorate.getAttribute(name);
        }
        if (this.composition.hasAttribute(name)) {
            return this.composition.getAttribute(name);
        }
        return this.getComposition().getAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name) {
        if (this.decorate.hasAttribute(name)) {
            return true;
        }
        if (this.composition.hasAttribute(name)) {
            return true;
        }
        return this.getComposition().hasAttribute(name);
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        this.changeable.addObserver(o);
        this.decorate.addObserver(o);
        this.getComposition().addObserver(o);
        this.getStructure().addObserver(o);
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        this.changeable.removeObserver(o);
        this.getComposition().removeObserver(o);
        this.getStructure().removeObserver(o);
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        this.changeable.notifyObservers(t, c, o);
    }

    @Override
    public Instant getLastChange() {
        Instant t = this.decorate.getLastChange();
        Instant n = this.getComposition().getLastChange();
        if (t == null || n != null && n.isAfter(t)) {
            t = n;
        }
        return t;
    }

    @Override
    public void delete() {
        super.delete();
        this.composition.delete();
        this.composition = null;
        this.changeable.delete();
        this.changeable = null;
        this.time = null;
    }
}

