/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster;

import fr.inra.sad.bagap.apiland.core.element.DynamicFeature;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.ArrayMatrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.ArrayMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class RasterManager {
    public static Matrix exportMatrix(DynamicLayer<?> layer, String name, Instant t, Map<String, String> map, String cercle, double buffer) {
        try {
            ShpFiles sf = new ShpFiles(cercle);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            Polygon polygon = (Polygon)((MultiPolygon)sfr.nextRecord().shape()).getGeometryN(0);
            sfr.close();
            return RasterManager.exportMatrix(layer, name, t, map, polygon, buffer);
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException();
    }

    public static Matrix exportMatrix(DynamicLayer<?> layer, String name, Instant t, Map<String, String> map, Polygon cercle, double buffer) {
        double minX = cercle.getEnvelopeInternal().getMinX() - buffer;
        double maxX = cercle.getEnvelopeInternal().getMaxX() + buffer;
        double minY = cercle.getEnvelopeInternal().getMinY() - buffer;
        double maxY = cercle.getEnvelopeInternal().getMaxY() + buffer;
        return RasterManager.exportMatrix(layer, name, Raster.getCellSize(), t, map, minX, maxX, minY, maxY);
    }

    public static Matrix exportMatrix(DynamicLayer<?> layer, String name, double cellsize, Instant t, Map<String, String> map, double minX, double maxX, double minY, double maxY) {
        int ncols = new Double(Math.floor((maxX - minX) / cellsize)).intValue();
        int nrows = new Double(Math.floor((maxY - minY) / cellsize)).intValue();
        ArrayMatrix m = ArrayMatrixFactory.get().create(ncols, nrows, cellsize, minX, maxX, minY, maxY, Raster.getNoDataValue());
        m.init(m.noDataValue());
        Iterator ite = layer.deepIterator();
        while (ite.hasNext()) {
            int y;
            int x;
            DynamicFeature f = (DynamicFeature)ite.next();
            int value = Raster.getNoDataValue();
            if (f.hasAttribute(name)) {
                if (f.getAttribute(name).getValue(t) != null) {
                    value = map != null ? Integer.parseInt(map.get(f.getAttribute(name).getValue(t).toString())) : Integer.parseInt(f.getAttribute(name).getValue(t).toString());
                }
                if (!f.getRepresentation("raster").isActive(t)) continue;
                for (Pixel p : (Raster)((Geometry)f.getRepresentation("raster").getGeometry(t)).get()) {
                    x = p.x();
                    if (!m.contains(x, y = p.y())) continue;
                    m.put(x, y, value);
                }
                continue;
            }
            if (!f.getLayer().getType().hasIdName(name)) continue;
            String lid = f.getLayer().getId();
            value = map != null ? Integer.parseInt(map.get(lid)) : Integer.parseInt(lid);
            if (!f.getRepresentation("raster").isActive(t)) continue;
            for (Pixel p : (Raster)((Geometry)f.getRepresentation("raster").getGeometry(t)).get()) {
                x = p.x();
                if (!m.contains(x, y = p.y())) continue;
                m.put(x, y, value);
            }
        }
        return m;
    }

    public static Matrix exportMatrix(DynamicLayer<?> layer, String name, Instant t) {
        return RasterManager.exportMatrix(layer, name, Raster.getCellSize(), t, null, -1.0, -1.0, -1.0, -1.0);
    }

    public static Matrix exportMatrix(DynamicLayer<?> layer, String name, Instant t, Map<String, Integer> map) {
        return RasterManager.exportMatrix2(layer, name, t, map, layer.minX(), layer.maxX(), layer.minY(), layer.maxY());
    }

    public static Matrix exportMatrix2(DynamicLayer<?> layer, String name, Instant t, Map<String, Integer> map, double minX, double maxX, double minY, double maxY) {
        int ty;
        int tx;
        if (minX == -1.0 && maxX == -1.0 && minY == -1.0 && maxY == -1.0) {
            minX = layer.minX();
            maxX = layer.maxX();
            minY = layer.minY();
            maxY = layer.maxY();
            tx = 0;
            ty = 0;
        } else {
            tx = new Double(Math.floor((minX - layer.minX()) / Raster.getCellSize()) + 1.0).intValue();
            ty = new Double(Math.floor((layer.maxY() - maxY) / Raster.getCellSize()) + 1.0).intValue();
        }
        int ncols = new Double(Math.floor((maxX - minX) / Raster.getCellSize()) + 1.0).intValue();
        int nrows = new Double(Math.floor((maxY - minY) / Raster.getCellSize()) + 1.0).intValue();
        ArrayMatrix m = ArrayMatrixFactory.get().create(ncols, nrows, Raster.getCellSize(), minX, maxX, minY, maxY, Raster.getNoDataValue());
        m.init(m.noDataValue());
        for (int j = 0; j < nrows; ++j) {
            for (int i = 0; i < ncols; ++i) {
            }
        }
        Iterator ite = layer.deepIterator();
        while (ite.hasNext()) {
            DynamicFeature f = (DynamicFeature)ite.next();
            int value = map != null ? map.get(f.getAttribute(name).getValue(t).toString()).intValue() : ((Integer)f.getAttribute(name).getValue(t)).intValue();
            if (f.getRepresentation("raster").getGeometry(t) == null) continue;
            for (Pixel p : (Raster)((Geometry)f.getRepresentation("raster").getGeometry(t)).get()) {
                int y;
                int x = p.x() - tx;
                if (!m.contains(x, y = p.y() - ty)) continue;
                m.put(x, y, value);
            }
        }
        return m;
    }

    public static Matrix exportMatrix(Raster r, Matrix ref) {
        Matrix m = MatrixFactory.get(ref.getType()).create(ref.width(), ref.height(), ref.cellsize(), ref.minX(), ref.maxX(), ref.minY(), ref.maxY(), ref.noDataValue());
        m.init(Raster.getNoDataValue());
        for (Raster rr : ((RasterComposite)r).getRasters()) {
            int value = ((PixelComposite)rr).getValue();
            for (Pixel p : rr) {
                m.put(p, (double)value);
            }
        }
        return m;
    }
}

