/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import com.csvreader.CsvReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Friction {
    private Map<Float, Float> r = new HashMap<Float, Float>();
    private float min = Float.MAX_VALUE;

    public Friction(String f) {
        this.read(f);
    }

    private void read(String f) {
        try {
            CsvReader cr = new CsvReader(f, ';');
            cr.readHeaders();
            while (cr.readRecord()) {
                this.r.put(Float.valueOf(Float.parseFloat(cr.get("code"))), Float.valueOf(Float.parseFloat(cr.get("friction"))));
                this.min = Math.min(this.min, Float.parseFloat(cr.get("friction")));
            }
            cr.close();
        }
        catch (CsvReader.FinalizedException ex) {
            ex.printStackTrace();
        }
        catch (CsvReader.CatastrophicException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public float min() {
        return this.min;
    }

    public double get(double v) {
        return this.r.get(v).floatValue();
    }

    public Map<Float, Float> getMap() {
        return this.r;
    }

    public void display() {
        for (Map.Entry<Float, Float> e : this.r.entrySet()) {
            System.out.println(e.getKey() + " --> " + e.getValue());
        }
    }
}

