/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import fr.inra.sad.bagap.apiland.core.util.VisuImageJ;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class MatrixManager {
    private static String epsg = "lambert93.prj";

    public static String epsg() {
        return epsg;
    }

    public static void visualize(String f) {
        File file = new File(f);
        if (file.isDirectory()) {
            for (File ff : file.listFiles()) {
                new VisuImageJ(ff.toString());
            }
        } else {
            new VisuImageJ(f);
        }
    }

    public static void visualize(Matrix m) {
        new VisuImageJ(m.getFile());
    }

    public static void exportAsciiGridAndVisualize(Matrix matrix, String name) {
        MatrixManager.exportAsciiGrid(matrix, name);
        MatrixManager.visualize(matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportAsciiGrid(Matrix matrix, String name) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(name));
            bw.write("ncols " + matrix.width());
            bw.newLine();
            bw.write("nrows " + matrix.height());
            bw.newLine();
            bw.write("xllcorner " + matrix.minX());
            bw.newLine();
            bw.write("yllcorner " + matrix.minY());
            bw.newLine();
            bw.write("cellsize " + matrix.cellsize());
            bw.newLine();
            bw.write("NODATA_value " + matrix.noDataValue());
            bw.newLine();
            for (int i = 0; i < matrix.height(); ++i) {
                for (int j = 0; j < matrix.width(); ++j) {
                    bw.write(matrix.get(j, i) + " ");
                }
                bw.newLine();
            }
            bw.close();
            matrix.setFile(name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(DynamicLayerFactory.class.getResourceAsStream(epsg), name.replace(".asc", "") + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void findAndReplace(String in, String out, String v1, String v2) {
        try {
            CsvReader cr = new CsvReader(in);
            CsvWriter cw = new CsvWriter(out);
            cr.setDelimiter(' ');
            cw.setDelimiter(' ');
            cr.readRecord();
            cw.write(cr.get(0));
            int ncols = new Integer(cr.get(1));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            while (cr.readRecord()) {
                for (int i = 0; i < ncols; ++i) {
                    if (cr.get(i).equalsIgnoreCase(v1)) {
                        cw.write(v2);
                        continue;
                    }
                    cw.write(cr.get(i));
                }
                cw.endRecord();
            }
            cr.close();
            cw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void findAndReplaceComma2Dot(String in, String out) {
        try {
            CsvReader cr = new CsvReader(in);
            CsvWriter cw = new CsvWriter(out);
            cr.setDelimiter(' ');
            cw.setDelimiter(' ');
            cr.readRecord();
            cw.write(cr.get(0));
            int ncols = new Integer(cr.get(1));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            cr.readRecord();
            cw.write(cr.get(0));
            cw.write(cr.get(1));
            cw.endRecord();
            DecimalFormatSymbols comma = new DecimalFormatSymbols();
            comma.setDecimalSeparator(',');
            DecimalFormat fcomma = new DecimalFormat("0.00000", comma);
            DecimalFormatSymbols dot = new DecimalFormatSymbols();
            dot.setDecimalSeparator('.');
            DecimalFormat fdot = new DecimalFormat("0.00000", dot);
            while (cr.readRecord()) {
                for (int i = 0; i < ncols; ++i) {
                    Number n = fcomma.parse(cr.get(i));
                    if (n instanceof Long) {
                        cw.write(n + "");
                        continue;
                    }
                    cw.write(fdot.format((Double)n));
                }
                cw.endRecord();
            }
            cr.close();
            cw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Matrix retile(Matrix m1, Matrix m2) {
        if (m1.cellsize() != m2.cellsize()) {
            throw new IllegalArgumentException("matrix have not the same cellsize");
        }
        return MatrixManager.retile(m1, m2.minX(), m2.minY(), m2.width(), m2.height());
    }

    public static Matrix retile(Matrix m, int dX, int dY, int ncols, int nrows) {
        Matrix mn = MatrixFactory.get(m.getType()).create(ncols, nrows, m.cellsize(), m.minX() + (double)dX * m.cellsize(), m.minX() + (double)dX * m.cellsize() + (double)ncols * m.cellsize(), m.minY() + (double)(m.height() - nrows - dY) * m.cellsize(), m.minY() + (double)(m.height() - nrows - dY) * m.cellsize() + (double)nrows * m.cellsize(), m.noDataValue());
        for (int j = 0; j < nrows; ++j) {
            for (int i = 0; i < ncols; ++i) {
                mn.put(i, j, m.get(i + dX, j + dY));
            }
        }
        return mn;
    }

    public static Matrix retile(Matrix m, double minx, double maxx, double miny, double maxy) {
        int ncols = new Double((maxx - minx) / m.cellsize()).intValue();
        int nrows = new Double((maxy - miny) / m.cellsize()).intValue();
        Matrix mn = MatrixFactory.get(m.getType()).create(ncols, nrows, m.cellsize(), minx, maxx, miny, maxy, m.noDataValue());
        int dX = new Double((minx - m.minX()) / m.cellsize()).intValue();
        int dY = new Double((miny - m.minY()) / m.cellsize()).intValue();
        for (int j = 0; j < nrows; ++j) {
            for (int i = 0; i < ncols; ++i) {
                mn.put(i, j, m.get(i + dX, j + dY));
            }
        }
        return mn;
    }

    public static Matrix retile(Matrix m, double xllcorner, double yllcorner, int ncols, int nrows) {
        Matrix mn = MatrixFactory.get(m.getType()).create(ncols, nrows, m.cellsize(), xllcorner, xllcorner + (double)ncols * m.cellsize(), yllcorner, yllcorner + (double)nrows * m.cellsize(), m.noDataValue());
        int dX = new Double((m.minX() - xllcorner) / m.cellsize()).intValue();
        int dY = new Double((m.minY() - yllcorner) / m.cellsize()).intValue();
        for (int j = 0; j < nrows; ++j) {
            for (int i = 0; i < ncols; ++i) {
                mn.put(i, j, m.get(i + dX, j + dY));
            }
        }
        return mn;
    }
}

