/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.structure;

import fr.inra.sad.bagap.apiland.core.change.Changeable;
import fr.inra.sad.bagap.apiland.core.change.ChangeableObserver;
import fr.inra.sad.bagap.apiland.core.dynamic.SpatioDynamic;
import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.space.GeometryFactory;
import fr.inra.sad.bagap.apiland.core.space.GeometryManager;
import fr.inra.sad.bagap.apiland.core.space.GeometryType;
import fr.inra.sad.bagap.apiland.core.space.Point;
import fr.inra.sad.bagap.apiland.core.space.impl.GeometryImplType;
import fr.inra.sad.bagap.apiland.core.spacetime.SpatioTemporal;
import fr.inra.sad.bagap.apiland.core.structure.DynamicRepresentationType;
import fr.inra.sad.bagap.apiland.core.structure.Representation;
import fr.inra.sad.bagap.apiland.core.structure.TemporalEntity;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import fr.inra.sad.bagap.apiland.core.time.Time;
import fr.inra.sad.bagap.apiland.core.time.TimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DynamicRepresentation<G extends Geometry>
extends Representation<G>
implements Iterable<TemporalEntity<G>> {
    private static final long serialVersionUID = 1L;
    private SpatioDynamic<TemporalEntity<G>> dynamic = new SpatioDynamic();

    public DynamicRepresentation(DynamicRepresentationType type) {
        super(type);
    }

    public DynamicRepresentation(String name, Class<? extends Time> temporal, Class<? extends GeometryType> spatial, GeometryImplType geometryType) {
        this(new DynamicRepresentationType(name, temporal, spatial, geometryType));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(' ');
        sb.append("temporal ");
        sb.append(this.getTemporalBinding());
        sb.append(" and spatial ");
        sb.append(this.getSpatialBinding());
        return sb.toString();
    }

    @Override
    public DynamicRepresentationType getType() {
        return (DynamicRepresentationType)super.getType();
    }

    public Class<? extends Time> getTemporalBinding() {
        return this.getType().getTemporalBinding();
    }

    @Override
    public Class<? extends GeometryType> getSpatialBinding() {
        return this.getType().getSpatialBinding();
    }

    @Override
    public Time getTime() {
        return this.dynamic.getTime();
    }

    @Override
    public boolean isActive(Instant t) {
        return this.dynamic.isActive(t);
    }

    @Override
    public void kill(Instant t) throws TimeException {
        this.dynamic.kill(t);
    }

    @Override
    public void setTime(Time t) {
        this.dynamic.setTime(t);
    }

    @Override
    public void setGeometry(Time t, G g) {
        if (this.getTemporalBinding().equals(t.getClass())) {
            this.dynamic.addTemporal(new TemporalEntity<G>(t, g));
            this.notifyObservers(t.start(), this, g);
            return;
        }
        if (this.getTemporalBinding().equals(Interval.class)) {
            if (this.dynamic.getLast() == null) {
                this.dynamic.addTemporal(new TemporalEntity<G>((Time)new Interval((Instant)t), g));
            } else if (((TemporalEntity)this.dynamic.getLast()).getTime().start().equals(t)) {
                Geometry geo = GeometryFactory.create(GeometryManager.add(((Geometry)((TemporalEntity)this.dynamic.getActive(t.start())).getGeometry()).get(), ((Geometry)g).get()));
                ((TemporalEntity)this.dynamic.getActive(t.start())).setGeometry(geo);
            } else {
                try {
                    ((TemporalEntity)this.dynamic.getLast()).kill((Instant)t);
                    this.dynamic.addTemporal(new TemporalEntity<G>((Time)new Interval((Instant)t), g));
                }
                catch (TimeException e) {
                    e.printStackTrace();
                }
            }
            this.notifyObservers(t.start(), this, g);
            return;
        }
        throw new IllegalArgumentException("representation '" + this.getName() + "' expected " + this.getTemporalBinding() + " and not " + t.getClass());
    }

    @Override
    public G getGeometry(Instant t) {
        for (SpatioTemporal st : this) {
            if (!st.isActive(t)) continue;
            return (G)st.getGeometry();
        }
        return null;
    }

    @Override
    public Iterator<TemporalEntity<G>> iterator() {
        return this.dynamic.iterator();
    }

    @Override
    public boolean isActive(Instant i, Point p) {
        for (SpatioTemporal st : this) {
            if (!st.isActive(i, p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getArea(Instant t) {
        return ((Geometry)((TemporalEntity)this.dynamic.getActive(t)).getGeometry()).getArea();
    }

    @Override
    public double getLength(Instant t) {
        return ((Geometry)((TemporalEntity)this.dynamic.getActive(t)).getGeometry()).getLength();
    }

    public Time getTimeForGeometry(Class<? extends Geometry> g) {
        Time t = null;
        for (TemporalEntity<G> e : this) {
            if (!e.getGeometry().equals(g)) continue;
            t = Time.add(t, e.getTime());
        }
        return t;
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> l = new ArrayList<Geometry>();
        for (SpatioTemporal st : this) {
            l.add(st.getGeometry());
        }
        return l;
    }

    public List<Geometry> getGeometries(Interval t) {
        ArrayList<Geometry> l = new ArrayList<Geometry>();
        for (SpatioTemporal st : this) {
            if (!st.getTime().intersects(t)) continue;
            l.add(st.getGeometry());
        }
        return l;
    }

    public Time getTimeForGeometry(Geometry g) {
        Time t = null;
        for (SpatioTemporal st : this) {
            if (!st.getGeometry().equals(g)) continue;
            t = Time.add(t, st.getTime());
        }
        return t;
    }

    @Override
    public void addObserver(ChangeableObserver o) {
        this.dynamic.addObserver(o);
    }

    @Override
    public void removeObserver(ChangeableObserver o) {
        this.dynamic.removeObserver(o);
    }

    @Override
    public void notifyObservers(Instant t, Changeable c, Object o) {
        this.dynamic.notifyObservers(t, c, o);
    }

    @Override
    public int size() {
        return this.dynamic.size();
    }

    @Override
    public void display() {
    }

    @Override
    public void addTemporal(TemporalEntity<G> t) {
        this.dynamic.addTemporal(t);
    }

    @Override
    public TemporalEntity<G> get(int index) {
        return (TemporalEntity)this.dynamic.get(index);
    }

    @Override
    public TemporalEntity<G> getActive(Instant t) {
        return (TemporalEntity)this.dynamic.getActive(t);
    }

    @Override
    public int getIndex(Instant t) {
        return this.dynamic.getIndex(t);
    }

    @Override
    public TemporalEntity<G> getLast() {
        return (TemporalEntity)this.dynamic.getLast();
    }

    @Override
    public Instant getLastChange() {
        return this.dynamic.getLastChange();
    }

    @Override
    public double minX() {
        double min = 9.99999999E8;
        for (TemporalEntity<G> e : this) {
            min = Math.min(min, ((Geometry)e.getGeometry()).minX());
        }
        return min;
    }

    @Override
    public double maxX() {
        double max = -9.99999999E8;
        for (TemporalEntity<G> e : this) {
            max = Math.max(max, ((Geometry)e.getGeometry()).maxX());
        }
        return max;
    }

    @Override
    public double minY() {
        double min = 9.99999999E8;
        for (TemporalEntity<G> e : this) {
            min = Math.min(min, ((Geometry)e.getGeometry()).minY());
        }
        return min;
    }

    @Override
    public double maxY() {
        double max = -9.99999999E8;
        for (TemporalEntity<G> e : this) {
            max = Math.max(max, ((Geometry)e.getGeometry()).maxY());
        }
        return max;
    }

    @Override
    public void delete() {
        super.delete();
        this.dynamic.delete();
        this.dynamic = null;
    }

    @Override
    public void removeTemporal(TemporalEntity<G> t) {
    }

    @Override
    public TemporalEntity<G> getFirst() {
        return null;
    }
}

