/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.time.delay;

import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import fr.inra.sad.bagap.apiland.core.time.Time;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;

public class MonthDelay
extends Delay {
    private static final long serialVersionUID = 1L;
    private int delay;

    public MonthDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public Instant next(Instant i) {
        int d;
        int y = Time.getYear(i);
        for (d = Time.getMonth(i) + this.delay; d > 12; d -= 12) {
            ++y;
        }
        return new Instant(Time.getDayOfMonth(i), d, y);
    }

    @Override
    public Instant previous(Instant i) {
        int d;
        int y = Time.getYear(i);
        for (d = Time.getMonth(i) - this.delay; d < 0; d += 12) {
            --y;
        }
        return new Instant(Time.getDayOfMonth(i), d, y);
    }

    @Override
    public Interval next(Interval t) {
        int de;
        int db;
        int yb = Time.getYear(t.start());
        for (db = Time.getMonth(t.start()) + this.delay; db > 12; db -= 12) {
            ++yb;
        }
        int ye = Time.getYear(t.end());
        for (de = Time.getMonth(t.end()) + this.delay; de > 12; de -= 12) {
            ++ye;
        }
        return new Interval(new Instant(Time.getDayOfMonth(t.start()), db, yb), new Instant(Time.getDayOfMonth(t.end()), de, ye));
    }

    @Override
    public Interval previous(Interval t) {
        int de;
        int db;
        int yb = Time.getYear(t.start());
        for (db = Time.getMonth(t.start()) - this.delay; db < 0; db += 12) {
            --yb;
        }
        int ye = Time.getYear(t.end());
        for (de = Time.getMonth(t.end()) - this.delay; de < 0; de += 12) {
            --ye;
        }
        return new Interval(new Instant(Time.getDayOfMonth(t.start()), db, yb), new Instant(Time.getDayOfMonth(t.end()), de, ye));
    }

    @Override
    public long get() {
        return this.delay;
    }
}

