/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul.model;

import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.simul.Simulator;
import fr.inra.sad.bagap.apiland.simul.model.Model;
import fr.inra.sad.bagap.apiland.simul.model.ModelIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CompositeModel<M extends Model>
extends Model
implements Collection<M> {
    private static final long serialVersionUID = 1L;
    private Map<String, M> models;
    private List<String> order;
    protected Delay delay;

    public CompositeModel(String name, Simulator simulator) {
        super(name, simulator);
        this.init(simulator.manager().delay());
    }

    public CompositeModel(String name, Instant start, Simulator simulator) {
        super(name, start, simulator);
        this.init(simulator.manager().delay());
    }

    public CompositeModel(String name, Delay delay, Simulator simulator) {
        super(name, simulator);
        this.init(delay);
    }

    public CompositeModel(String name, Instant start, Delay delay, Simulator simulator) {
        super(name, start, simulator);
        this.init(delay);
    }

    public CompositeModel(String name, Instant start, Delay delay, Simulator simulator, DynamicElement element) {
        super(name, start, simulator, element);
        this.init(delay);
    }

    private void init(Delay delay) {
        this.models = new HashMap<String, M>();
        this.order = new ArrayList<String>();
        this.delay = delay;
    }

    public void display() {
        System.out.println("model listing");
        for (Model m : this) {
            System.out.println(m);
        }
    }

    @Override
    public void initCurrent(Instant t) {
        this.setCurrent(t);
        for (Model m : this) {
            m.initCurrent(t);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append('\n');
        for (Model m : this) {
            sb.append('\t');
            sb.append(m);
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public int size() {
        return this.models.size();
    }

    @Override
    public boolean add(M model) {
        this.order.add(((Model)model).getName());
        this.models.put(((Model)model).getName(), model);
        ((Model)model).setParent(this);
        return true;
    }

    public void add(int index, M model) {
        this.order.add(index, ((Model)model).getName());
        this.models.put(((Model)model).getName(), model);
    }

    public M get(int index) {
        return (M)((Model)this.models.get(this.order.get(index)));
    }

    public M get(String name) {
        return (M)((Model)this.models.get(name));
    }

    @Override
    public boolean deepContains(String name) {
        if (this.getName().equalsIgnoreCase(name)) {
            return true;
        }
        for (Model m : this) {
            if (!m.deepContains(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Model deepGet(String name) {
        if (this.getName().equalsIgnoreCase(name)) {
            return this;
        }
        for (Model m : this) {
            if (!m.deepContains(name)) continue;
            return m.deepGet(name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean run(Instant t) {
        boolean ok = true;
        while (!this.current().isAfter(t) && !this.manager().isCancelled()) {
            for (Model m : this) {
                if (m.run(this.current())) continue;
                ok = false;
            }
            if (ok) {
                this.setCurrent(this.delay.next(this.current()));
                continue;
            }
            this.simulation().abort(this.current(), "");
            break;
        }
        return ok;
    }

    @Override
    public void delete() {
        super.delete();
        this.delay = null;
        for (Model m : this.models.values()) {
            m.delete();
        }
        this.models.clear();
        this.models = null;
    }

    @Override
    public Iterator<M> iterator() {
        return new ModelIterator<M>(this.order, this.models);
    }

    @Override
    public boolean addAll(Collection<? extends M> all) {
        for (Model m : all) {
            this.models.put(m.getName(), m);
        }
        return true;
    }

    public boolean contains(String name) {
        return this.models.containsKey(name);
    }

    @Override
    public boolean contains(Object o) {
        return this.models.values().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> all) {
        return this.models.values().containsAll(all);
    }

    @Override
    public boolean isEmpty() {
        return this.models.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.models.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.models.values().toArray(array);
    }

    @Override
    public void clear() {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean remove(Object o) {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new IllegalArgumentException();
    }
}

