/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul.model;

import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.simul.Simulator;
import fr.inra.sad.bagap.apiland.simul.model.AtomicModel;
import fr.inra.sad.bagap.apiland.simul.operation.Operation;
import java.util.ArrayList;
import java.util.List;

public class Robot
extends AtomicModel {
    private static final long serialVersionUID = 1L;
    private List<Operation> operations = new ArrayList<Operation>();

    public Robot(String name, Instant start, Delay delay, Operation operation, Simulator simulator, DynamicElement element) {
        super(name, start, delay, simulator, element);
        this.addOperation(operation);
    }

    public Robot(String name, Instant start, Delay delay, Simulator simulator, DynamicElement element) {
        super(name, start, delay, simulator, element);
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public void resetOperation() {
        this.operations = new ArrayList<Operation>();
    }

    protected List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean make(Instant t) {
        for (Operation op : this.operations) {
            if (op.make(t, this.getElement())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void delete() {
        super.delete();
        for (Operation o : this.operations) {
            o.delete();
        }
        this.operations.clear();
        this.operations = null;
    }
}

