/*
 * Decompiled with CFR 0.152.
 */
package com.csvreader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Hashtable;

public class CsvReader {
    private static final String EMPTY = "";
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char QUOTE = '\"';
    private static final char COMMA = ',';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char POUND = '#';
    private static final char BACKSLASH = '\\';
    private static final char NULL_CHAR = '\u0000';
    private static final char BACKSPACE = '\b';
    private static final char FORM_FEED = '\f';
    private static final char ESCAPE = '\u001b';
    private static final char VERTICAL_TAB = '\u000b';
    private static final char ALERT = '\u0007';
    private static final int INITIAL_COLUMN_BUFFER_SIZE = 100;
    private static final int MAX_BUFFER_SIZE = 1024;
    private static final int INITIAL_MAX_COLUMN_COUNT = 10;
    private static final int UNICODE_ESCAPE = 1;
    private static final int OCTAL_ESCAPE = 2;
    private static final int DECIMAL_ESCAPE = 3;
    private static final int HEX_ESCAPE = 4;
    private static final boolean DEMO = false;
    private Reader inputStream = null;
    private String fileName = null;
    private Charset charset = null;
    private char textQualifier = (char)34;
    private boolean trimWhitespace = true;
    private boolean useTextQualifier = true;
    private boolean detectBom = false;
    private char delimiter = (char)44;
    private char recordDelimiter = (char)44;
    private boolean useCustomRecordDelimiter = false;
    private char comment = (char)35;
    private boolean useComments = false;
    private int escapeMode = 1;
    private boolean mergeConsecutive = false;
    private String[] headers = new String[0];
    private int headersCount = 0;
    private Hashtable headerIndexByName = new Hashtable();
    private char[] columnBuffer = new char[100];
    private int columnBufferSize = 100;
    private int usedColumnLength = 0;
    private int columnStart = 0;
    private char[] dataBuffer = new char[1024];
    private int bufferPosition = 0;
    private int bufferCount = 0;
    private int maxColumnCount = 10;
    private int[] columnStarts = new int[10];
    private int[] columnLengths = new int[10];
    private int columnsCount = 0;
    private long currentRecord = 0L;
    private boolean startedColumn = false;
    private boolean startedWithQualifier = false;
    private boolean hasMoreData = true;
    private char lastLetter = '\u0000';
    private boolean hasReadNextLine = false;
    private boolean readingHeaders = false;
    private boolean skippingRecord = false;
    private boolean initialized = false;
    private boolean closed = false;
    public static final int ESCAPE_MODE_DOUBLED = 1;
    public static final int ESCAPE_MODE_BACKSLASH = 2;

    public CsvReader(String string, char c, Charset charset) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter fileName can not be null.");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Parameter charset can not be null.");
        }
        this.fileName = string;
        this.delimiter = c;
        this.charset = charset;
    }

    public CsvReader(String string, char c) {
        this(string, c, Charset.forName("ISO-8859-1"));
        this.detectBom = true;
    }

    public CsvReader(String string) {
        this(string, ',');
    }

    public CsvReader(Reader reader, char c) {
        if (reader == null) {
            throw new IllegalArgumentException("Parameter inputStream can not be null.");
        }
        this.inputStream = reader;
        this.delimiter = c;
        this.initialized = true;
    }

    public CsvReader(Reader reader) {
        this(reader, ',');
    }

    public CsvReader(InputStream inputStream, char c, Charset charset) {
        this(new InputStreamReader(inputStream, charset), c);
    }

    public CsvReader(InputStream inputStream, Charset charset) {
        this(new InputStreamReader(inputStream, charset));
    }

    public int getColumnCount() {
        return this.columnsCount;
    }

    public long getCurrentRecord() {
        return this.currentRecord - 1L;
    }

    public boolean getTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean bl) {
        this.trimWhitespace = bl;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char c) {
        this.delimiter = c;
    }

    public void setRecordDelimiter(char c) {
        this.useCustomRecordDelimiter = true;
        this.recordDelimiter = c;
    }

    public int getEscapeMode() {
        return this.escapeMode;
    }

    public void setEscapeMode(int n) throws IllegalArgumentException {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Parameter escapeMode must be a valid value.");
        }
        this.escapeMode = n;
    }

    public boolean getUseTextQualifier() {
        return this.useTextQualifier;
    }

    public void setUseTextQualifier(boolean bl) {
        this.useTextQualifier = bl;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(char c) {
        this.textQualifier = c;
    }

    public char getComment() {
        return this.comment;
    }

    public void setComment(char c) {
        this.comment = c;
    }

    public boolean getUseComments() {
        return this.useComments;
    }

    public void setUseComments(boolean bl) {
        this.useComments = bl;
    }

    public boolean getMergeConsecutive() {
        return this.mergeConsecutive;
    }

    public void setMergeConsecutive(boolean bl) {
        this.mergeConsecutive = bl;
    }

    public String[] getHeaders() throws FinalizedException {
        this.checkClosed();
        return this.headers;
    }

    public int getHeaderCount() {
        return this.headersCount;
    }

    public String get(int n) throws FinalizedException {
        String string;
        this.checkClosed();
        if (n > -1 && n < this.columnsCount) {
            int n2 = this.columnStarts[n];
            int n3 = this.columnLengths[n];
            string = n3 == 0 ? EMPTY : new String(this.columnBuffer, n2, n3);
        } else {
            string = EMPTY;
        }
        return string;
    }

    public String get(String string) throws FinalizedException {
        this.checkClosed();
        return this.get(this.getIndex(string));
    }

    public static CsvReader parse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter data can not be null.");
        }
        return new CsvReader(new StringReader(string));
    }

    public boolean readRecord() throws IOException, FinalizedException, CatastrophicException {
        this.checkClosed();
        this.checkInit();
        this.clearColumns();
        this.hasReadNextLine = false;
        if (this.hasMoreData) {
            while (true) {
                if (!this.hasReadNextLine && this.bufferPosition < this.bufferCount) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    boolean bl;
                    boolean bl2;
                    char c = this.dataBuffer[this.bufferPosition++];
                    if (this.useTextQualifier && c == this.textQualifier) {
                        this.lastLetter = c;
                        this.startedColumn = true;
                        this.startedWithQualifier = true;
                        bl2 = false;
                        if (this.escapeMode == 1) {
                            bl = false;
                            while (true) {
                                if (this.bufferPosition < this.bufferCount && this.startedColumn) {
                                    c = this.dataBuffer[this.bufferPosition++];
                                    if (bl) {
                                        if (c == this.delimiter) {
                                            this.endColumn();
                                        } else if (!this.useCustomRecordDelimiter && (c == '\r' || c == '\n') || this.useCustomRecordDelimiter && c == this.recordDelimiter) {
                                            this.endColumn();
                                            this.endRecord();
                                        }
                                    } else if (c == this.textQualifier) {
                                        if (bl2) {
                                            this.addLetter(this.textQualifier);
                                            bl2 = false;
                                        } else {
                                            bl2 = true;
                                        }
                                    } else {
                                        if (bl2) {
                                            if (c == this.delimiter) {
                                                this.endColumn();
                                            } else if (!this.useCustomRecordDelimiter && (c == '\r' || c == '\n') || this.useCustomRecordDelimiter && c == this.recordDelimiter) {
                                                this.endColumn();
                                                this.endRecord();
                                            } else {
                                                bl = true;
                                            }
                                            bl2 = false;
                                        } else {
                                            this.addLetter(c);
                                        }
                                        bl2 = false;
                                    }
                                    this.lastLetter = c;
                                    continue;
                                }
                                this.checkDataLength();
                                if (!this.hasMoreData || !this.startedColumn) break;
                            }
                            continue;
                        }
                        bl = false;
                        n4 = 0;
                        n3 = 0;
                        n2 = 1;
                        n = 0;
                        char c2 = '\u0000';
                        while (true) {
                            if (this.startedColumn && this.bufferPosition < this.bufferCount) {
                                c = this.dataBuffer[this.bufferPosition++];
                                if (bl) {
                                    if (c == this.delimiter) {
                                        this.endColumn();
                                    } else if (!this.useCustomRecordDelimiter && (c == '\r' || c == '\n') || this.useCustomRecordDelimiter && c == this.recordDelimiter) {
                                        this.endColumn();
                                        this.endRecord();
                                    }
                                } else if (n3 != 0) {
                                    ++n;
                                    switch (n2) {
                                        case 1: {
                                            c2 = (char)(c2 * 16);
                                            c2 = (char)(c2 + CsvReader.hexToDec(c));
                                            if (n != 4) break;
                                            n3 = 0;
                                            break;
                                        }
                                        case 2: {
                                            c2 = (char)(c2 * 8);
                                            c2 = (char)(c2 + (char)(c - 48));
                                            if (n != 3) break;
                                            n3 = 0;
                                            break;
                                        }
                                        case 3: {
                                            c2 = (char)(c2 * 10);
                                            c2 = (char)(c2 + (char)(c - 48));
                                            if (n != 3) break;
                                            n3 = 0;
                                            break;
                                        }
                                        case 4: {
                                            c2 = (char)(c2 * 16);
                                            c2 = (char)(c2 + CsvReader.hexToDec(c));
                                            if (n != 2) break;
                                            n3 = 0;
                                        }
                                    }
                                    if (n3 == 0) {
                                        this.addLetter(c2);
                                    }
                                } else if (n4 != 0) {
                                    switch (c) {
                                        case 'n': {
                                            this.addLetter('\n');
                                            break;
                                        }
                                        case 'r': {
                                            this.addLetter('\r');
                                            break;
                                        }
                                        case 't': {
                                            this.addLetter('\t');
                                            break;
                                        }
                                        case 'b': {
                                            this.addLetter('\b');
                                            break;
                                        }
                                        case 'f': {
                                            this.addLetter('\f');
                                            break;
                                        }
                                        case 'e': {
                                            this.addLetter('\u001b');
                                            break;
                                        }
                                        case 'v': {
                                            this.addLetter('\u000b');
                                            break;
                                        }
                                        case 'a': {
                                            this.addLetter('\u0007');
                                            break;
                                        }
                                        case '0': 
                                        case '1': 
                                        case '2': 
                                        case '3': 
                                        case '4': 
                                        case '5': 
                                        case '6': 
                                        case '7': {
                                            n2 = 2;
                                            n3 = 1;
                                            n = 1;
                                            c2 = (char)(c - 48);
                                            break;
                                        }
                                        case 'd': 
                                        case 'o': 
                                        case 'u': 
                                        case 'x': {
                                            switch (c) {
                                                case 'u': {
                                                    n2 = 1;
                                                    break;
                                                }
                                                case 'x': {
                                                    n2 = 4;
                                                    break;
                                                }
                                                case 'o': {
                                                    n2 = 2;
                                                    break;
                                                }
                                                case 'd': {
                                                    n2 = 3;
                                                }
                                            }
                                            n3 = 1;
                                            n = 0;
                                            c2 = '\u0000';
                                            break;
                                        }
                                        default: {
                                            this.addLetter(c);
                                        }
                                    }
                                    n4 = 0;
                                } else if (c == '\\') {
                                    n4 = 1;
                                } else if (c == this.textQualifier) {
                                    bl = true;
                                } else if (bl2) {
                                    if (c == this.delimiter) {
                                        this.endColumn();
                                    } else if (!this.useCustomRecordDelimiter && (c == '\r' || c == '\n') || this.useCustomRecordDelimiter && c == this.recordDelimiter) {
                                        this.endColumn();
                                        this.endRecord();
                                    } else {
                                        this.addLetter(this.textQualifier);
                                        this.addLetter(c);
                                    }
                                    bl2 = false;
                                } else {
                                    this.addLetter(c);
                                }
                                this.lastLetter = c;
                                continue;
                            }
                            this.checkDataLength();
                            if (!this.hasMoreData || !this.startedColumn) break;
                        }
                        continue;
                    }
                    if (c == this.delimiter) {
                        this.lastLetter = c;
                        if (this.mergeConsecutive) continue;
                        this.endColumn();
                        continue;
                    }
                    if (!this.useCustomRecordDelimiter && (c == '\r' || c == '\n') || this.useCustomRecordDelimiter && c == this.recordDelimiter) {
                        if (this.columnsCount > 0 || this.columnStart != this.usedColumnLength) {
                            this.endColumn();
                            this.endRecord();
                        }
                        this.lastLetter = c;
                        continue;
                    }
                    if (this.useComments && this.columnsCount == 0 && c == this.comment) {
                        this.lastLetter = c;
                        this.skipLine();
                        continue;
                    }
                    if (this.trimWhitespace && (c == ' ' || c == '\t')) continue;
                    this.startedColumn = true;
                    this.startedWithQualifier = false;
                    bl2 = false;
                    bl = false;
                    n4 = 1;
                    n3 = 0;
                    n2 = 0;
                    n = 1;
                    while (true) {
                        if (n == 0) {
                            c = this.dataBuffer[this.bufferPosition++];
                        }
                        if (!this.useTextQualifier && this.escapeMode == 2 && c == '\\') {
                            if (bl2) {
                                this.addLetter('\\');
                                bl2 = false;
                            } else {
                                bl2 = true;
                            }
                        } else if (bl) {
                            ++n3;
                            switch (n4) {
                                case 1: {
                                    n2 = (char)(n2 * 16);
                                    n2 = (char)(n2 + CsvReader.hexToDec(c));
                                    if (n3 != 4) break;
                                    bl = false;
                                    break;
                                }
                                case 2: {
                                    n2 = (char)(n2 * 8);
                                    n2 = (char)(n2 + (char)(c - 48));
                                    if (n3 != 3) break;
                                    bl = false;
                                    break;
                                }
                                case 3: {
                                    n2 = (char)(n2 * 10);
                                    n2 = (char)(n2 + (char)(c - 48));
                                    if (n3 != 3) break;
                                    bl = false;
                                    break;
                                }
                                case 4: {
                                    n2 = (char)(n2 * 16);
                                    n2 = (char)(n2 + CsvReader.hexToDec(c));
                                    if (n3 != 2) break;
                                    bl = false;
                                }
                            }
                            if (!bl) {
                                this.addLetter((char)n2);
                            }
                        } else if (!this.useTextQualifier && this.escapeMode == 2 && bl2) {
                            switch (c) {
                                case 'n': {
                                    this.addLetter('\n');
                                    break;
                                }
                                case 'r': {
                                    this.addLetter('\r');
                                    break;
                                }
                                case 't': {
                                    this.addLetter('\t');
                                    break;
                                }
                                case 'b': {
                                    this.addLetter('\b');
                                    break;
                                }
                                case 'f': {
                                    this.addLetter('\f');
                                    break;
                                }
                                case 'e': {
                                    this.addLetter('\u001b');
                                    break;
                                }
                                case 'v': {
                                    this.addLetter('\u000b');
                                    break;
                                }
                                case 'a': {
                                    this.addLetter('\u0007');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    n4 = 2;
                                    bl = true;
                                    n3 = 1;
                                    n2 = (char)(c - 48);
                                    break;
                                }
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (c) {
                                        case 'u': {
                                            n4 = 1;
                                            break;
                                        }
                                        case 'x': {
                                            n4 = 4;
                                            break;
                                        }
                                        case 'o': {
                                            n4 = 2;
                                            break;
                                        }
                                        case 'd': {
                                            n4 = 3;
                                        }
                                    }
                                    bl = true;
                                    n3 = 0;
                                    n2 = 0;
                                    break;
                                }
                                default: {
                                    this.addLetter(c);
                                }
                            }
                            bl2 = false;
                        } else if (c == this.delimiter) {
                            this.endColumn();
                        } else if (!this.useCustomRecordDelimiter && (c == '\r' || c == '\n') || this.useCustomRecordDelimiter && c == this.recordDelimiter) {
                            this.endColumn();
                            this.endRecord();
                        } else {
                            this.addLetter(c);
                        }
                        this.lastLetter = c;
                        n = 0;
                        if (this.startedColumn && this.bufferPosition < this.bufferCount) continue;
                        this.checkDataLength();
                        if (!this.hasMoreData || !this.startedColumn) break;
                    }
                    continue;
                }
                this.checkDataLength();
                if (!this.hasMoreData || this.hasReadNextLine) break;
            }
            if (!this.hasMoreData && (this.lastLetter == this.delimiter || !this.useCustomRecordDelimiter && this.lastLetter != '\r' && this.lastLetter != '\n' || this.useCustomRecordDelimiter && this.lastLetter != this.recordDelimiter)) {
                this.endColumn();
                this.endRecord();
            }
        }
        return this.hasReadNextLine;
    }

    private void checkDataLength() throws IOException {
        if (this.bufferPosition == this.bufferCount) {
            try {
                this.bufferCount = this.inputStream.read(this.dataBuffer, 0, 1024);
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            this.bufferPosition = 0;
            if (this.bufferCount <= 0) {
                this.hasMoreData = false;
            }
        }
    }

    private void clearColumns() {
        this.columnsCount = 0;
        this.columnStart = 0;
        this.usedColumnLength = 0;
    }

    private void checkInit() throws FileNotFoundException {
        if (!this.initialized) {
            if (this.fileName != null) {
                this.inputStream = new InputStreamReader((InputStream)new FileInputStream(this.fileName), this.charset);
            }
            this.initialized = true;
        }
    }

    public boolean readHeaders() throws IOException, FinalizedException, CatastrophicException {
        this.readingHeaders = true;
        boolean bl = this.readRecord();
        this.readingHeaders = false;
        this.clearColumns();
        return bl;
    }

    public String getHeader(int n) throws FinalizedException {
        this.checkClosed();
        if (n > -1 && n < this.headersCount) {
            return this.headers[n];
        }
        return EMPTY;
    }

    private void endColumn() throws CatastrophicException {
        this.startedColumn = false;
        if (!this.skippingRecord) {
            int n;
            if (this.columnsCount > 100000) {
                this.close();
                throw new CatastrophicException("Max column count of 100000 exceeded in record " + this.currentRecord + ".");
            }
            if (this.columnsCount == this.maxColumnCount) {
                n = this.maxColumnCount + Math.max(1, (int)((double)this.maxColumnCount * 1.0 / 2.0));
                int[] nArray = new int[n];
                int[] nArray2 = new int[n];
                System.arraycopy(this.columnStarts, 0, nArray, 0, this.maxColumnCount);
                System.arraycopy(this.columnLengths, 0, nArray2, 0, this.maxColumnCount);
                this.columnStarts = nArray;
                this.columnLengths = nArray2;
                this.maxColumnCount = n;
            }
            if (this.usedColumnLength - this.columnStart > 0) {
                if (this.trimWhitespace && !this.startedWithQualifier) {
                    int n2 = this.usedColumnLength - 1;
                    for (n = this.columnStart; n < this.usedColumnLength && (this.columnBuffer[n] == ' ' || this.columnBuffer[n] == '\t'); ++n) {
                    }
                    if (n < this.usedColumnLength - 1) {
                        while (n2 > n && (this.columnBuffer[n2] == ' ' || this.columnBuffer[n2] == '\t')) {
                            --n2;
                        }
                    }
                    this.columnStarts[this.columnsCount] = n;
                    this.columnLengths[this.columnsCount] = n2 - n + 1;
                } else {
                    this.columnStarts[this.columnsCount] = this.columnStart;
                    this.columnLengths[this.columnsCount] = this.usedColumnLength - this.columnStart;
                }
                this.columnStart = this.usedColumnLength;
            } else {
                this.columnStarts[this.columnsCount] = 0;
                this.columnLengths[this.columnsCount] = 0;
            }
            ++this.columnsCount;
        }
    }

    private void endRecord() throws CatastrophicException, FinalizedException {
        if (!this.skippingRecord) {
            if (this.columnsCount > 1 || this.usedColumnLength > 0 || this.startedWithQualifier) {
                this.hasReadNextLine = true;
                if (this.readingHeaders) {
                    this.headersCount = this.columnsCount;
                    this.headers = new String[this.headersCount];
                    for (int i = 0; i < this.headersCount; ++i) {
                        String string;
                        this.headers[i] = string = this.get(i);
                        this.headerIndexByName.put(string, new Integer(i));
                    }
                } else {
                    ++this.currentRecord;
                }
            } else {
                this.clearColumns();
            }
        } else {
            this.hasReadNextLine = true;
        }
    }

    private void addLetter(char c) throws CatastrophicException {
        if (!this.skippingRecord) {
            if (this.usedColumnLength > 100000) {
                this.close();
                throw new CatastrophicException("Max column length of 100000 exceeded in column " + this.columnsCount + " in record " + this.currentRecord + ".");
            }
            if (this.usedColumnLength == this.columnBufferSize) {
                int n = this.columnBufferSize + Math.max(1, (int)((double)this.columnBufferSize * 1.0 / 2.0));
                char[] cArray = new char[n];
                System.arraycopy(this.columnBuffer, 0, cArray, 0, this.columnBufferSize);
                this.columnBuffer = cArray;
                this.columnBufferSize = n;
            }
            this.columnBuffer[this.usedColumnLength++] = c;
        }
    }

    public int getIndex(String string) throws FinalizedException {
        this.checkClosed();
        Object v = this.headerIndexByName.get(string);
        if (v != null) {
            return (Integer)v;
        }
        return -1;
    }

    public boolean skipRecord() throws IOException, FinalizedException, CatastrophicException {
        this.checkClosed();
        boolean bl = false;
        if (this.hasMoreData) {
            this.skippingRecord = true;
            bl = this.readRecord();
            this.skippingRecord = false;
        }
        return bl;
    }

    public boolean skipLine() throws IOException, FinalizedException {
        this.checkClosed();
        this.clearColumns();
        boolean bl = false;
        if (this.hasMoreData) {
            this.checkInit();
            boolean bl2 = false;
            while (true) {
                if (this.bufferPosition < this.bufferCount && !bl2) {
                    char c;
                    bl = true;
                    if ((c = this.dataBuffer[this.bufferPosition++]) == '\r' || c == '\n') {
                        bl2 = true;
                    }
                    this.lastLetter = c;
                    continue;
                }
                this.checkDataLength();
                if (!this.hasMoreData || bl2) break;
            }
        }
        return bl;
    }

    public int getLength(int n) throws FinalizedException {
        this.checkClosed();
        if (n < this.columnsCount && n > -1) {
            return this.columnLengths[n];
        }
        return 0;
    }

    public void close() {
        if (!this.closed) {
            this.close(true);
            this.closed = true;
        }
    }

    protected void close(boolean bl) {
        if (bl) {
            this.charset = null;
            this.headers = null;
            this.headerIndexByName = null;
            this.columnBuffer = null;
            this.dataBuffer = null;
            this.columnStarts = null;
            this.columnLengths = null;
        }
        try {
            if (this.initialized) {
                this.inputStream.close();
            }
            this.inputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkClosed() throws FinalizedException {
        if (this.closed) {
            throw new FinalizedException();
        }
    }

    protected void finalize() {
        this.close(false);
    }

    private static char hexToDec(char c) {
        char c2 = c >= 'a' ? (char)(c - 97 + 10) : (c >= 'A' ? (char)(c - 65 + 10) : (char)(c - 48));
        return c2;
    }

    public class FinalizedException
    extends Exception {
        public FinalizedException() {
            super("Resources have already been freed.");
        }
    }

    public class CatastrophicException
    extends Exception {
        public CatastrophicException(String string) {
            super(string);
        }
    }
}

