/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShapeType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RefPoint;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.domain.Domain;
import fr.inra.sad.bagap.chloe.NoParameterException;
import fr.inra.sad.bagap.chloe.controller.ChloeContext;
import fr.inra.sad.bagap.chloe.controller.Controller;
import fr.inra.sad.bagap.chloe.model.Model;
import fr.inra.sad.bagap.chloe.view.Ihm;
import fr.inra.sad.bagap.chloe.view.LogoFrame;
import fr.inra.sad.bagap.chloe.view.treatment.ClassificationPanel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class Main {
    public static void main(String[] args) {
        if (args[0].equalsIgnoreCase("62012")) {
            Main.launchGUI(args[0]);
        } else if (args[0].endsWith(".properties")) {
            Main.launchBatch(args[0]);
        } else {
            throw new IllegalArgumentException("argument " + args[0] + " is not recognize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchGUI(String socket) {
        LogoFrame launch = null;
        try {
            launch = new LogoFrame();
            System.out.println("Chloe - INRAE - ACT - BAGAP");
            Locale.setDefault(Locale.US);
            ChloeContext.load();
            Ihm ihm = new Ihm(new ServerSocket(new Integer(socket)));
            Model model = new Model();
            new Controller(ihm, model);
            ihm.getFrame();
        }
        catch (Exception e) {
            System.out.println("Chloe is already open !!!");
        }
        finally {
            launch.dispose();
        }
    }

    private static void launchBatch(String file) {
        Model model = new Model();
        try {
            Properties properties = new Properties();
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
            properties.load(in);
            ((Reader)in).close();
            if (properties.containsKey("treatment")) {
                String treatment;
                switch (treatment = properties.getProperty("treatment")) {
                    case "from csv": {
                        Main.launchFromCsv(model, properties);
                        break;
                    }
                    case "from shapefile": {
                        Main.launchFromShapefile(model, properties);
                        break;
                    }
                    case "search and replace": {
                        Main.launchSearchAndReplace(model, properties);
                        break;
                    }
                    case "overlay": {
                        Main.launchOverlay(model, properties);
                        break;
                    }
                    case "distance": {
                        Main.launchDistance(model, properties);
                        break;
                    }
                    case "classification": {
                        Main.launchClassification(model, properties);
                        break;
                    }
                    case "cluster": {
                        Main.launchCluster(model, properties);
                        break;
                    }
                    case "combine": {
                        Main.launchCombine(model, properties);
                        break;
                    }
                    case "filter": {
                        Main.launchFilter(model, properties);
                        break;
                    }
                    case "map": {
                        Main.launchMap(model, properties);
                        break;
                    }
                    case "grid": {
                        Main.launchGrid(model, properties);
                        break;
                    }
                    case "sliding": {
                        Main.launchSliding(model, properties);
                        break;
                    }
                    case "selected": {
                        Main.launchSelected(model, properties);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("treatment " + treatment + " is not implemented yet");
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void launchFromCsv(Model model, Properties properties) {
        try {
            String inputCsv = Main.importInputCsv(properties);
            Set<String> variables = Main.importVariables(properties);
            int ncols = Main.importNCols(properties);
            int nrows = Main.importNRows(properties);
            double xllcorner = Main.importXllCorner(properties);
            double yllcorner = Main.importYllCorner(properties);
            double cellsize = Main.importCellSize(properties);
            int nodatavalue = Main.importNoDataValue(properties);
            String folder = null;
            String outputAsc = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            model.exportAsciiGridFromCsv(true, inputCsv, folder, outputAsc, variables, ncols, nrows, xllcorner, yllcorner, cellsize, nodatavalue, viewAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchFromShapefile(Model model, Properties properties) {
        try {
            Set<String> layers = Main.importInputShapefile(properties);
            String attribute = Main.importAttribute(properties);
            String lookupTable = Main.importLookupTable(properties);
            Set<Double> cellsizes = Main.importCellSizes(properties);
            String folder = null;
            String outputAsc = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            Double minx = Main.importMinX(properties);
            Double maxx = Main.importMaxX(properties);
            Double miny = Main.importMinY(properties);
            Double maxy = Main.importMaxY(properties);
            model.exportAsciiGridFromShapefile(true, layers, attribute, lookupTable, cellsizes, folder, outputAsc, viewAscii, minx, maxx, miny, maxy);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchSearchAndReplace(Model model, Properties properties) {
        try {
            Set<String> asciis = Main.importInputAsciiGrid(properties);
            int nodatavalue = Main.importNoDataValue(properties);
            Map<String, String> changes = Main.importChanges(properties);
            String folder = null;
            String outputAsc = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            model.runSearchAndReplace(true, asciis, nodatavalue, changes, folder, outputAsc, viewAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchOverlay(Model model, Properties properties) {
        try {
            List<String> asciis = Main.importOverlayingAsciis(model, properties);
            String folder = null;
            String outputAsc = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder2(properties);
            } else {
                outputAsc = Main.importOutputAscii2(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii2(properties);
            model.runOverlay(true, asciis, folder, outputAsc, viewAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchDistance(Model model, Properties properties) {
        try {
            Set<Matrix> matrix = Main.importInputMatrix(model, properties);
            Set<Integer> distances = Main.importDistances(properties);
            String distanceType = Main.importDistanceType(properties);
            double maxDistance = Main.importMaxDistance(properties);
            Friction friction = Main.importDistanceFriction(properties);
            Matrix frictionMatrix = Main.importDistanceFrictionMatrix(model, properties);
            String folder = null;
            String outputAsc = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            model.runDistance(true, matrix, distances, distanceType, maxDistance, friction, frictionMatrix, folder, outputAsc, viewAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchClassification(Model model, Properties properties) {
        try {
            Set<String> asciis = Main.importInputAsciiGrid(properties);
            Map<Domain<Double, Double>, Integer> domains = Main.importDomains(properties);
            String folder = null;
            String outputAsc = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            model.runClassification(true, asciis, domains, folder, outputAsc, viewAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchCluster(Model model, Properties properties) {
        try {
            Set<Matrix> matrix = Main.importInputMatrix(model, properties);
            List<Integer> clusters = Main.importCluster(properties);
            String typeCluster = Main.importClusterType(properties);
            double distance = Main.importClusterDistance(properties);
            Friction friction = Main.importClusterFriction(properties);
            Matrix frictionMatrix = Main.importClusterFrictionMatrix(model, properties);
            String folder = null;
            String outputAsc = null;
            String outputCsv = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
                outputCsv = Main.importOutputCsv(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            double minimumTotalArea = Main.importMinimumTotalArea(properties);
            model.runCluster(true, matrix, clusters, typeCluster, distance, minimumTotalArea, friction, frictionMatrix, folder, outputAsc, outputCsv, viewAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchCombine(Model model, Properties properties) {
        try {
            List<String> asciis = Main.importFactorsAsciis(model, properties);
            List<String> names = Main.importFactorsNames(model, properties);
            String combination = Main.importCombination(model, properties);
            String folder = null;
            String outputAsc = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder3(properties);
            } else {
                outputAsc = Main.importOutputAscii3(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii3(properties);
            model.runCombine(true, asciis, names, combination, folder, outputAsc, viewAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchFilter(Model model, Properties properties) {
        try {
            Set<Matrix> matrix = Main.importInputMatrix(model, properties);
            Matrix filterMatrix = Main.importFilterAscii(model, properties);
            Set<Integer> filterValues = Main.importFilterValues(properties);
            String folder = null;
            String outputAsc = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            model.runFilter(true, matrix, filterMatrix, filterValues, folder, outputAsc, viewAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchMap(Model model, Properties properties) {
        try {
            Set<Matrix> matrix = Main.importInputMatrix(model, properties);
            Set<String> metrics = Main.importMetrics(properties);
            String csvOutput = Main.importOutputCsv(properties);
            model.runMapWindow(true, matrix, metrics, csvOutput);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchGrid(Model model, Properties properties) {
        try {
            Set<Matrix> matrix = Main.importInputMatrix(model, properties);
            List<Integer> gridSizes = Main.importGridSizes(properties);
            double minRate = Main.importMaximumNoValueRate(properties);
            Set<String> metrics = Main.importMetrics(properties);
            String folder = null;
            String outputAsc = null;
            String outputCsv = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
                outputCsv = Main.importOutputCsv(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            boolean exportCsv = Main.importExportCsv(properties);
            boolean exportAscii = Main.importExportAscii(properties);
            model.runGridWindow(true, matrix, gridSizes, minRate, metrics, folder, outputAsc, outputCsv, viewAscii, exportCsv, exportAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchSliding(Model model, Properties properties) {
        try {
            Set<Matrix> matrix = Main.importInputMatrix(model, properties);
            WindowShapeType shape = Main.importShape(properties);
            Friction friction = Main.importFriction(properties);
            Matrix frictionMatrix = Main.importFrictionMatrix(model, properties);
            List<Integer> windowSizes = Main.importWindowSizes(properties);
            double minRate = Main.importMaximumNoValueRate(properties);
            int delta = Main.importDeltaDisplacement(properties);
            int xOrigin = Main.importXOrigin(properties);
            int yOrigin = Main.importYOrigin(properties);
            boolean interpolate = Main.importInterpolation(properties);
            Set<String> metrics = Main.importMetrics(properties);
            String distanceFunction = Main.importDistanceFunction(properties);
            String folder = null;
            String outputAsc = null;
            String outputCsv = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
                outputCsv = Main.importOutputCsv(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            boolean exportCsv = Main.importExportCsv(properties);
            boolean exportAscii = Main.importExportAscii(properties);
            Set<Integer> filters = Main.importFilters(properties);
            Set<Integer> unfilters = Main.importUnfilters(properties);
            model.runSlidingWindow(true, matrix, shape, friction, frictionMatrix, windowSizes, distanceFunction, delta, xOrigin, yOrigin, interpolate, minRate, metrics, folder, outputAsc, outputCsv, viewAscii, exportCsv, exportAscii, filters, unfilters);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchSelected(Model model, Properties properties) {
        try {
            Set<Matrix> matrix = Main.importInputMatrix(model, properties);
            WindowShapeType shape = Main.importShape(properties);
            Friction friction = Main.importFriction(properties);
            Matrix frictionMatrix = Main.importFrictionMatrix(model, properties);
            double minRate = Main.importMaximumNoValueRate(properties);
            List<Integer> windowSizes = Main.importWindowSizes(properties);
            Set<Pixel> pixels = Main.importPixels(matrix, properties);
            Set<RefPoint> points = Main.importPoints(properties);
            Set<String> metrics = Main.importMetrics(properties);
            String distanceFunction = Main.importDistanceFunction(properties);
            String folder = null;
            String outputAsc = null;
            String outputCsv = null;
            if (properties.containsKey("output_folder")) {
                folder = Main.importOutputFolder(properties);
            } else {
                outputAsc = Main.importOutputAscii(properties);
                outputCsv = Main.importOutputCsv(properties);
            }
            boolean viewAscii = Main.importVisualizeAscii(properties);
            boolean exportCsv = Main.importExportCsv(properties);
            boolean exportAscii = Main.importExportAscii(properties);
            model.runSelectedWindow(true, matrix, minRate, shape, friction, frictionMatrix, windowSizes, distanceFunction, pixels, points, metrics, folder, outputAsc, outputCsv, viewAscii, exportCsv, exportAscii);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    public static String importInputCsv(Properties properties) throws NoParameterException {
        if (properties.containsKey("input_csv")) {
            return properties.getProperty("input_csv");
        }
        throw new NoParameterException("input_csv");
    }

    public static Set<String> importVariables(Properties properties) throws NoParameterException {
        if (properties.containsKey("variables")) {
            String prop = properties.getProperty("variables");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            String[] vs = prop.split(";");
            TreeSet<String> vars = new TreeSet<String>();
            for (String v : vs) {
                vars.add(v);
            }
            return vars;
        }
        throw new NoParameterException("variables");
    }

    public static int importNCols(Properties properties) throws NoParameterException {
        if (properties.containsKey("ncols")) {
            return Integer.parseInt(properties.getProperty("ncols"));
        }
        throw new NoParameterException("ncols");
    }

    public static int importNRows(Properties properties) throws NoParameterException {
        if (properties.containsKey("nrows")) {
            return Integer.parseInt(properties.getProperty("nrows"));
        }
        throw new NoParameterException("nrows");
    }

    public static double importXllCorner(Properties properties) throws NoParameterException {
        if (properties.containsKey("xllcorner")) {
            return Double.parseDouble(properties.getProperty("xllcorner"));
        }
        throw new NoParameterException("xllcorner");
    }

    public static double importYllCorner(Properties properties) throws NoParameterException {
        if (properties.containsKey("yllcorner")) {
            return Double.parseDouble(properties.getProperty("yllcorner"));
        }
        throw new NoParameterException("yllcorner");
    }

    public static double importCellSize(Properties properties) throws NoParameterException {
        if (properties.containsKey("cellsize")) {
            return Double.parseDouble(properties.getProperty("cellsize"));
        }
        throw new NoParameterException("cellsize");
    }

    public static int importNoDataValue(Properties properties) throws NoParameterException {
        if (properties.containsKey("nodata_value")) {
            return Integer.parseInt(properties.getProperty("nodata_value"));
        }
        throw new NoParameterException("nodata_value");
    }

    public static String importOutputFolder(Properties properties) throws NoParameterException {
        if (properties.containsKey("output_folder")) {
            return properties.getProperty("output_folder") + "/";
        }
        throw new NoParameterException("output_folder");
    }

    public static String importOutputFolder2(Properties properties) throws NoParameterException {
        if (properties.containsKey("output_folder")) {
            return properties.getProperty("output_folder") + "/";
        }
        throw new NoParameterException("output_folder");
    }

    public static String importOutputFolder3(Properties properties) throws NoParameterException {
        if (properties.containsKey("output_folder")) {
            return properties.getProperty("output_folder") + "/";
        }
        throw new NoParameterException("output_folder");
    }

    public static String importOutputAscii(Properties properties) throws NoParameterException {
        if (properties.containsKey("output_asc")) {
            return properties.getProperty("output_asc");
        }
        throw new NoParameterException("output_asc");
    }

    public static String importOutputAscii2(Properties properties) throws NoParameterException {
        if (properties.containsKey("output_asc")) {
            return properties.getProperty("output_asc");
        }
        throw new NoParameterException("output_asc");
    }

    public static String importOutputAscii3(Properties properties) throws NoParameterException {
        if (properties.containsKey("output_asc")) {
            return properties.getProperty("output_asc");
        }
        throw new NoParameterException("output_asc");
    }

    public static String importOutputCsv(Properties properties) throws NoParameterException {
        if (properties.containsKey("output_csv")) {
            return properties.getProperty("output_csv");
        }
        throw new NoParameterException("output_csv");
    }

    public static boolean importVisualizeAscii(Properties properties) throws NoParameterException {
        if (properties.containsKey("visualize_ascii")) {
            return Boolean.parseBoolean(properties.getProperty("visualize_ascii"));
        }
        throw new NoParameterException("visualize_ascii");
    }

    public static boolean importVisualizeAscii2(Properties properties) throws NoParameterException {
        if (properties.containsKey("visualize_ascii")) {
            return Boolean.parseBoolean(properties.getProperty("visualize_ascii"));
        }
        throw new NoParameterException("visualize_ascii");
    }

    public static boolean importVisualizeAscii3(Properties properties) throws NoParameterException {
        if (properties.containsKey("visualize_ascii")) {
            return Boolean.parseBoolean(properties.getProperty("visualize_ascii"));
        }
        throw new NoParameterException("visualize_ascii");
    }

    public static Set<String> importInputShapefile(Properties properties) throws NoParameterException {
        if (properties.containsKey("input_shapefile")) {
            String prop = properties.getProperty("input_shapefile");
            File f = new File(prop);
            HashSet<String> shapes = new HashSet<String>();
            if (f.isDirectory()) {
                for (String c : f.list()) {
                    if (!c.endsWith(".shp")) continue;
                    shapes.add(f + "/" + c);
                }
            } else {
                shapes.add(prop);
            }
            return shapes;
        }
        throw new NoParameterException("input_shapefile");
    }

    public static String importAttribute(Properties properties) throws NoParameterException {
        if (properties.containsKey("attribute")) {
            return properties.getProperty("attribute");
        }
        throw new NoParameterException("attribute");
    }

    public static String importLookupTable(Properties properties) throws NoParameterException {
        if (properties.containsKey("lookup_table")) {
            return properties.getProperty("lookup_table");
        }
        return "";
    }

    public static String importDistanceFunction(Properties properties) throws NoParameterException {
        if (properties.containsKey("distance_function")) {
            return properties.getProperty("distance_function");
        }
        return "";
    }

    public static Set<Double> importCellSizes(Properties properties) throws NoParameterException {
        if (properties.containsKey("cellsizes")) {
            String prop = properties.getProperty("cellsizes");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            String[] ws = prop.split(";");
            TreeSet<Double> cellsizes = new TreeSet<Double>();
            for (String w : ws) {
                cellsizes.add(Double.parseDouble(w));
            }
            return cellsizes;
        }
        throw new NoParameterException("cellsizes");
    }

    public static Double importMinX(Properties properties) throws NoParameterException {
        if (properties.containsKey("minx")) {
            return new Double(Double.parseDouble(properties.getProperty("minx")));
        }
        return null;
    }

    public static Double importMaxX(Properties properties) throws NoParameterException {
        if (properties.containsKey("maxx")) {
            return new Double(Double.parseDouble(properties.getProperty("maxx")));
        }
        return null;
    }

    public static Double importMinY(Properties properties) throws NoParameterException {
        if (properties.containsKey("miny")) {
            return new Double(Double.parseDouble(properties.getProperty("miny")));
        }
        return null;
    }

    public static Double importMaxY(Properties properties) throws NoParameterException {
        if (properties.containsKey("maxy")) {
            return new Double(Double.parseDouble(properties.getProperty("maxy")));
        }
        return null;
    }

    public static Set<String> importInputAsciiGrid(Properties properties) throws NoParameterException {
        if (properties.containsKey("input_ascii")) {
            String prop = properties.getProperty("input_ascii");
            File f = new File(prop);
            HashSet<String> asciis = new HashSet<String>();
            if (f.isDirectory()) {
                for (String c : f.list()) {
                    if (!c.endsWith(".asc")) continue;
                    asciis.add(f + "/" + c);
                }
            } else {
                asciis.add(prop);
            }
            return asciis;
        }
        throw new NoParameterException("input_ascii");
    }

    public static Set<Matrix> importInputMatrix(Model model, Properties properties) throws NoParameterException {
        if (properties.containsKey("input_ascii")) {
            String prop = properties.getProperty("input_ascii");
            File f = new File(prop);
            HashSet<Matrix> matrix = new HashSet<Matrix>();
            if (f.isDirectory()) {
                for (String c : f.list()) {
                    if (!c.endsWith(".asc")) continue;
                    model.importAsciiGrid(matrix, f + "/" + c, false);
                }
            } else {
                model.importAsciiGrid(matrix, prop, false);
            }
            return matrix;
        }
        throw new NoParameterException("input_ascii");
    }

    public static List<String> importFactorsAsciis(Model model, Properties properties) throws NoParameterException {
        if (properties.containsKey("factors")) {
            String prop = properties.getProperty("factors").replace("{", "").replace("}", "");
            String[] ds = prop.split(";");
            ArrayList<String> asciis = new ArrayList<String>();
            for (String d : ds) {
                d = d.replace("(", "").replace(")", "");
                String[] dd = d.split(",");
                asciis.add(dd[0]);
            }
            return asciis;
        }
        throw new NoParameterException("factors");
    }

    public static List<String> importFactorsNames(Model model, Properties properties) throws NoParameterException {
        if (properties.containsKey("factors")) {
            String prop = properties.getProperty("factors").replace("{", "").replace("}", "");
            String[] ds = prop.split(";");
            ArrayList<String> names = new ArrayList<String>();
            for (String d : ds) {
                d = d.replace("(", "").replace(")", "");
                String[] dd = d.split(",");
                names.add(dd[1]);
            }
            return names;
        }
        throw new NoParameterException("factors");
    }

    private static String importCombination(Model model, Properties properties) throws NoParameterException {
        if (properties.containsKey("combination")) {
            String combination = properties.getProperty("combination");
            return combination;
        }
        throw new NoParameterException("combination");
    }

    public static Map<String, String> importChanges(Properties properties) throws NoParameterException {
        if (properties.containsKey("changes")) {
            String prop = properties.getProperty("changes").replace("{", "").replace("}", "");
            String[] cc = prop.split(";");
            HashMap<String, String> changes = new HashMap<String, String>();
            for (String c : cc) {
                c = c.replace("(", "").replace(")", "");
                String[] vv = c.split(",");
                changes.put(vv[0] + "", vv[1] + "");
            }
            return changes;
        }
        throw new NoParameterException("changes");
    }

    public static List<String> importOverlayingAsciis(Model model, Properties properties) throws NoParameterException {
        if (properties.containsKey("overlaying_matrix")) {
            String prop = properties.getProperty("overlaying_matrix");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            String[] ms = prop.split(";");
            ArrayList<String> asciis = new ArrayList<String>();
            for (String m : ms) {
                asciis.add(m);
            }
            return asciis;
        }
        throw new NoParameterException("overlaying_matrix");
    }

    public static Set<Integer> importDistances(Properties properties) throws NoParameterException {
        if (properties.containsKey("distance_from")) {
            String prop = properties.getProperty("distance_from").replace("{", "").replace("}", "");
            String[] df = prop.split(";");
            HashSet<Integer> distances = new HashSet<Integer>();
            for (String d : df) {
                distances.add(Integer.parseInt(d));
            }
            return distances;
        }
        throw new NoParameterException("distance_from");
    }

    public static String importDistanceType(Properties properties) throws NoParameterException {
        if (properties.containsKey("distance_type")) {
            return properties.getProperty("distance_type");
        }
        return "euclidian";
    }

    public static double importMaxDistance(Properties properties) throws NoParameterException {
        if (properties.containsKey("max_distance")) {
            return Double.parseDouble(properties.getProperty("max_distance"));
        }
        return Raster.getNoDataValue();
    }

    public static Friction importDistanceFriction(Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("distance_friction") && !(prop = properties.getProperty("distance_friction")).endsWith(".asc")) {
            return new Friction(prop);
        }
        return null;
    }

    public static Matrix importDistanceFrictionMatrix(Model model, Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("distance_friction_ascii")) {
            String prop2 = properties.getProperty("distance_friction_ascii");
            Matrix frictionMatrix = null;
            frictionMatrix = model.importAsciiGrid(frictionMatrix, prop2, false);
            return frictionMatrix;
        }
        if (properties.containsKey("distance_friction") && (prop = properties.getProperty("distance_friction")).endsWith(".asc")) {
            Matrix frictionMatrix = null;
            frictionMatrix = model.importAsciiGrid(frictionMatrix, prop, false);
            return frictionMatrix;
        }
        return null;
    }

    public static Map<Domain<Double, Double>, Integer> importDomains(Properties properties) throws NoParameterException {
        if (properties.containsKey("domains")) {
            String prop = properties.getProperty("domains").replace("{", "").replace("}", "");
            String[] ds = prop.split(";");
            HashMap<Domain<Double, Double>, Integer> domains = new HashMap<Domain<Double, Double>, Integer>();
            for (String d : ds) {
                d = d.replace("(", "").replace(")", "");
                String[] dd = d.split("-");
                domains.put(ClassificationPanel.getDomain(dd[0]), Integer.parseInt(dd[1]));
            }
            return domains;
        }
        throw new NoParameterException("domains");
    }

    public static List<Integer> importCluster(Properties properties) throws NoParameterException {
        if (properties.containsKey("cluster")) {
            String prop = properties.getProperty("cluster").replace("{", "").replace("}", "");
            String[] df = prop.split(";");
            ArrayList<Integer> clusters = new ArrayList<Integer>();
            for (String d : df) {
                clusters.add(Integer.parseInt(d));
            }
            return clusters;
        }
        throw new NoParameterException("cluster");
    }

    public static String importClusterType(Properties properties) throws NoParameterException {
        if (properties.containsKey("cluster_type")) {
            return properties.getProperty("cluster_type");
        }
        throw new NoParameterException("cluster_type");
    }

    public static double importClusterDistance(Properties properties) throws NoParameterException {
        if (properties.containsKey("cluster_distance")) {
            return Double.parseDouble(properties.getProperty("cluster_distance"));
        }
        return 0.0;
    }

    private static double importMinimumTotalArea(Properties properties) {
        if (properties.containsKey("minimum_total_area")) {
            return Double.parseDouble(properties.getProperty("minimum_total_area"));
        }
        return 0.0;
    }

    public static Friction importClusterFriction(Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("cluster_friction") && !(prop = properties.getProperty("cluster_friction")).endsWith(".asc")) {
            return new Friction(prop);
        }
        return null;
    }

    public static Matrix importClusterFrictionMatrix(Model model, Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("cluster_friction_ascii")) {
            String prop2 = properties.getProperty("cluster_friction_ascii");
            Matrix frictionMatrix = null;
            frictionMatrix = model.importAsciiGrid(frictionMatrix, prop2, false);
            return frictionMatrix;
        }
        if (properties.containsKey("cluster_friction") && (prop = properties.getProperty("cluster_friction")).endsWith(".asc")) {
            Matrix frictionMatrix = null;
            frictionMatrix = model.importAsciiGrid(frictionMatrix, prop, false);
            return frictionMatrix;
        }
        return null;
    }

    public static Matrix importFilterAscii(Model model, Properties properties) throws NoParameterException {
        if (properties.containsKey("ascii_filter")) {
            String prop = properties.getProperty("ascii_filter");
            Matrix filterMatrix = null;
            filterMatrix = model.importAsciiGrid(filterMatrix, prop, false);
            return filterMatrix;
        }
        throw new NoParameterException("ascii_filter");
    }

    public static Set<Integer> importFilterValues(Properties properties) throws NoParameterException {
        if (properties.containsKey("filter_values")) {
            String prop = properties.getProperty("filter_values").replace("{", "").replace("}", "");
            String[] df = prop.split(";");
            HashSet<Integer> filterValues = new HashSet<Integer>();
            for (String d : df) {
                filterValues.add(Integer.parseInt(d));
            }
            return filterValues;
        }
        throw new NoParameterException("filter_values");
    }

    public static Set<String> importMetrics(Properties properties) throws NoParameterException {
        if (properties.containsKey("metrics")) {
            String prop = properties.getProperty("metrics");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            String[] ms = prop.split(";");
            TreeSet<String> metrics = new TreeSet<String>();
            for (String m : ms) {
                metrics.add(m);
            }
            return metrics;
        }
        throw new NoParameterException("metrics");
    }

    public static List<Integer> importGridSizes(Properties properties) throws NoParameterException {
        if (properties.containsKey("grid_sizes")) {
            String prop = properties.getProperty("grid_sizes");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            String[] ws = prop.split(";");
            ArrayList<Integer> gridSizes = new ArrayList<Integer>();
            for (String w : ws) {
                gridSizes.add(Integer.parseInt(w));
            }
            return gridSizes;
        }
        throw new NoParameterException("grid_sizes");
    }

    public static double importMaximumNoValueRate(Properties properties) throws NoParameterException {
        if (properties.containsKey("maximum_nodata_value_rate")) {
            return 1.0 - (double)Integer.parseInt(properties.getProperty("maximum_nodata_value_rate")) / 100.0;
        }
        throw new NoParameterException("maximum_nodata_value_rate");
    }

    public static boolean importExportCsv(Properties properties) throws NoParameterException {
        if (properties.containsKey("export_csv")) {
            return Boolean.parseBoolean(properties.getProperty("export_csv"));
        }
        throw new NoParameterException("export_csv");
    }

    public static boolean importExportAscii(Properties properties) throws NoParameterException {
        if (properties.containsKey("export_ascii")) {
            return Boolean.parseBoolean(properties.getProperty("export_ascii"));
        }
        throw new NoParameterException("export_ascii");
    }

    public static WindowShapeType importShape(Properties properties) throws NoParameterException {
        if (properties.containsKey("shape")) {
            return WindowShapeType.get(properties.getProperty("shape"));
        }
        throw new NoParameterException("shape");
    }

    public static Friction importFriction(Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("friction") && !(prop = properties.getProperty("friction")).endsWith(".asc")) {
            return new Friction(prop);
        }
        return null;
    }

    public static Matrix importFrictionMatrix(Model model, Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("friction_ascii")) {
            String prop2 = properties.getProperty("friction_ascii");
            Matrix frictionMatrix = null;
            frictionMatrix = model.importAsciiGrid(frictionMatrix, prop2, false);
            return frictionMatrix;
        }
        if (properties.containsKey("friction") && (prop = properties.getProperty("friction")).endsWith(".asc")) {
            Matrix frictionMatrix = null;
            frictionMatrix = model.importAsciiGrid(frictionMatrix, prop, false);
            return frictionMatrix;
        }
        return null;
    }

    public static List<Integer> importWindowSizes(Properties properties) throws NoParameterException {
        if (properties.containsKey("window_sizes")) {
            String prop = properties.getProperty("window_sizes");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            String[] ws = prop.split(";");
            ArrayList<Integer> windowSizes = new ArrayList<Integer>();
            for (String w : ws) {
                windowSizes.add(Integer.parseInt(w));
            }
            return windowSizes;
        }
        throw new NoParameterException("window_sizes");
    }

    public static int importDeltaDisplacement(Properties properties) throws NoParameterException {
        if (properties.containsKey("delta_displacement")) {
            return Integer.parseInt(properties.getProperty("delta_displacement"));
        }
        throw new NoParameterException("delta_displacement");
    }

    public static int importXOrigin(Properties properties) throws NoParameterException {
        if (properties.containsKey("x_origin")) {
            return Integer.parseInt(properties.getProperty("x_origin"));
        }
        return 0;
    }

    public static int importYOrigin(Properties properties) throws NoParameterException {
        if (properties.containsKey("y_origin")) {
            return Integer.parseInt(properties.getProperty("y_origin"));
        }
        return 0;
    }

    public static boolean importInterpolation(Properties properties) throws NoParameterException {
        if (properties.containsKey("interpolation")) {
            return Boolean.parseBoolean(properties.getProperty("interpolation"));
        }
        return false;
    }

    public static Set<Integer> importFilters(Properties properties) throws NoParameterException {
        HashSet<Integer> filters = new HashSet<Integer>();
        if (properties.containsKey("filters")) {
            String[] fs;
            String prop = properties.getProperty("filters");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            for (String f : fs = prop.split(";")) {
                filters.add(Integer.parseInt(f));
            }
        }
        return filters;
    }

    public static Set<Integer> importUnfilters(Properties properties) throws NoParameterException {
        HashSet<Integer> unfilters = new HashSet<Integer>();
        if (properties.containsKey("unfilters")) {
            String[] fs;
            String prop = properties.getProperty("unfilters");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            for (String f : fs = prop.split(";")) {
                unfilters.add(Integer.parseInt(f));
            }
        }
        return unfilters;
    }

    public static Set<Pixel> importPixels(Set<Matrix> matrix, Properties properties) throws NoParameterException {
        HashSet<Pixel> pixels = new HashSet();
        if (properties.containsKey("pixels")) {
            String prop = properties.getProperty("pixels");
            pixels = CoordinateManager.initWithPixels(prop);
        } else if (properties.containsKey("number_generated_pixels")) {
            String prop = properties.getProperty("pixels");
            int n = Integer.parseInt(prop);
            int distance = -1;
            if (properties.containsKey("minimum_distance")) {
                prop = properties.getProperty("minimum_distance");
                distance = Integer.parseInt(prop);
            }
            HashSet<Integer> with = null;
            if (properties.containsKey("filters")) {
                String[] fs;
                with = new HashSet<Integer>();
                prop = properties.getProperty("filters");
                prop = prop.replace("{", "").replace("}", "").replace(" ", "");
                for (String f : fs = prop.split(";")) {
                    with.add(Integer.parseInt(f));
                }
            }
            HashSet<Integer> without = null;
            if (properties.containsKey("unfilters")) {
                String[] fs;
                without = new HashSet<Integer>();
                prop = properties.getProperty("unfilters");
                prop = prop.replace("{", "").replace("}", "").replace(" ", "");
                for (String f : fs = prop.split(";")) {
                    without.add(Integer.parseInt(f));
                }
            }
            try {
                CoordinateManager.dispatch(pixels, matrix.iterator().next(), n, distance, with, without);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        if (pixels.size() == 0) {
            pixels = null;
        }
        return pixels;
    }

    public static Set<RefPoint> importPoints(Properties properties) throws NoParameterException {
        if (properties.containsKey("points")) {
            String prop = properties.getProperty("points");
            return CoordinateManager.initWithPoints(prop);
        }
        return null;
    }
}

