/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ChloeContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String repSystem = "./system/";
    private static final String repFile = "./system/file/";
    private static final String repData = ".";
    private static final String repImages = "./system/images/";
    private static final String icon = "./system/images/chloe_icon.jpg";
    private static final String logo = "./system/images/chloe_logo.jpg";
    private static final String documentation = "system/documentation/documentation_chloe.pdf";
    private String repUserData = ".";
    private static ChloeContext instance = new ChloeContext();

    private ChloeContext() {
    }

    public static ChloeContext get() {
        return instance;
    }

    public static void setInstance(ChloeContext ls) {
        instance = ls;
    }

    public static void save() throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("./system/local.ctx"));
        try {
            out.writeObject(ChloeContext.get());
        }
        finally {
            out.flush();
            out.close();
        }
    }

    public static void load() {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream("./system/local.ctx"));
            ChloeContext.setInstance((ChloeContext)in.readObject());
            in.close();
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setRepData(String rep) {
        this.repUserData = ChloeContext.getFolder(rep);
    }

    public String getRepImages() {
        return repImages;
    }

    public String getRepData() {
        return this.repUserData;
    }

    public static String getRepsystem() {
        return repSystem;
    }

    public static String getRepfile() {
        return repFile;
    }

    public String getDocumentation() {
        return documentation;
    }

    private static String getFolder(String file) {
        File f = new File(file);
        if (f.isDirectory()) {
            return f.toString() + "/";
        }
        return f.getParent() + "/";
    }

    public String getIcon() {
        return icon;
    }

    public String getLogo() {
        return logo;
    }
}

