/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view.treatment;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.Wizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class DistancePanel
extends TreatmentPanel {
    private static final long serialVersionUID = 1L;
    private String typeDistance;
    private double distance;

    public DistancePanel(Wizard wizard) {
        super(wizard);
    }

    @Override
    public String toString() {
        return "distance";
    }

    @Override
    protected void locateComponents() {
        title.setText("Distance");
        c = new GridBagConstraints();
        DistancePanel.c.insets = new Insets(5, 5, 5, 5);
        DistancePanel.c.gridx = 0;
        DistancePanel.c.gridy = 0;
        DistancePanel.c.gridwidth = 0;
        DistancePanel.c.anchor = 10;
        this.add((Component)title, c);
        DistancePanel.c.gridx = 0;
        DistancePanel.c.gridy = 1;
        DistancePanel.c.gridwidth = 1;
        DistancePanel.c.anchor = 22;
        this.add((Component)lAsciiInput, c);
        DistancePanel.c.gridx = 1;
        DistancePanel.c.gridy = 1;
        DistancePanel.c.anchor = 21;
        DistancePanel.c.fill = 2;
        DistancePanel.c.weightx = 3.0;
        DistancePanel.c.gridwidth = 3;
        this.add((Component)taMatrixInput, c);
        DistancePanel.c.gridx = 4;
        DistancePanel.c.gridy = 1;
        DistancePanel.c.anchor = 10;
        DistancePanel.c.fill = 0;
        DistancePanel.c.weightx = 0.0;
        DistancePanel.c.weighty = 0.0;
        DistancePanel.c.gridwidth = 1;
        this.add((Component)bMatrixCollectionInput, c);
        DistancePanel.c.gridx = 5;
        DistancePanel.c.gridy = 1;
        this.add((Component)bViewMatrixInput, c);
        DistancePanel.c.gridx = 0;
        DistancePanel.c.gridy = 3;
        DistancePanel.c.anchor = 24;
        this.add((Component)lDistances, c);
        DistancePanel.c.gridx = 1;
        DistancePanel.c.gridy = 3;
        DistancePanel.c.anchor = 23;
        DistancePanel.c.fill = 0;
        DistancePanel.c.weighty = 0.0;
        DistancePanel.c.gridheight = 4;
        this.add((Component)pDistances, c);
        DistancePanel.c.gridx = 2;
        DistancePanel.c.gridy = 4;
        DistancePanel.c.gridheight = 1;
        this.add((Component)rbEuclidianDistance, c);
        DistancePanel.c.gridx = 2;
        DistancePanel.c.gridy = 5;
        this.add((Component)rbFunctionalDistance, c);
        DistancePanel.c.gridx = 2;
        DistancePanel.c.gridy = 6;
        DistancePanel.c.anchor = 22;
        this.add((Component)lFrictionDistance, c);
        DistancePanel.c.gridx = 3;
        DistancePanel.c.gridy = 6;
        DistancePanel.c.anchor = 21;
        DistancePanel.c.fill = 2;
        this.add((Component)taFrictionDistance, c);
        DistancePanel.c.gridx = 4;
        DistancePanel.c.gridy = 6;
        DistancePanel.c.anchor = 21;
        DistancePanel.c.fill = 0;
        this.add((Component)bFrictionDistance, c);
        DistancePanel.c.gridx = 2;
        DistancePanel.c.gridy = 7;
        this.add((Component)cbMaxDistance, c);
        DistancePanel.c.gridx = 3;
        DistancePanel.c.gridy = 7;
        this.add((Component)spMaxDistance, c);
        DistancePanel.c.gridx = 0;
        DistancePanel.c.gridy = 8;
        DistancePanel.c.anchor = 22;
        this.add((Component)lOutputFolder, c);
        DistancePanel.c.gridx = 1;
        DistancePanel.c.gridy = 8;
        DistancePanel.c.anchor = 23;
        DistancePanel.c.fill = 2;
        DistancePanel.c.weightx = 3.0;
        DistancePanel.c.gridwidth = 3;
        this.add((Component)taOutputFolder, c);
        DistancePanel.c.gridx = 4;
        DistancePanel.c.gridy = 8;
        DistancePanel.c.anchor = 19;
        DistancePanel.c.fill = 0;
        DistancePanel.c.weightx = 0.0;
        DistancePanel.c.gridwidth = 1;
        this.add((Component)bOutputFolder, c);
        DistancePanel.c.gridx = 1;
        DistancePanel.c.gridy = 9;
        DistancePanel.c.weighty = 1.0;
        DistancePanel.c.anchor = 23;
        DistancePanel.c.fill = 0;
        this.add((Component)viewAsciiOutput, c);
    }

    @Override
    public boolean validateRun(List<String> list) {
        boolean validate = true;
        vDistances = new HashSet();
        for (int r : tDistances.getSelectedRows()) {
            vDistances.add((Integer)tDistances.getModel().getValueAt(r, 0));
        }
        if (rbEuclidianDistance.isSelected()) {
            this.typeDistance = "euclidian";
        } else {
            this.typeDistance = "functional";
            if (distanceFrictionMatrix.size() == 0) {
                distanceFriction = new Friction(taFrictionDistance.getText());
            }
        }
        this.distance = Raster.getNoDataValue();
        if (cbMaxDistance.isSelected()) {
            this.distance = (Double)spMaxDistance.getValue();
        }
        if (taOutputFolder.getText().equalsIgnoreCase("")) {
            list.add("Please choose an ascci grid output matrix file");
            validate = false;
        }
        return validate;
    }

    @Override
    public void doImport(Properties properties) {
        this.importInputMatrix(properties);
        this.importDistances(properties);
        this.importDistanceType(properties);
        this.importMaxDistance(properties);
        this.importDistanceFriction(properties);
        this.importDistanceFrictionMatrix(properties);
        this.importOutputFolder(properties);
        this.importVisualizeAscii(properties);
    }

    @Override
    public void doExport(Properties properties) {
        this.exportInputMatrix(properties);
        this.exportDistances(properties);
        this.exportDistanceType(properties);
        this.exportMaxDistance(properties);
        this.exportDistanceFriction(properties);
        this.exportDistanceFrictionMatrix(properties);
        this.exportOutputFolder(properties);
        this.exportVisualizeAscii(properties);
    }

    @Override
    public void run() {
        DistancePanel.getController().runDistance(inputMatrix, vDistances, this.typeDistance, this.distance, distanceFriction, distanceFrictionMatrix.size() == 0 ? null : (Matrix)distanceFrictionMatrix.iterator().next(), taOutputFolder.getText(), viewAsciiOutput.isSelected());
    }
}

