/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view.treatment;

import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.Wizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

public class GridWindowPanel
extends TreatmentPanel {
    private static final long serialVersionUID = 1L;

    public GridWindowPanel(Wizard wizard) {
        super(wizard);
    }

    @Override
    public String toString() {
        return "grid";
    }

    @Override
    protected void locateComponents() {
        title.setText("Grid Window Analysis");
        c = new GridBagConstraints();
        GridWindowPanel.c.insets = new Insets(5, 5, 5, 5);
        GridWindowPanel.c.gridx = 0;
        GridWindowPanel.c.gridy = 0;
        GridWindowPanel.c.gridwidth = 0;
        GridWindowPanel.c.anchor = 10;
        this.add((Component)title, c);
        GridWindowPanel.c.gridx = 0;
        GridWindowPanel.c.gridy = 1;
        GridWindowPanel.c.gridwidth = 1;
        GridWindowPanel.c.anchor = 22;
        this.add((Component)lAsciiInput, c);
        GridWindowPanel.c.gridx = 1;
        GridWindowPanel.c.gridy = 1;
        GridWindowPanel.c.gridwidth = 5;
        GridWindowPanel.c.anchor = 21;
        GridWindowPanel.c.fill = 2;
        GridWindowPanel.c.weightx = 1.0;
        this.add((Component)taMatrixInput, c);
        GridWindowPanel.c.gridx = 6;
        GridWindowPanel.c.gridy = 1;
        GridWindowPanel.c.gridwidth = 1;
        GridWindowPanel.c.anchor = 10;
        GridWindowPanel.c.fill = 0;
        GridWindowPanel.c.weightx = 0.0;
        GridWindowPanel.c.weighty = 0.0;
        this.add((Component)bMatrixCollectionInput, c);
        GridWindowPanel.c.gridx = 7;
        GridWindowPanel.c.gridy = 1;
        this.add((Component)bViewMatrixInput, c);
        GridWindowPanel.c.gridx = 0;
        GridWindowPanel.c.gridy = 5;
        GridWindowPanel.c.anchor = 24;
        this.add((Component)lGSize, c);
        GridWindowPanel.c.gridx = 1;
        GridWindowPanel.c.gridy = 5;
        GridWindowPanel.c.anchor = 23;
        this.add((Component)spGSize, c);
        GridWindowPanel.c.gridx = 2;
        GridWindowPanel.c.gridy = 5;
        this.add((Component)bsgAdd, c);
        GridWindowPanel.c.gridx = 3;
        GridWindowPanel.c.gridy = 5;
        this.add((Component)pGSize, c);
        GridWindowPanel.c.gridx = 4;
        GridWindowPanel.c.gridy = 5;
        this.add((Component)bsgRem, c);
        GridWindowPanel.c.gridx = 0;
        GridWindowPanel.c.gridy = 6;
        GridWindowPanel.c.anchor = 22;
        this.add((Component)lType, c);
        GridWindowPanel.c.gridx = 1;
        GridWindowPanel.c.gridy = 6;
        GridWindowPanel.c.anchor = 21;
        this.add((Component)cbType, c);
        GridWindowPanel.c.gridx = 3;
        GridWindowPanel.c.gridy = 6;
        GridWindowPanel.c.anchor = 22;
        this.add((Component)lMaxRate, c);
        GridWindowPanel.c.gridx = 4;
        GridWindowPanel.c.gridy = 6;
        GridWindowPanel.c.anchor = 21;
        this.add((Component)spMaxRate, c);
        GridWindowPanel.c.gridx = 0;
        GridWindowPanel.c.gridy = 7;
        GridWindowPanel.c.anchor = 24;
        this.add((Component)lMetrics, c);
        GridWindowPanel.c.gridx = 1;
        GridWindowPanel.c.gridy = 7;
        GridWindowPanel.c.gridheight = 3;
        GridWindowPanel.c.gridwidth = 2;
        GridWindowPanel.c.fill = 2;
        this.add((Component)pLMetrics, c);
        GridWindowPanel.c.gridx = 3;
        GridWindowPanel.c.gridy = 7;
        GridWindowPanel.c.gridheight = 1;
        GridWindowPanel.c.gridwidth = 1;
        GridWindowPanel.c.fill = 0;
        GridWindowPanel.c.anchor = 10;
        this.add((Component)bmAll, c);
        GridWindowPanel.c.gridx = 3;
        GridWindowPanel.c.gridy = 8;
        this.add((Component)bmAdd, c);
        GridWindowPanel.c.gridx = 3;
        GridWindowPanel.c.gridy = 9;
        GridWindowPanel.c.anchor = 19;
        this.add((Component)bmRem, c);
        GridWindowPanel.c.gridx = 4;
        GridWindowPanel.c.gridy = 7;
        GridWindowPanel.c.gridheight = 3;
        GridWindowPanel.c.gridwidth = 2;
        GridWindowPanel.c.fill = 2;
        GridWindowPanel.c.anchor = 21;
        this.add((Component)pCMetrics, c);
        GridWindowPanel.c.gridx = 0;
        GridWindowPanel.c.gridy = 10;
        GridWindowPanel.c.gridheight = 1;
        GridWindowPanel.c.gridwidth = 1;
        GridWindowPanel.c.fill = 0;
        GridWindowPanel.c.anchor = 22;
        this.add((Component)lOutputFolder, c);
        GridWindowPanel.c.gridx = 1;
        GridWindowPanel.c.gridy = 10;
        GridWindowPanel.c.gridwidth = 5;
        GridWindowPanel.c.anchor = 23;
        GridWindowPanel.c.fill = 2;
        GridWindowPanel.c.weightx = 1.0;
        this.add((Component)taOutputFolder, c);
        GridWindowPanel.c.gridx = 6;
        GridWindowPanel.c.gridy = 10;
        GridWindowPanel.c.gridwidth = 1;
        GridWindowPanel.c.anchor = 19;
        GridWindowPanel.c.fill = 0;
        GridWindowPanel.c.weightx = 0.0;
        this.add((Component)bOutputFolder, c);
        GridWindowPanel.c.gridx = 1;
        GridWindowPanel.c.gridy = 11;
        GridWindowPanel.c.weighty = 1.0;
        GridWindowPanel.c.anchor = 23;
        GridWindowPanel.c.fill = 0;
        this.add((Component)exportCsv, c);
        GridWindowPanel.c.gridx = 2;
        GridWindowPanel.c.gridy = 11;
        this.add((Component)exportAscii, c);
        GridWindowPanel.c.gridx = 3;
        GridWindowPanel.c.gridy = 11;
        this.add((Component)viewAsciiOutput, c);
    }

    @Override
    public boolean validateRun(List<String> list) {
        int r;
        boolean validate = true;
        if (inputMatrix.size() == 0) {
            list.add("Please choose an ascci grid input matrix file");
            validate = false;
        }
        if (tGSize.getModel().getRowCount() < 1) {
            list.add("Please select at least one grid size");
            validate = false;
        } else {
            gridSizes = new ArrayList();
            for (r = 0; r < tGSize.getModel().getRowCount(); ++r) {
                gridSizes.add((Integer)tGSize.getModel().getValueAt(r, 0));
            }
        }
        if (tCMetrics.getModel().getRowCount() == 0) {
            list.add("Please choose metrics to calculate");
            validate = false;
        } else {
            metrics = new TreeSet();
            for (r = 0; r < tCMetrics.getModel().getRowCount(); ++r) {
                metrics.add((String)tCMetrics.getModel().getValueAt(r, 0));
            }
        }
        if (taOutputFolder.getText().equalsIgnoreCase("")) {
            list.add("Please choose an ascci grid output matrix file");
            validate = false;
        }
        return validate;
    }

    @Override
    public void doImport(Properties properties) {
        this.importInputMatrix(properties);
        this.importGridSizes(properties);
        this.importMaximumNoValueRate(properties);
        this.importMetrics(properties);
        this.importOutputFolder(properties);
        this.importExportCsv(properties);
        this.importExportAscii(properties);
        this.importVisualizeAscii(properties);
    }

    @Override
    public void doExport(Properties properties) {
        this.exportInputMatrix(properties);
        this.exportGridSizes(properties);
        this.exportMaximumNoValueRate(properties);
        this.exportMetrics(properties);
        this.exportOutputFolder(properties);
        this.exportExportCsv(properties);
        this.exportExportAscii(properties);
        this.exportVisualizeAscii(properties);
    }

    @Override
    public void run() {
        GridWindowPanel.getController().runGridWindow(inputMatrix, gridSizes, 1.0 - (double)((Integer)spMaxRate.getValue()).intValue() / 100.0, metrics, taOutputFolder.getText(), viewAsciiOutput.isSelected(), exportCsv.isSelected(), exportAscii.isSelected());
    }
}

