/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view.treatment;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShapeType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.Wizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

public class SlidingWindowPanel
extends TreatmentPanel {
    private static final long serialVersionUID = 1L;

    public SlidingWindowPanel(Wizard wizard) {
        super(wizard);
    }

    @Override
    public String toString() {
        return "sliding";
    }

    @Override
    protected void locateComponents() {
        title.setText("Sliding Window Analysis");
        c = new GridBagConstraints();
        SlidingWindowPanel.c.insets = new Insets(5, 2, 5, 2);
        SlidingWindowPanel.c.gridx = 5;
        SlidingWindowPanel.c.gridy = 0;
        this.add((Component)lFictif, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 0;
        SlidingWindowPanel.c.gridwidth = 0;
        SlidingWindowPanel.c.anchor = 10;
        this.add((Component)title, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 1;
        SlidingWindowPanel.c.gridwidth = 1;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lAsciiInput, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 1;
        SlidingWindowPanel.c.gridwidth = 3;
        SlidingWindowPanel.c.anchor = 21;
        SlidingWindowPanel.c.fill = 2;
        SlidingWindowPanel.c.weightx = 1.0;
        this.add((Component)taMatrixInput, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 1;
        SlidingWindowPanel.c.gridwidth = 1;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.weightx = 0.0;
        SlidingWindowPanel.c.weighty = 0.0;
        this.add((Component)bMatrixCollectionInput, c);
        SlidingWindowPanel.c.gridx = 5;
        SlidingWindowPanel.c.gridy = 1;
        this.add((Component)bViewMatrixInput, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 3;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lShape, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 3;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)cbShape, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 3;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lFriction, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 3;
        SlidingWindowPanel.c.gridwidth = 2;
        SlidingWindowPanel.c.anchor = 21;
        SlidingWindowPanel.c.fill = 2;
        this.add((Component)taFriction, c);
        SlidingWindowPanel.c.gridx = 5;
        SlidingWindowPanel.c.gridy = 3;
        SlidingWindowPanel.c.gridwidth = 1;
        SlidingWindowPanel.c.anchor = 21;
        SlidingWindowPanel.c.fill = 0;
        this.add((Component)bFriction, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 4;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lSize, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 4;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spSize, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 4;
        this.add((Component)bsAdd, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 4;
        SlidingWindowPanel.c.gridheight = 2;
        this.add((Component)pSize, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 5;
        SlidingWindowPanel.c.anchor = 22;
        SlidingWindowPanel.c.gridheight = 1;
        this.add((Component)bsRem, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 5;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)lDMax, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 6;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lDistanceType, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 6;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)rbThreshold, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 7;
        this.add((Component)rbFormula, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 7;
        SlidingWindowPanel.c.gridwidth = 3;
        SlidingWindowPanel.c.gridheight = 4;
        SlidingWindowPanel.c.fill = 1;
        this.add((Component)taFormula, c);
        SlidingWindowPanel.c.gridwidth = 1;
        SlidingWindowPanel.c.gridheight = 1;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.gridx = 5;
        SlidingWindowPanel.c.gridy = 7;
        this.add((Component)bDistanceFunction, c);
        SlidingWindowPanel.c.gridx = 5;
        SlidingWindowPanel.c.gridy = 8;
        this.add((Component)bDistanceImport, c);
        SlidingWindowPanel.c.gridx = 5;
        SlidingWindowPanel.c.gridy = 9;
        this.add((Component)bDistanceExport, c);
        SlidingWindowPanel.c.gridx = 5;
        SlidingWindowPanel.c.gridy = 10;
        this.add((Component)bDistancePost, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 10;
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 11;
        this.add((Component)rbLinearFunction, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 11;
        this.add((Component)rbCurveFunctionType1, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 11;
        this.add((Component)rbCurveFunctionType2, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 12;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lDistanceOrigin, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 12;
        SlidingWindowPanel.c.anchor = 23;
        SlidingWindowPanel.c.fill = 2;
        this.add((Component)taDistanceOrigin, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 12;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lDistanceOriginValue, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 12;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spDistanceOriginValue, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 13;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lDistanceFinal, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 13;
        SlidingWindowPanel.c.anchor = 23;
        SlidingWindowPanel.c.fill = 2;
        this.add((Component)taDistanceFinal, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 13;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lDistanceFinalValue, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 13;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spDistanceFinalValue, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 14;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lDistanceTilt, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 14;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spDistanceTilt, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 15;
        this.add((Component)rbGaussianFunction, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 16;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lDistanceBaseValue, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 16;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spDistanceBaseValue, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 17;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lDistancePic, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 17;
        SlidingWindowPanel.c.anchor = 21;
        SlidingWindowPanel.c.fill = 2;
        this.add((Component)taDistancePic, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 17;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lDistancePicValue, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 17;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spDistancePicValue, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 18;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lDistanceQValue, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 18;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spDistanceQValue, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 19;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lDelta, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 19;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spDelta, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 19;
        this.add((Component)lDeltaMeters, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 19;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)cbInterpolate, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 20;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lXOrigin, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 20;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spXOrigin, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 21;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lYOrigin, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 21;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spYOrigin, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 22;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lFilters, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 22;
        this.add((Component)cbF, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 22;
        SlidingWindowPanel.c.anchor = 23;
        this.add((Component)pF, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 22;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)cbNF, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 22;
        SlidingWindowPanel.c.anchor = 23;
        this.add((Component)pNF, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 23;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lMaxRate, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 23;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)spMaxRate, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 24;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.anchor = 22;
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 25;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.anchor = 24;
        this.add((Component)lMetrics, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 25;
        this.add((Component)cbType, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 25;
        SlidingWindowPanel.c.gridheight = 3;
        SlidingWindowPanel.c.fill = 2;
        this.add((Component)pLMetrics, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 25;
        SlidingWindowPanel.c.gridheight = 1;
        SlidingWindowPanel.c.gridwidth = 1;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.anchor = 10;
        this.add((Component)bmAll, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 26;
        this.add((Component)bmAdd, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 27;
        SlidingWindowPanel.c.anchor = 19;
        this.add((Component)bmRem, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 25;
        SlidingWindowPanel.c.gridheight = 3;
        SlidingWindowPanel.c.fill = 2;
        SlidingWindowPanel.c.anchor = 21;
        this.add((Component)pCMetrics, c);
        SlidingWindowPanel.c.gridx = 0;
        SlidingWindowPanel.c.gridy = 28;
        SlidingWindowPanel.c.gridheight = 1;
        SlidingWindowPanel.c.gridwidth = 1;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.anchor = 22;
        this.add((Component)lOutputFolder, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 28;
        SlidingWindowPanel.c.gridwidth = 3;
        SlidingWindowPanel.c.anchor = 23;
        SlidingWindowPanel.c.fill = 2;
        SlidingWindowPanel.c.weightx = 1.0;
        this.add((Component)taOutputFolder, c);
        SlidingWindowPanel.c.gridx = 4;
        SlidingWindowPanel.c.gridy = 28;
        SlidingWindowPanel.c.gridwidth = 1;
        SlidingWindowPanel.c.anchor = 21;
        SlidingWindowPanel.c.fill = 0;
        SlidingWindowPanel.c.weightx = 0.0;
        this.add((Component)bOutputFolder, c);
        SlidingWindowPanel.c.gridx = 1;
        SlidingWindowPanel.c.gridy = 29;
        SlidingWindowPanel.c.weighty = 1.0;
        SlidingWindowPanel.c.anchor = 23;
        SlidingWindowPanel.c.fill = 0;
        this.add((Component)exportCsv, c);
        SlidingWindowPanel.c.gridx = 2;
        SlidingWindowPanel.c.gridy = 29;
        this.add((Component)exportAscii, c);
        SlidingWindowPanel.c.gridx = 3;
        SlidingWindowPanel.c.gridy = 29;
        this.add((Component)viewAsciiOutput, c);
    }

    @Override
    public boolean validateRun(List<String> list) {
        int r;
        boolean validate = true;
        if (inputMatrix.size() == 0) {
            list.add("Please choose an ascci grid input matrix file");
            validate = false;
        }
        if (tSize.getModel().getRowCount() < 1) {
            list.add("Please select at least one window size");
            validate = false;
        } else {
            windowSizes = new ArrayList();
            for (r = 0; r < tSize.getModel().getRowCount(); ++r) {
                windowSizes.add((Integer)tSize.getModel().getValueAt(r, 0));
            }
        }
        if (cbShape.getSelectedItem().equals((Object)WindowShapeType.SQUARE) && rbFormula.isSelected()) {
            list.add("The weighted distance calculation is not available for the square window shape");
            validate = false;
        }
        if (cbShape.getSelectedItem().equals((Object)WindowShapeType.FUNCTIONAL)) {
            if (frictionMatrix.size() == 0) {
                friction = new Friction(taFriction.getText());
            }
        } else {
            friction = null;
            frictionMatrix.clear();
        }
        filters = new HashSet();
        if (cbF.isSelected()) {
            for (int r2 : tF.getSelectedRows()) {
                filters.add((Integer)tF.getModel().getValueAt(r2, 0));
            }
        }
        unfilters = new HashSet();
        if (cbNF.isSelected()) {
            for (int r2 : tNF.getSelectedRows()) {
                unfilters.add((Integer)tNF.getModel().getValueAt(r2, 0));
            }
        }
        metrics = new TreeSet();
        if (!exportCsv.isSelected() && tCMetrics.getModel().getRowCount() == 0) {
            list.add("Please choose metrics to calculate");
            validate = false;
        } else {
            for (r = 0; r < tCMetrics.getModel().getRowCount(); ++r) {
                metrics.add((String)tCMetrics.getModel().getValueAt(r, 0));
            }
        }
        if (taOutputFolder.getText().equalsIgnoreCase("")) {
            list.add("Please choose an output folder");
            validate = false;
        }
        if (rbFormula.isSelected()) {
            distanceFunction = taFormula.getText();
            if (distanceFunction.equalsIgnoreCase("")) {
                list.add("Please set a formula for the distance function");
                validate = false;
            }
        } else {
            distanceFunction = null;
        }
        if ((Integer)spDelta.getValue() == 1) {
            spXOrigin.setValue(0);
            spYOrigin.setValue(0);
        }
        return validate;
    }

    @Override
    public void doImport(Properties properties) {
        this.importInputMatrix(properties);
        this.importShape(properties);
        this.importFriction(properties);
        this.importFrictionMatrix(properties);
        this.importWindowSizes(properties);
        this.importMaximumNoValueRate(properties);
        this.importDeltaDisplacement(properties);
        this.importXOrigin(properties);
        this.importYOrigin(properties);
        this.importInterpolation(properties);
        this.importFilters(properties);
        this.importUnfilters(properties);
        this.importMetrics(properties);
        this.importOutputFolder(properties);
        this.importExportCsv(properties);
        this.importExportAscii(properties);
        this.importVisualizeAscii(properties);
        this.importDistanceFunction(properties);
    }

    @Override
    public void doExport(Properties properties) {
        this.exportInputMatrix(properties);
        this.exportShape(properties);
        this.exportFriction(properties);
        this.exportFrictionMatrix(properties);
        this.exportWindowSizes(properties);
        this.exportMaximumNoValueRate(properties);
        this.exportDeltaDisplacement(properties);
        this.exportXOrigin(properties);
        this.exportYOrigin(properties);
        this.exportDeltaDisplacement(properties);
        this.exportInterpolation(properties);
        this.exportFilters(properties);
        this.exportUnfilters(properties);
        this.exportMetrics(properties);
        this.exportOutputFolder(properties);
        this.exportExportCsv(properties);
        this.exportExportAscii(properties);
        this.exportVisualizeAscii(properties);
        this.exportDistanceFunction(properties);
    }

    @Override
    public void run() {
        SlidingWindowPanel.getController().runSlidingWindow(inputMatrix, (WindowShapeType)((Object)cbShape.getSelectedItem()), friction, frictionMatrix.size() == 0 ? null : (Matrix)frictionMatrix.iterator().next(), windowSizes, distanceFunction, (Integer)spDelta.getValue(), (Integer)spXOrigin.getValue(), (Integer)spYOrigin.getValue(), cbInterpolate.isSelected(), 1.0 - (double)((Integer)spMaxRate.getValue()).intValue() / 100.0, metrics, taOutputFolder.getText(), exportAscii.isSelected() ? viewAsciiOutput.isSelected() : false, exportCsv.isSelected(), exportAscii.isSelected(), filters, unfilters);
    }
}

