/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view.wizard;

import fr.inra.sad.bagap.chloe.controller.ChloeContext;
import fr.inra.sad.bagap.chloe.controller.Controller;
import fr.inra.sad.bagap.chloe.view.Ihm;
import fr.inra.sad.bagap.chloe.view.TreatmentTree;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.ErrorMessageBox;
import fr.inra.sad.bagap.chloe.view.wizard.NullWizardPanel;
import fr.inra.sad.bagap.chloe.view.wizard.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class Wizard
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private Controller controller;
    private Ihm ihm;
    private TreatmentTree treatmentTree;
    public static final Dimension WIZARD_WINDOW_SIZE = new Dimension(450, 200);
    private final JButton previousButton = new JButton("<< previous");
    private final JButton nextButton = new JButton("next >>");
    private final JButton runButton = new JButton("run");
    private final JButton importButton = new JButton("import");
    private final JButton exportButton = new JButton("export");
    private final JButton helpButton = new JButton("help");
    private Stack<WizardPanel> stack;
    private WizardPanel current;
    private JScrollPane currentSP;

    public Wizard(Controller controller, Ihm ihm) {
        this.controller = controller;
        this.ihm = ihm;
        this.init();
    }

    public Controller getController() {
        return this.controller;
    }

    private void init() {
        this.nextButton.addActionListener(this);
        this.previousButton.addActionListener(this);
        this.runButton.addActionListener(this);
        this.importButton.addActionListener(this);
        this.exportButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.previousButton.setEnabled(false);
        this.runButton.setEnabled(false);
        this.importButton.setEnabled(true);
        this.exportButton.setEnabled(false);
        this.runButton.setBackground(Color.BLUE);
        this.runButton.setForeground(Color.WHITE);
        this.importButton.setBackground(Color.BLUE);
        this.importButton.setForeground(Color.WHITE);
        this.exportButton.setBackground(Color.BLUE);
        this.exportButton.setForeground(Color.WHITE);
        this.helpButton.setBackground(Color.BLUE);
        this.helpButton.setForeground(Color.WHITE);
        this.setLayout(new BorderLayout());
        JPanel navButtons = new JPanel();
        navButtons.setLayout(new FlowLayout(2));
        navButtons.add(this.helpButton);
        navButtons.add(this.previousButton);
        navButtons.add(this.nextButton);
        navButtons.add(this.runButton);
        JPanel importExportButtons = new JPanel();
        importExportButtons.setLayout(new FlowLayout(1));
        importExportButtons.add(this.exportButton);
        importExportButtons.add(this.importButton);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BorderLayout());
        buttons.add((Component)navButtons, "East");
        buttons.add((Component)importExportButtons, "Center");
        this.add((Component)buttons, "South");
        this.setMinimumSize(WIZARD_WINDOW_SIZE);
        this.setPreferredSize(WIZARD_WINDOW_SIZE);
    }

    public void start(WizardPanel wp) {
        this.stack = new Stack();
        this.setPanel(wp);
        this.updateButtons();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String ac = ae.getActionCommand();
        if ("<< previous".equals(ac)) {
            this.previous();
        } else if ("next >>".equals(ac)) {
            this.next();
        } else if ("run".equals(ac)) {
            this.run();
        } else if ("import".equals(ac)) {
            this.importation();
        } else if ("export".equals(ac)) {
            this.exportation();
        } else if ("help".equals(ac)) {
            this.help();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && ((TreatmentTree)e.getSource()).getLastSelectedPathComponent() != null) {
            this.next((TreatmentPanel)((DefaultMutableTreeNode)((TreatmentTree)e.getSource()).getLastSelectedPathComponent()).getUserObject());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public WizardPanel getCurrent() {
        return this.current;
    }

    private void setPanel(WizardPanel wp) {
        if (this.current != null) {
            this.remove(this.currentSP);
        }
        this.current = wp;
        if (this.current == null) {
            this.current = new NullWizardPanel();
        }
        this.currentSP = new JScrollPane(this.current);
        this.currentSP.getVerticalScrollBar().setUnitIncrement(10);
        this.currentSP.getHorizontalScrollBar().setUnitIncrement(10);
        this.add(this.currentSP);
        this.setVisible(true);
        this.revalidate();
        this.updateUI();
        this.current.display();
    }

    private void updateButtons() {
        this.previousButton.setEnabled(this.current.hasPrevious());
        this.nextButton.setEnabled(this.current.hasNext());
        this.runButton.setEnabled(this.current.canRun());
        this.exportButton.setEnabled(this.current.hasPrevious());
    }

    public void previous() {
        WizardPanel wp = this.stack.pop();
        this.setPanel(wp);
        this.updateButtons();
    }

    private void next() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.current.validateNext(list)) {
            this.stack.push(this.current);
            WizardPanel wp = this.current.next(this);
            this.setPanel(wp);
            this.updateButtons();
        } else {
            this.showErrorMessages(list);
        }
    }

    private void next(TreatmentPanel panel) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.current.validateNext(list)) {
            this.stack.push(this.current);
            this.setPanel(panel);
            this.updateButtons();
        } else {
            this.showErrorMessages(list);
        }
    }

    public void setTreatmentTree(TreatmentTree treatmentTree) {
        this.treatmentTree = treatmentTree;
    }

    public TreatmentPanel next(String treatment) {
        TreatmentPanel panel = this.treatmentTree.getPanel(treatment);
        this.next(panel);
        return panel;
    }

    private void run() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.current.validateRun(list)) {
            this.current.run();
        } else {
            this.showErrorMessages(list);
        }
    }

    private void importation() {
        this.ihm.importTreatment();
    }

    private void exportation() {
        this.ihm.exportTreatment();
    }

    private void help() {
        if (Desktop.isDesktopSupported()) {
            if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                try {
                    Desktop.getDesktop().open(new File(ChloeContext.get().getDocumentation()));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                System.out.println("opening pdf file unsupported");
            }
        } else {
            System.out.println("pdf file unsupported");
        }
    }

    public void showErrorMessage(String message) {
        Window w = SwingUtilities.windowForComponent(this);
        ErrorMessageBox errorMsgBox = w instanceof Frame ? new ErrorMessageBox((Frame)w) : (w instanceof Dialog ? new ErrorMessageBox((Dialog)w) : new ErrorMessageBox());
        errorMsgBox.showErrorMessage(message);
    }

    private void showErrorMessages(List<String> list) {
        Window w = SwingUtilities.windowForComponent(this);
        ErrorMessageBox errorMsgBox = w instanceof Frame ? new ErrorMessageBox((Frame)w) : (w instanceof Dialog ? new ErrorMessageBox((Dialog)w) : new ErrorMessageBox());
        errorMsgBox.showErrorMessages(list);
    }
}

