/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImageJ;
import ij.Macro;
import ij.Prefs;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.frame.Recorder;
import ij.util.Java2;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SaveDialog {
    private String dir;
    private String name;
    private String title;
    private String ext;

    public SaveDialog(String title, String defaultName, String extension) {
        this.title = title;
        this.ext = extension;
        if (this.isMacro()) {
            return;
        }
        String defaultDir = OpenDialog.getDefaultDirectory();
        defaultName = this.addExtension(defaultName, extension);
        if (Prefs.useJFileChooser) {
            this.jSave(title, defaultDir, defaultName);
        } else {
            this.save(title, defaultDir, defaultName);
        }
        if (this.name != null && this.dir != null) {
            OpenDialog.setDefaultDirectory(this.dir);
        }
        IJ.showStatus(String.valueOf(title) + ": " + this.dir + this.name);
    }

    public SaveDialog(String title, String defaultDir, String defaultName, String extension) {
        this.title = title;
        this.ext = extension;
        if (this.isMacro()) {
            return;
        }
        defaultName = this.addExtension(defaultName, extension);
        if (Prefs.useJFileChooser) {
            this.jSave(title, defaultDir, defaultName);
        } else {
            this.save(title, defaultDir, defaultName);
        }
        IJ.showStatus(String.valueOf(title) + ": " + this.dir + this.name);
    }

    boolean isMacro() {
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            String path = Macro.getValue(macroOptions, this.title, null);
            if (path == null) {
                path = Macro.getValue(macroOptions, "path", null);
            }
            if (path != null) {
                Opener o = new Opener();
                this.dir = o.getDir(path);
                this.name = o.getName(path);
                return true;
            }
        }
        return false;
    }

    String addExtension(String name, String extension) {
        if (name != null && extension != null) {
            int dotIndex = name.lastIndexOf(".");
            name = dotIndex >= 0 ? String.valueOf(name.substring(0, dotIndex)) + extension : String.valueOf(name) + extension;
        }
        return name;
    }

    void jSave(String title, String defaultDir, String defaultName) {
        Java2.setSystemLookAndFeel();
        if (EventQueue.isDispatchThread()) {
            this.jSaveDispatchThread(title, defaultDir, defaultName);
        } else {
            this.jSaveInvokeAndWait(title, defaultDir, defaultName);
        }
    }

    void jSaveDispatchThread(String title, String defaultDir, String defaultName) {
        int ret;
        int returnVal;
        File f;
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(title);
        if (defaultDir != null && (f = new File(defaultDir)) != null) {
            fc.setCurrentDirectory(f);
        }
        if (defaultName != null) {
            fc.setSelectedFile(new File(defaultName));
        }
        if ((returnVal = fc.showSaveDialog(IJ.getInstance())) != 0) {
            Macro.abort();
            return;
        }
        File f2 = fc.getSelectedFile();
        if (f2.exists() && (ret = JOptionPane.showConfirmDialog(fc, "The file " + f2.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2)) != 0) {
            f2 = null;
        }
        if (f2 == null) {
            Macro.abort();
        } else {
            this.dir = String.valueOf(fc.getCurrentDirectory().getPath()) + File.separator;
            this.name = fc.getName(f2);
        }
    }

    void jSaveInvokeAndWait(final String title, final String defaultDir, final String defaultName) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    int ret;
                    int returnVal;
                    File f;
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle(title);
                    if (defaultDir != null && (f = new File(defaultDir)) != null) {
                        fc.setCurrentDirectory(f);
                    }
                    if (defaultName != null) {
                        fc.setSelectedFile(new File(defaultName));
                    }
                    if ((returnVal = fc.showSaveDialog(IJ.getInstance())) != 0) {
                        Macro.abort();
                        return;
                    }
                    File f2 = fc.getSelectedFile();
                    if (f2.exists() && (ret = JOptionPane.showConfirmDialog(fc, "The file " + f2.getName() + " already exists. \nWould you like to replace it?", "Replace?", 0, 2)) != 0) {
                        f2 = null;
                    }
                    if (f2 == null) {
                        Macro.abort();
                    } else {
                        SaveDialog.this.dir = String.valueOf(fc.getCurrentDirectory().getPath()) + File.separator;
                        SaveDialog.this.name = fc.getName(f2);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void save(String title, String defaultDir, String defaultName) {
        ImageJ ij = IJ.getInstance();
        Frame parent = ij != null ? ij : new Frame();
        FileDialog fd = new FileDialog(parent, title, 1);
        if (defaultName != null) {
            fd.setFile(defaultName);
        }
        if (defaultDir != null) {
            fd.setDirectory(defaultDir);
        }
        fd.show();
        this.name = fd.getFile();
        this.dir = fd.getDirectory();
        if (this.name == null) {
            Macro.abort();
        }
        fd.dispose();
        if (ij == null) {
            parent.dispose();
        }
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getFileName() {
        if (Recorder.record) {
            Recorder.recordPath(this.title, String.valueOf(this.dir) + this.name);
        }
        return this.name;
    }
}

