/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;

public class Clipboard
implements PlugIn,
Transferable {
    static java.awt.datatransfer.Clipboard clipboard;

    public void run(String arg) {
        if (IJ.altKeyDown()) {
            if (arg.equals("copy")) {
                arg = "scopy";
            } else if (arg.equals("paste")) {
                arg = "spaste";
            }
        }
        if (arg.equals("copy")) {
            this.copy(false);
        } else if (arg.equals("paste")) {
            this.paste();
        } else if (arg.equals("cut")) {
            this.copy(true);
        } else if (arg.equals("scopy")) {
            this.copyToSystem();
        } else if (arg.equals("showsys")) {
            this.showSystemClipboard();
        } else if (arg.equals("show")) {
            this.showInternalClipboard();
        }
    }

    void copy(boolean cut) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.copy(cut);
        } else {
            IJ.noImage();
        }
    }

    void paste() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            imp.paste();
        } else {
            IJ.noImage();
        }
    }

    boolean setup() {
        if (!IJ.isJava14()) {
            IJ.error("Clipboard", "Java 1.4 or later required");
            return false;
        }
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return true;
    }

    void copyToSystem() {
        if (!this.setup()) {
            return;
        }
        try {
            clipboard.setContents(this, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void showSystemClipboard() {
        if (!this.setup()) {
            return;
        }
        try {
            Transferable transferable = clipboard.getContents(null);
            if (transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image img = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                int width = img.getWidth(null);
                int height = img.getHeight(null);
                BufferedImage bi = new BufferedImage(width, height, 1);
                Graphics2D g = bi.createGraphics();
                g.drawImage(img, 0, 0, null);
                g.dispose();
                WindowManager.checkForDuplicateName = true;
                new ImagePlus("Clipboard", bi).show();
            } else {
                IJ.error("Clipboard", "No image found on system clipboard.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.imageFlavor.equals(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            ImageProcessor ip = imp.getProcessor();
            ip = ip.crop();
            int w = ip.getWidth();
            int h = ip.getHeight();
            IJ.showStatus(String.valueOf(w) + "x" + h + " image copied to system clipboard");
            Image img = IJ.getInstance().createImage(w, h);
            Graphics g = img.getGraphics();
            g.drawImage(ip.createImage(), 0, 0, null);
            g.dispose();
            return img;
        }
        return null;
    }

    void showInternalClipboard() {
        ImagePlus clipboard = ImagePlus.getClipboard();
        if (clipboard != null) {
            ImageProcessor ip = clipboard.getProcessor();
            ImagePlus imp2 = new ImagePlus("Clipboard", ip.duplicate());
            Roi roi = clipboard.getRoi();
            imp2.killRoi();
            if (roi != null && roi.isArea() && roi.getType() != 0) {
                roi = (Roi)roi.clone();
                roi.setLocation(0, 0);
                imp2.setRoi(roi);
                WindowManager.setTempCurrentImage(imp2);
                IJ.run("Clear Outside");
                imp2.killRoi();
            }
            WindowManager.checkForDuplicateName = true;
            imp2.show();
        } else {
            IJ.error("The internal clipboard is empty.");
        }
    }
}

