/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.Opener;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class URLOpener
implements PlugIn {
    private static String url = "http://rsb.info.nih.gov/ij/images/clown.gif";

    public void run(String urlOrName) {
        if (!urlOrName.equals("")) {
            if (urlOrName.endsWith("StartupMacros.txt")) {
                this.openTextFile(urlOrName, true);
            } else {
                String url = urlOrName.indexOf("://") > 0 ? urlOrName : String.valueOf(Prefs.getImagesURL()) + urlOrName;
                ImagePlus imp = new ImagePlus(url);
                if (imp.getType() == 4) {
                    Opener.convertGrayJpegTo8Bits(imp);
                }
                WindowManager.checkForDuplicateName = true;
                imp.show();
            }
            return;
        }
        GenericDialog gd = new GenericDialog("Enter a URL");
        gd.addMessage("Enter URL of a TIFF, JPEG, GIF, PNG or DICOM image");
        gd.addStringField("URL:", url, 40);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        url = gd.getNextString();
        if ((url = url.trim()).indexOf("://") == -1) {
            url = "http://" + url;
        }
        if (url.endsWith("/")) {
            IJ.runPlugIn("ij.plugin.BrowserLauncher", url.substring(0, url.length() - 1));
        } else if (url.endsWith(".html") || url.endsWith(".htm")) {
            IJ.runPlugIn("ij.plugin.BrowserLauncher", url);
        } else if (url.endsWith(".txt") || url.endsWith(".ijm")) {
            this.openTextFile(url, false);
        } else {
            IJ.showStatus("Opening: " + url);
            ImagePlus imp = new ImagePlus(url);
            WindowManager.checkForDuplicateName = true;
            imp.show();
            IJ.showStatus("");
        }
        IJ.register(URLOpener.class);
    }

    void openTextFile(String urlString, boolean install) {
        StringBuffer sb = null;
        try {
            String line;
            URL url = new URL(urlString);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            if (!install || !urlString.endsWith("StartupMacros.txt")) {
                IJ.error("URL Opener", "" + e);
            }
            sb = null;
        }
        if (sb != null) {
            if (install) {
                new MacroInstaller().install(new String(sb));
            } else {
                new Editor().create(urlString, new String(sb));
            }
        }
    }
}

