/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.MeasurementsWriter;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextPanel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Properties;

public class Analyzer
implements PlugInFilter,
Measurements {
    private String arg;
    private ImagePlus imp;
    private ResultsTable rt;
    private int measurements;
    private StringBuffer min;
    private StringBuffer max;
    private StringBuffer mean;
    private StringBuffer sd;
    private static final int[] list = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 512, 2048, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 256, 1024, 4096};
    private static final int UNDEFINED = 0;
    private static final int AREAS = 1;
    private static final int LENGTHS = 2;
    private static final int ANGLES = 3;
    private static final int POINTS = 4;
    private static int mode = 1;
    private static final String MEASUREMENTS = "measurements";
    private static final String MARK_WIDTH = "mark.width";
    private static final String PRECISION = "precision";
    private static boolean unsavedMeasurements;
    public static Color darkBlue;
    private static int systemMeasurements;
    public static int markWidth;
    public static int precision;
    private static float[] umeans;
    private static ResultsTable systemRT;
    private static int redirectTarget;
    private static String redirectTitle;
    static int firstParticle;
    static int lastParticle;
    private static boolean summarized;
    private static boolean switchingModes;

    static {
        darkBlue = new Color(0, 0, 160);
        systemMeasurements = Prefs.getInt(MEASUREMENTS, 19);
        markWidth = Prefs.getInt(MARK_WIDTH, 0);
        precision = Prefs.getInt(PRECISION, 3);
        umeans = new float[20];
        systemRT = new ResultsTable();
        redirectTitle = "";
    }

    public Analyzer() {
        this.rt = systemRT;
        this.rt.setPrecision(precision);
        this.measurements = systemMeasurements;
    }

    public Analyzer(ImagePlus imp) {
        this();
        this.imp = imp;
    }

    public Analyzer(ImagePlus imp, int measurements, ResultsTable rt) {
        this.imp = imp;
        this.measurements = measurements;
        this.rt = rt;
    }

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(Analyzer.class);
        if (arg.equals("set")) {
            this.doSetDialog();
            return 4096;
        }
        if (arg.equals("sum")) {
            this.summarize();
            return 4096;
        }
        if (arg.equals("clear")) {
            if (IJ.macroRunning()) {
                unsavedMeasurements = false;
            }
            Analyzer.resetCounter();
            return 4096;
        }
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.measure();
    }

    void doSetDialog() {
        String[] titles;
        String NONE = "None";
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            titles = new String[]{NONE};
        } else {
            titles = new String[wList.length + 1];
            titles[0] = NONE;
            int i = 0;
            while (i < wList.length) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                titles[i + 1] = imp != null ? imp.getTitle() : "";
                ++i;
            }
        }
        ImagePlus tImp = WindowManager.getImage(redirectTarget);
        String target = tImp != null ? tImp.getTitle() : NONE;
        GenericDialog gd = new GenericDialog("Set Measurements", IJ.getInstance());
        String[] labels = new String[18];
        boolean[] states = new boolean[18];
        labels[0] = "Area";
        states[0] = (systemMeasurements & 1) != 0;
        labels[1] = "Mean Gray Value";
        states[1] = (systemMeasurements & 2) != 0;
        labels[2] = "Standard Deviation";
        states[2] = (systemMeasurements & 4) != 0;
        labels[3] = "Modal Gray Value";
        states[3] = (systemMeasurements & 8) != 0;
        labels[4] = "Min & Max Gray Value";
        states[4] = (systemMeasurements & 0x10) != 0;
        labels[5] = "Centroid";
        states[5] = (systemMeasurements & 0x20) != 0;
        labels[6] = "Center of Mass";
        states[6] = (systemMeasurements & 0x40) != 0;
        labels[7] = "Perimeter";
        states[7] = (systemMeasurements & 0x80) != 0;
        labels[8] = "Bounding Rectangle";
        states[8] = (systemMeasurements & 0x200) != 0;
        labels[9] = "Fit Ellipse";
        states[9] = (systemMeasurements & 0x800) != 0;
        labels[10] = "Circularity";
        states[10] = (systemMeasurements & 0x2000) != 0;
        labels[11] = "Feret's Diameter";
        states[11] = (systemMeasurements & 0x4000) != 0;
        labels[12] = "Integrated Density";
        states[12] = (systemMeasurements & 0x8000) != 0;
        labels[13] = "Median";
        states[13] = (systemMeasurements & 0x10000) != 0;
        labels[14] = "Skewness";
        states[14] = (systemMeasurements & 0x20000) != 0;
        labels[15] = "Kurtosis";
        states[15] = (systemMeasurements & 0x40000) != 0;
        labels[16] = "Area_Fraction";
        states[16] = (systemMeasurements & 0x80000) != 0;
        labels[17] = "Slice Number";
        states[17] = (systemMeasurements & 0x100000) != 0;
        gd.setInsets(0, 0, 0);
        gd.addCheckboxGroup(10, 2, labels, states);
        labels = new String[3];
        states = new boolean[3];
        labels[0] = "Limit to Threshold";
        states[0] = (systemMeasurements & 0x100) != 0;
        labels[1] = "Display Label";
        states[1] = (systemMeasurements & 0x400) != 0;
        labels[2] = "Invert Y Coordinates";
        states[2] = (systemMeasurements & 0x1000) != 0;
        gd.setInsets(0, 0, 0);
        gd.addCheckboxGroup(2, 2, labels, states);
        gd.setInsets(15, 0, 0);
        gd.addChoice("Redirect To:", titles, target);
        gd.setInsets(5, 0, 0);
        gd.addNumericField("Decimal Places (0-9):", precision, 0, 2, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.setOptions(gd);
        int index = gd.getNextChoiceIndex();
        redirectTarget = index == 0 ? 0 : wList[index - 1];
        redirectTitle = titles[index];
        int prec = (int)gd.getNextNumber();
        if (prec < 0) {
            prec = 0;
        }
        if (prec > 9) {
            prec = 9;
        }
        if (prec != precision) {
            precision = prec;
            this.rt.setPrecision(precision);
            if (mode == 1 && IJ.isResultsWindow()) {
                IJ.setColumnHeadings("");
                this.updateHeadings();
            }
        }
    }

    void setOptions(GenericDialog gd) {
        int oldMeasurements = systemMeasurements;
        int previous = 0;
        boolean b = false;
        int i = 0;
        while (i < list.length) {
            b = gd.getNextBoolean();
            previous = list[i];
            systemMeasurements = b ? (systemMeasurements |= list[i]) : (systemMeasurements &= ~list[i]);
            ++i;
        }
        if ((oldMeasurements & 0xFFFFFEFF) != (systemMeasurements & 0xFFFFFEFF)) {
            if (IJ.macroRunning()) {
                unsavedMeasurements = false;
                Analyzer.resetCounter();
                mode = 1;
            } else {
                mode = 0;
            }
        }
        if ((systemMeasurements & 0x400) == 0) {
            systemRT.disableRowLabels();
        }
    }

    void measure() {
        ImageStatistics stats;
        lastParticle = 0;
        firstParticle = 0;
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 10) {
            this.measurePoint(roi);
            return;
        }
        if (roi != null && roi.isLine()) {
            this.measureLength(roi);
            return;
        }
        if (roi != null && roi.getType() == 8) {
            this.measureAngle(roi);
            return;
        }
        if (mode != 1) {
            switchingModes = true;
            if (!Analyzer.resetCounter()) {
                return;
            }
            mode = 1;
        }
        if (Analyzer.isRedirectImage()) {
            stats = this.getRedirectStats(this.measurements, roi);
            if (stats == null) {
                return;
            }
        } else {
            stats = this.imp.getStatistics(this.measurements);
        }
        this.saveResults(stats, roi);
        this.displayResults();
    }

    public static boolean isRedirectImage() {
        return redirectTarget != 0;
    }

    public static ImagePlus getRedirectImage(ImagePlus currentImage) {
        ImagePlus rImp = WindowManager.getImage(redirectTarget);
        if (rImp == null) {
            IJ.error("Analyzer", "Redirect image (\"" + redirectTitle + "\")\n" + "not found.");
            redirectTarget = 0;
            Macro.abort();
            return null;
        }
        if (rImp.getWidth() != currentImage.getWidth() || rImp.getHeight() != currentImage.getHeight()) {
            IJ.error("Analyzer", "Redirect image (\"" + redirectTitle + "\") \n" + "is not the same size as the current image.");
            Macro.abort();
            return null;
        }
        return rImp;
    }

    ImageStatistics getRedirectStats(int measurements, Roi roi) {
        ImagePlus redirectImp = Analyzer.getRedirectImage(this.imp);
        if (redirectImp == null) {
            return null;
        }
        int depth = redirectImp.getStackSize();
        if (depth > 1 && depth == this.imp.getStackSize()) {
            redirectImp.setSlice(this.imp.getCurrentSlice());
        }
        ImageProcessor ip = redirectImp.getProcessor();
        if (this.imp.getTitle().equals("mask") && this.imp.getBitDepth() == 8) {
            ip.setMask(this.imp.getProcessor());
            ip.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else {
            ip.setRoi(roi);
        }
        return ImageStatistics.getStatistics(ip, measurements, redirectImp.getCalibration());
    }

    void measurePoint(Roi roi) {
        if (mode != 4) {
            switchingModes = true;
            if (!Analyzer.resetCounter()) {
                return;
            }
            mode = 4;
        }
        Polygon p = roi.getPolygon();
        ImageProcessor ip = this.imp.getProcessor();
        Calibration cal = this.imp.getCalibration();
        ip.setCalibrationTable(cal.getCTable());
        int i = 0;
        while (i < p.npoints) {
            this.incrementCounter();
            int x = p.xpoints[i];
            int y = p.ypoints[i];
            double value = ip.getPixelValue(x, y);
            if (markWidth > 0) {
                ip.setColor(Toolbar.getForegroundColor());
                ip.setLineWidth(markWidth);
                ip.moveTo(x, y);
                ip.lineTo(x, y);
                this.imp.updateAndDraw();
                ip.setLineWidth(Line.getWidth());
            }
            if ((this.measurements & 0x400) != 0) {
                this.rt.addLabel("Label", this.getFileName());
            }
            this.rt.addValue("X", cal.getX(x));
            this.rt.addValue("Y", cal.getY(y, this.imp.getHeight()));
            this.rt.addValue("Z", cal.getZ(this.imp.getCurrentSlice() - 1));
            this.rt.addValue("Value", value);
            this.displayResults();
            ++i;
        }
    }

    void measureAngle(Roi roi) {
        if (mode != 3) {
            switchingModes = true;
            if (!Analyzer.resetCounter()) {
                return;
            }
            if ((this.measurements & 0x400) != 0) {
                IJ.setColumnHeadings(" \tName\tangle");
            } else {
                IJ.setColumnHeadings(" \tangle");
            }
            mode = 3;
        }
        this.incrementCounter();
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("Label", this.getFileName());
        }
        this.rt.addValue("Angle", ((PolygonRoi)roi).getAngle());
        this.displayResults();
    }

    void measureLength(Roi roi) {
        boolean moreParams;
        if (mode != 2) {
            switchingModes = true;
            if (!Analyzer.resetCounter()) {
                return;
            }
            if ((this.measurements & 0x400) != 0) {
                IJ.setColumnHeadings(" \tName\tlength");
            } else {
                IJ.setColumnHeadings(" \tlength");
            }
            mode = 2;
        }
        this.incrementCounter();
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("Label", this.getFileName());
        }
        this.rt.addValue("Length", roi.getLength());
        double angle = 0.0;
        if (roi.getType() == 5) {
            Line l = (Line)roi;
            angle = roi.getAngle(l.x1, l.y1, l.x2, l.y2);
        }
        this.rt.addValue("Angle", angle);
        boolean bl = moreParams = (this.measurements & 2) != 0 || (this.measurements & 4) != 0 || (this.measurements & 8) != 0 || (this.measurements & 0x10) != 0;
        if (moreParams) {
            ProfilePlot profile = new ProfilePlot(this.imp);
            double[] values = profile.getProfile();
            FloatProcessor ip2 = new FloatProcessor(values.length, 1, values);
            ImageStatistics stats = ImageStatistics.getStatistics(ip2, 30, null);
            if ((this.measurements & 2) != 0) {
                this.rt.addValue(1, stats.mean);
            }
            if ((this.measurements & 4) != 0) {
                this.rt.addValue(2, stats.stdDev);
            }
            if ((this.measurements & 8) != 0) {
                this.rt.addValue(3, stats.dmode);
            }
            if ((this.measurements & 0x10) != 0) {
                this.rt.addValue(4, stats.min);
                this.rt.addValue(5, stats.max);
            }
        }
        if ((this.measurements & 0x200) != 0) {
            Rectangle r = roi.getBounds();
            Calibration cal = this.imp.getCalibration();
            this.rt.addValue(11, cal.getX(r.x));
            this.rt.addValue(12, cal.getY(r.y, this.imp.getHeight()));
            this.rt.addValue(13, (double)r.width * cal.pixelWidth);
            this.rt.addValue(14, (double)r.height * cal.pixelHeight);
        }
        this.displayResults();
    }

    public void saveResults(ImageStatistics stats, Roi roi) {
        this.incrementCounter();
        int counter = this.rt.getCounter();
        if (counter <= 20) {
            if (umeans == null) {
                umeans = new float[20];
            }
            Analyzer.umeans[counter - 1] = (float)stats.umean;
        }
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("Label", this.getFileName());
        }
        if ((this.measurements & 1) != 0) {
            this.rt.addValue(0, stats.area);
        }
        if ((this.measurements & 2) != 0) {
            this.rt.addValue(1, stats.mean);
        }
        if ((this.measurements & 4) != 0) {
            this.rt.addValue(2, stats.stdDev);
        }
        if ((this.measurements & 8) != 0) {
            this.rt.addValue(3, stats.dmode);
        }
        if ((this.measurements & 0x10) != 0) {
            this.rt.addValue(4, stats.min);
            this.rt.addValue(5, stats.max);
        }
        if ((this.measurements & 0x20) != 0) {
            this.rt.addValue(6, stats.xCentroid);
            this.rt.addValue(7, stats.yCentroid);
        }
        if ((this.measurements & 0x40) != 0) {
            this.rt.addValue(8, stats.xCenterOfMass);
            this.rt.addValue(9, stats.yCenterOfMass);
        }
        if ((this.measurements & 0x80) != 0 || (this.measurements & 0x2000) != 0) {
            double perimeter = roi != null ? roi.getLength() : 0.0;
            if ((this.measurements & 0x80) != 0) {
                this.rt.addValue(10, perimeter);
            }
            if ((this.measurements & 0x2000) != 0) {
                double circularity;
                double d = circularity = perimeter == 0.0 ? 0.0 : Math.PI * 4 * (stats.area / (perimeter * perimeter));
                if (circularity > 1.0) {
                    circularity = 1.0;
                }
                this.rt.addValue(18, circularity);
            }
        }
        if ((this.measurements & 0x200) != 0) {
            this.rt.addValue(11, stats.roiX);
            this.rt.addValue(12, stats.roiY);
            this.rt.addValue(13, stats.roiWidth);
            this.rt.addValue(14, stats.roiHeight);
        }
        if ((this.measurements & 0x800) != 0) {
            this.rt.addValue(15, stats.major);
            this.rt.addValue(16, stats.minor);
            this.rt.addValue(17, stats.angle);
        }
        if ((this.measurements & 0x4000) != 0) {
            this.rt.addValue(19, roi != null ? roi.getFeretsDiameter() : 0.0);
        }
        if ((this.measurements & 0x8000) != 0) {
            this.rt.addValue(20, stats.area * stats.mean);
        }
        if ((this.measurements & 0x10000) != 0) {
            this.rt.addValue(21, stats.median);
        }
        if ((this.measurements & 0x20000) != 0) {
            this.rt.addValue(22, stats.skewness);
        }
        if ((this.measurements & 0x40000) != 0) {
            this.rt.addValue(23, stats.kurtosis);
        }
        if ((this.measurements & 0x80000) != 0) {
            this.rt.addValue(24, stats.areaFraction);
        }
        if ((this.measurements & 0x100000) != 0) {
            this.rt.addValue(25, this.imp != null ? (double)this.imp.getCurrentSlice() : 1.0);
        }
    }

    String getFileName() {
        String s = "";
        if (this.imp != null) {
            Roi roi;
            String roiName;
            int len;
            if (mode == 1 && redirectTarget != 0) {
                ImagePlus rImp = WindowManager.getImage(redirectTarget);
                if (rImp != null) {
                    s = rImp.getTitle();
                }
            } else {
                s = this.imp.getTitle();
            }
            if ((len = s.length()) > 4 && s.charAt(len - 4) == '.' && !Character.isDigit(s.charAt(len - 1))) {
                s = s.substring(0, len - 4);
            }
            String string = roiName = (roi = this.imp.getRoi()) != null ? roi.getName() : null;
            if (roiName != null) {
                s = String.valueOf(s) + ":" + roiName;
            }
            if (this.imp.getStackSize() > 1) {
                ImageStack stack = this.imp.getStack();
                int currentSlice = this.imp.getCurrentSlice();
                String label = stack.getShortSliceLabel(currentSlice);
                String colon = s.equals("") ? "" : ":";
                s = label != null && !label.equals("") ? String.valueOf(s) + colon + label : String.valueOf(s) + colon + currentSlice;
            }
        }
        return s;
    }

    public void displayResults() {
        int counter = this.rt.getCounter();
        if (counter == 1) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write(this.rt.getRowAsString(counter - 1));
    }

    public void updateHeadings() {
        String tableHeadings;
        TextPanel tp = IJ.getTextPanel();
        if (tp == null) {
            return;
        }
        String worksheetHeadings = tp.getColumnHeadings();
        if (worksheetHeadings.equals(tableHeadings = this.rt.getColumnHeadings())) {
            return;
        }
        IJ.setColumnHeadings(tableHeadings);
        int n = this.rt.getCounter();
        if (n > 0) {
            StringBuffer sb = new StringBuffer(n * tableHeadings.length());
            int i = 0;
            while (i < n) {
                sb.append(String.valueOf(this.rt.getRowAsString(i)) + "\n");
                ++i;
            }
            tp.append(new String(sb));
        }
    }

    public String n(double n) {
        String s = (double)Math.round(n) == n ? IJ.d2s(n, 0) : IJ.d2s(n, precision);
        return String.valueOf(s) + "\t";
    }

    void incrementCounter() {
        if (this.rt == null) {
            this.rt = systemRT;
        }
        this.rt.incrementCounter();
        unsavedMeasurements = true;
    }

    public void summarize() {
        String worksheetHeadings;
        this.rt = systemRT;
        if (this.rt.getCounter() == 0) {
            return;
        }
        if (summarized) {
            this.rt.show("Results");
        }
        this.measurements = systemMeasurements;
        this.min = new StringBuffer(100);
        this.max = new StringBuffer(100);
        this.mean = new StringBuffer(100);
        this.sd = new StringBuffer(100);
        this.min.append("Min\t");
        this.max.append("Max\t");
        this.mean.append("Mean\t");
        this.sd.append("SD\t");
        if ((this.measurements & 0x400) != 0) {
            this.min.append("\t");
            this.max.append("\t");
            this.mean.append("\t");
            this.sd.append("\t");
        }
        if (mode == 4) {
            this.summarizePoints(this.rt);
        } else if (mode == 2) {
            this.summarizeLengths(this.rt);
        } else if (mode == 3) {
            this.add2(this.rt.getColumnIndex("Angle"));
        } else {
            this.summarizeAreas();
        }
        TextPanel tp = IJ.getTextPanel();
        if (tp != null && (worksheetHeadings = tp.getColumnHeadings()).equals("")) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write("");
        IJ.write(new String(this.mean));
        IJ.write(new String(this.sd));
        IJ.write(new String(this.min));
        IJ.write(new String(this.max));
        IJ.write("");
        this.mean = null;
        this.sd = null;
        this.min = null;
        this.max = null;
        summarized = true;
    }

    void summarizePoints(ResultsTable rt) {
        this.add2(rt.getColumnIndex("X"));
        this.add2(rt.getColumnIndex("Y"));
        this.add2(rt.getColumnIndex("Z"));
        this.add2(rt.getColumnIndex("Value"));
    }

    void summarizeLengths(ResultsTable rt) {
        int index = rt.getColumnIndex("Mean");
        if (rt.columnExists(index)) {
            this.add2(index);
        }
        if (rt.columnExists(index = rt.getColumnIndex("StdDev"))) {
            this.add2(index);
        }
        if (rt.columnExists(index = rt.getColumnIndex("Mode"))) {
            this.add2(index);
        }
        if (rt.columnExists(index = rt.getColumnIndex("Min"))) {
            this.add2(index);
        }
        if (rt.columnExists(index = rt.getColumnIndex("Max"))) {
            this.add2(index);
        }
        if (rt.columnExists(index = rt.getColumnIndex("Angle"))) {
            this.add2(index);
        }
        if (rt.columnExists(index = rt.getColumnIndex("Length"))) {
            this.add2(index);
        }
    }

    void summarizeAreas() {
        if ((this.measurements & 1) != 0) {
            this.add2(0);
        }
        if ((this.measurements & 2) != 0) {
            this.add2(1);
        }
        if ((this.measurements & 4) != 0) {
            this.add2(2);
        }
        if ((this.measurements & 8) != 0) {
            this.add2(3);
        }
        if ((this.measurements & 0x10) != 0) {
            this.add2(4);
            this.add2(5);
        }
        if ((this.measurements & 0x20) != 0) {
            this.add2(6);
            this.add2(7);
        }
        if ((this.measurements & 0x40) != 0) {
            this.add2(8);
            this.add2(9);
        }
        if ((this.measurements & 0x80) != 0) {
            this.add2(10);
        }
        if ((this.measurements & 0x200) != 0) {
            this.add2(11);
            this.add2(12);
            this.add2(13);
            this.add2(14);
        }
        if ((this.measurements & 0x800) != 0) {
            this.add2(15);
            this.add2(16);
            this.add2(17);
        }
        if ((this.measurements & 0x2000) != 0) {
            this.add2(18);
        }
        if ((this.measurements & 0x4000) != 0) {
            this.add2(19);
        }
        if ((this.measurements & 0x8000) != 0) {
            this.add2(19);
        }
        if ((this.measurements & 0x10000) != 0) {
            this.add2(21);
        }
        if ((this.measurements & 0x20000) != 0) {
            this.add2(22);
        }
        if ((this.measurements & 0x40000) != 0) {
            this.add2(23);
        }
        if ((this.measurements & 0x80000) != 0) {
            this.add2(24);
        }
    }

    private void add2(int column) {
        float[] c;
        float[] fArray = c = column >= 0 ? this.rt.getColumn(column) : null;
        if (c != null) {
            FloatProcessor ip = new FloatProcessor(c.length, 1, c, null);
            if (ip == null) {
                return;
            }
            FloatStatistics stats = new FloatStatistics(ip);
            if (stats == null) {
                return;
            }
            this.mean.append(this.n(stats.mean));
            this.min.append(this.n(stats.min));
            this.max.append(this.n(stats.max));
            this.sd.append(this.n(stats.stdDev));
        } else {
            this.mean.append("-\t");
            this.min.append("-\t");
            this.max.append("-\t");
            this.sd.append("-\t");
        }
    }

    public static int getCounter() {
        return systemRT.getCounter();
    }

    public static synchronized boolean resetCounter() {
        TextPanel tp = IJ.isResultsWindow() ? IJ.getTextPanel() : null;
        int counter = systemRT.getCounter();
        int lineCount = tp != null ? IJ.getTextPanel().getLineCount() : 0;
        ImageJ ij = IJ.getInstance();
        boolean macro = IJ.macroRunning() && !switchingModes || Interpreter.isBatchMode();
        switchingModes = false;
        if (counter > 0 && lineCount > 0 && unsavedMeasurements && !macro && ij != null && !ij.quitting()) {
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)ij, "ImageJ", "Save " + counter + " measurements?");
            if (d.cancelPressed()) {
                return false;
            }
            if (d.yesPressed() && !new MeasurementsWriter().save("")) {
                return false;
            }
        }
        umeans = null;
        systemRT.reset();
        unsavedMeasurements = false;
        if (tp != null) {
            tp.selectAll();
            tp.clearSelection();
        }
        summarized = false;
        return true;
    }

    public static void setSaved() {
        unsavedMeasurements = false;
    }

    public static int getMeasurements() {
        return systemMeasurements;
    }

    public static void setMeasurements(int measurements) {
        systemMeasurements = measurements;
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(MEASUREMENTS, Integer.toString(systemMeasurements));
        prefs.put(MARK_WIDTH, Integer.toString(markWidth));
        prefs.put(PRECISION, Integer.toString(precision));
    }

    public static float[] getUMeans() {
        return umeans;
    }

    public static ResultsTable getResultsTable() {
        return systemRT;
    }

    public static int getPrecision() {
        return precision;
    }

    public static void setPrecision(int decimalPlaces) {
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if (decimalPlaces > 9) {
            decimalPlaces = 9;
        }
        precision = decimalPlaces;
    }

    public static int updateY(int y, int imageHeight) {
        if ((systemMeasurements & 0x1000) != 0) {
            y = imageHeight - y - 1;
        }
        return y;
    }

    public static double updateY(double y, int imageHeight) {
        if ((systemMeasurements & 0x1000) != 0) {
            y = (double)imageHeight - y - 1.0;
        }
        return y;
    }
}

