/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class Printer
implements PlugInFilter,
Printable {
    private ImagePlus imp;
    private static double scaling = 100.0;
    private static boolean drawBorder;
    private static boolean center;
    private static boolean label;
    private static boolean printSelection;
    private static boolean rotate;
    private static int fontSize;

    static {
        center = true;
        fontSize = 12;
    }

    public int setup(String arg, ImagePlus imp) {
        if (!IJ.isJava2()) {
            IJ.error("Print", "Printing requires Java 1.2 or later");
            return 4096;
        }
        if (arg.equals("setup")) {
            this.pageSetup();
            return 4096;
        }
        this.imp = imp;
        IJ.register(Printer.class);
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.print(this.imp);
    }

    void pageSetup() {
        GenericDialog gd = new GenericDialog("Page Setup");
        gd.addNumericField("Scale:", scaling, 0, 3, "%");
        gd.addCheckbox("Draw Border", drawBorder);
        gd.addCheckbox("Center on Page", center);
        gd.addCheckbox("Print Title", label);
        gd.addCheckbox("Selection Only", printSelection);
        gd.addCheckbox("Rotate 90\u00b0", rotate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        scaling = gd.getNextNumber();
        if (scaling < 5.0) {
            scaling = 5.0;
        }
        drawBorder = gd.getNextBoolean();
        center = gd.getNextBoolean();
        label = gd.getNextBoolean();
        printSelection = gd.getNextBoolean();
        rotate = gd.getNextBoolean();
    }

    void print(ImagePlus imp) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        if (IJ.macroRunning() || pj.printDialog()) {
            imp.startTiming();
            try {
                pj.print();
            }
            catch (PrinterException e) {
                IJ.log("" + e);
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        ImageProcessor ip = this.imp.getProcessor();
        Roi roi = this.imp.getRoi();
        if (printSelection && roi != null && roi.isArea()) {
            ip = ip.crop();
        }
        if (rotate) {
            ip = ip.rotateLeft();
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        int margin = 0;
        if (drawBorder) {
            margin = 1;
        }
        double scale = scaling / 100.0;
        int dstWidth = (int)((double)width * scale);
        int dstHeight = (int)((double)height * scale);
        int pageX = (int)pf.getImageableX();
        int pageY = (int)pf.getImageableY();
        int dstX = pageX + margin;
        int dstY = pageY + margin;
        Image img = ip.createImage();
        double pageWidth = pf.getImageableWidth() - (double)(2 * margin);
        double pageHeight = pf.getImageableHeight() - (double)(2 * margin);
        if (label && pageWidth - (double)dstWidth < (double)(fontSize + 5)) {
            dstY += fontSize + 5;
            pageHeight -= (double)(fontSize + 5);
        }
        if ((double)dstWidth > pageWidth || (double)dstHeight > pageHeight) {
            double hscale = pageWidth / (double)dstWidth;
            double vscale = pageHeight / (double)dstHeight;
            double scale2 = hscale <= vscale ? hscale : vscale;
            dstWidth = (int)((double)dstWidth * scale2);
            dstHeight = (int)((double)dstHeight * scale2);
        } else if (center) {
            dstX = (int)((double)dstX + (pageWidth - (double)dstWidth) / 2.0);
            dstY = (int)((double)dstY + (pageHeight - (double)dstHeight) / 2.0);
        }
        g.drawImage(img, dstX, dstY, dstX + dstWidth, dstY + dstHeight, 0, 0, width, height, null);
        if (drawBorder) {
            g.drawRect(dstX - 1, dstY - 1, dstWidth + 1, dstHeight + 1);
        }
        if (label) {
            g.setFont(new Font("SanSerif", 0, fontSize));
            g.setColor(Color.black);
            g.drawString(this.imp.getTitle(), pageX + 5, pageY + fontSize);
        }
        return 0;
    }
}

