/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.plugin.filter.Convolver;
import ij.process.FloatBlitter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class FloatProcessor
extends ImageProcessor {
    private float min;
    private float max;
    private float snapshotMin;
    private float snapshotMax;
    private float[] pixels;
    private byte[] pixels8;
    private float[] snapshotPixels = null;
    private byte[] LUT = null;
    private float fillColor = Float.MAX_VALUE;
    private boolean fixedScale = false;

    public FloatProcessor(int width, int height, float[] pixels, ColorModel cm) {
        if (pixels != null && width * height != pixels.length) {
            throw new IllegalArgumentException("width*height!=pixels.length");
        }
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.cm = cm;
        this.resetRoi();
        if (pixels != null) {
            this.findMinAndMax();
        }
    }

    public FloatProcessor(int width, int height) {
        this(width, height, new float[width * height], null);
    }

    public FloatProcessor(int width, int height, int[] pixels) {
        this(width, height);
        int i = 0;
        while (i < pixels.length) {
            this.pixels[i] = pixels[i];
            ++i;
        }
        this.findMinAndMax();
    }

    public FloatProcessor(int width, int height, double[] pixels) {
        this(width, height);
        int i = 0;
        while (i < pixels.length) {
            this.pixels[i] = (float)pixels[i];
            ++i;
        }
        this.findMinAndMax();
    }

    public FloatProcessor(float[][] array) {
        this.width = array.length;
        this.height = array[0].length;
        this.pixels = new float[this.width * this.height];
        int i = 0;
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                this.pixels[i++] = array[x][y];
                ++x;
            }
            ++y;
        }
        this.resetRoi();
        this.findMinAndMax();
    }

    public FloatProcessor(int[][] array) {
        this(array.length, array[0].length);
        this.setIntArray(array);
        this.findMinAndMax();
    }

    public void findMinAndMax() {
        if (this.fixedScale) {
            return;
        }
        this.min = Float.MAX_VALUE;
        this.max = -3.4028235E38f;
        int i = 0;
        while (i < this.width * this.height) {
            float value = this.pixels[i];
            if (!Float.isInfinite(value)) {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
            ++i;
        }
        this.pixelsModified = true;
        this.hideProgress();
    }

    public void setMinAndMax(double min, double max) {
        if (min == 0.0 && max == 0.0) {
            this.resetMinAndMax();
            return;
        }
        this.min = (float)min;
        this.max = (float)max;
        this.fixedScale = true;
        this.resetThreshold();
    }

    public void resetMinAndMax() {
        this.fixedScale = false;
        this.findMinAndMax();
        this.resetThreshold();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Image createImage() {
        boolean firstTime;
        boolean bl = firstTime = this.pixels8 == null;
        if (firstTime || !this.lutAnimation) {
            int size = this.width * this.height;
            if (this.pixels8 == null) {
                this.pixels8 = new byte[size];
            }
            float scale = 255.0f / (this.max - this.min);
            int i = 0;
            while (i < size) {
                int ivalue;
                float value = this.pixels[i] - this.min;
                if (value < 0.0f) {
                    value = 0.0f;
                }
                if ((ivalue = (int)(value * scale)) > 255) {
                    ivalue = 255;
                }
                this.pixels8[i] = (byte)ivalue;
                ++i;
            }
        }
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        if (this.source == null) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels8, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels8, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        this.lutAnimation = false;
        return this.img;
    }

    public ImageProcessor createProcessor(int width, int height) {
        FloatProcessor ip2 = new FloatProcessor(width, height, new float[width * height], this.getColorModel());
        ((ImageProcessor)ip2).setMinAndMax(this.getMin(), this.getMax());
        return ip2;
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        this.snapshotMin = this.min;
        this.snapshotMax = this.max;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new float[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
        this.pixelsModified = false;
        this.newSnapshot = true;
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        this.min = this.snapshotMin;
        this.max = this.snapshotMax;
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
    }

    public void reset(ImageProcessor mask) {
        if (mask == null || this.snapshotPixels == null) {
            return;
        }
        if (mask.getWidth() != this.roiWidth || mask.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mpixels[mi++] == 0) {
                    this.pixels[i] = this.snapshotPixels[i];
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
        this.newSnapshot = true;
    }

    public int getPixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return Float.floatToIntBits(this.pixels[y * this.width + x]);
        }
        return 0;
    }

    public final int get(int x, int y) {
        return (int)this.pixels[y * this.width + x];
    }

    public final void set(int x, int y, int value) {
        this.pixels[y * this.width + x] = value;
    }

    public final float getf(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    public final void setf(int x, int y, float value) {
        this.pixels[y * this.width + x] = value;
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        if (iArray == null) {
            iArray = new int[]{(int)this.getPixelValue(x, y)};
        }
        return iArray;
    }

    public void putPixel(int x, int y, int[] iArray) {
        this.putPixelValue(x, y, iArray[0]);
    }

    public double getInterpolatedPixel(double x, double y) {
        if (x < 0.0) {
            x = 0.0;
        }
        if (x >= (double)this.width - 1.0) {
            x = (double)this.width - 1.001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if (y >= (double)this.height - 1.0) {
            y = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(x, y, this.pixels);
    }

    public void putPixel(int x, int y, int value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = Float.intBitsToFloat(value);
        }
    }

    public void putPixelValue(int x, int y, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y * this.width + x] = (float)value;
        }
    }

    public float getPixelValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.pixels[y * this.width + x];
        }
        return 0.0f;
    }

    public void drawPixel(int x, int y) {
        if (x >= this.clipXMin && x <= this.clipXMax && y >= this.clipYMin && y <= this.clipYMax) {
            this.putPixel(x, y, Float.floatToIntBits(this.fillColor));
        }
    }

    public Object getPixels() {
        return this.pixels;
    }

    public Object getPixelsCopy() {
        if (this.newSnapshot && this.snapshotPixels != null) {
            return this.snapshotPixels;
        }
        float[] pixels2 = new float[this.width * this.height];
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return pixels2;
    }

    public void setPixels(Object pixels) {
        this.pixels = (float[])pixels;
        this.resetPixels(pixels);
        this.snapshotPixels = null;
        if (pixels == null) {
            this.pixels8 = null;
        }
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        new FloatBlitter(this).copyBits(ip, xloc, yloc, mode);
    }

    public void applyTable(int[] lut) {
    }

    private float[] getCopyOfPixels() {
        if (this.pixelsModified) {
            float[] pixelsCopy = new float[this.width * this.height];
            System.arraycopy(this.pixels, 0, pixelsCopy, 0, this.width * this.height);
            return pixelsCopy;
        }
        return this.snapshotPixels;
    }

    private void process(int op, double value) {
        boolean resetMinMax = this.roiWidth == this.width && this.roiHeight == this.height && op != 1;
        float c = (float)value;
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                float v2;
                float v1 = this.pixels[i];
                switch (op) {
                    case 0: {
                        v2 = this.max - (v1 - this.min);
                        break;
                    }
                    case 1: {
                        v2 = this.fillColor;
                        break;
                    }
                    case 2: {
                        v2 = v1 + c;
                        break;
                    }
                    case 3: {
                        v2 = v1 * c;
                        break;
                    }
                    case 7: {
                        if (v1 <= 0.0f) {
                            v2 = 0.0f;
                            break;
                        }
                        v2 = (float)Math.exp((double)c * Math.log(v1));
                        break;
                    }
                    case 8: {
                        if (v1 <= 0.0f) {
                            v2 = 0.0f;
                            break;
                        }
                        v2 = (float)Math.log(v1);
                        break;
                    }
                    case 13: {
                        v2 = (float)Math.exp(v1);
                        break;
                    }
                    case 11: {
                        v2 = v1 * v1;
                        break;
                    }
                    case 12: {
                        if (v1 <= 0.0f) {
                            v2 = 0.0f;
                            break;
                        }
                        v2 = (float)Math.sqrt(v1);
                        break;
                    }
                    case 9: {
                        if ((double)v1 < value) {
                            v2 = (float)value;
                            break;
                        }
                        v2 = v1;
                        break;
                    }
                    case 10: {
                        if ((double)v1 > value) {
                            v2 = (float)value;
                            break;
                        }
                        v2 = v1;
                        break;
                    }
                    default: {
                        v2 = v1;
                    }
                }
                this.pixels[i++] = v2;
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        if (resetMinMax) {
            this.findMinAndMax();
        }
    }

    public void invert() {
        this.process(0, 0.0);
    }

    public void add(int value) {
        this.process(2, value);
    }

    public void add(double value) {
        this.process(2, value);
    }

    public void multiply(double value) {
        this.process(3, value);
    }

    public void and(int value) {
    }

    public void or(int value) {
    }

    public void xor(int value) {
    }

    public void gamma(double value) {
        this.process(7, value);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public void exp() {
        this.process(13, 0.0);
    }

    public void sqr() {
        this.process(11, 0.0);
    }

    public void sqrt() {
        this.process(12, 0.0);
    }

    public void min(double value) {
        this.process(9, value);
    }

    public void max(double value) {
        this.process(10, value);
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public void fill(ImageProcessor mask) {
        if (mask == null) {
            this.fill();
            return;
        }
        if (mask.getWidth() != this.roiWidth || mask.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(mask));
        }
        byte[] mpixels = (byte[])mask.getPixels();
        int y = this.roiY;
        int my = 0;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int mi = my * this.roiWidth;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                if (mpixels[mi++] != 0) {
                    this.pixels[i] = this.fillColor;
                }
                ++i;
                ++x;
            }
            ++y;
            ++my;
        }
    }

    public void convolve3x3(int[] kernel) {
        int inc;
        float k1 = kernel[0];
        float k2 = kernel[1];
        float k3 = kernel[2];
        float k4 = kernel[3];
        float k5 = kernel[4];
        float k6 = kernel[5];
        float k7 = kernel[6];
        float k8 = kernel[7];
        float k9 = kernel[8];
        float scale = 0.0f;
        int i = 0;
        while (i < kernel.length) {
            scale += (float)kernel[i];
            ++i;
        }
        if (scale == 0.0f) {
            scale = 1.0f;
        }
        if ((inc = this.roiHeight / 25) < 1) {
            inc = 1;
        }
        float[] pixels2 = (float[])this.getPixelsCopy();
        int rowOffset = this.width;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            float p1 = 0.0f;
            float p2 = pixels2[offset - rowOffset - 1];
            float p3 = pixels2[offset - rowOffset];
            float p4 = 0.0f;
            float p5 = pixels2[offset - 1];
            float p6 = pixels2[offset];
            float p7 = 0.0f;
            float p8 = pixels2[offset + rowOffset - 1];
            float p9 = pixels2[offset + rowOffset];
            int x = this.xMin;
            while (x <= this.xMax) {
                p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1];
                p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1];
                p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1];
                float sum = k1 * p1 + k2 * p2 + k3 * p3 + k4 * p4 + k5 * p5 + k6 * p6 + k7 * p7 + k8 * p8 + k9 * p9;
                this.pixels[offset++] = sum /= scale;
                ++x;
            }
            if (y % inc == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void filter(int type) {
        int inc = this.roiHeight / 25;
        if (inc < 1) {
            inc = 1;
        }
        float[] pixels2 = (float[])this.getPixelsCopy();
        int rowOffset = this.width;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            float p1 = 0.0f;
            float p2 = pixels2[offset - rowOffset - 1];
            float p3 = pixels2[offset - rowOffset];
            float p4 = 0.0f;
            float p5 = pixels2[offset - 1];
            float p6 = pixels2[offset];
            float p7 = 0.0f;
            float p8 = pixels2[offset + rowOffset - 1];
            float p9 = pixels2[offset + rowOffset];
            int x = this.xMin;
            while (x <= this.xMax) {
                p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1];
                p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1];
                p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1];
                switch (type) {
                    case 0: {
                        this.pixels[offset++] = (p1 + p2 + p3 + p4 + p5 + p6 + p7 + p8 + p9) / 9.0f;
                        break;
                    }
                    case 1: {
                        float sum1 = p1 + 2.0f * p2 + p3 - p7 - 2.0f * p8 - p9;
                        float sum2 = p1 + 2.0f * p4 + p7 - p3 - 2.0f * p6 - p9;
                        this.pixels[offset++] = (float)Math.sqrt(sum1 * sum1 + sum2 * sum2);
                    }
                }
                ++x;
            }
            if (y % inc == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        if (type == 0) {
            this.hideProgress();
        } else {
            this.findMinAndMax();
        }
    }

    public void rotate(double angle) {
        float[] pixels2 = (float[])this.getPixelsCopy();
        double centerX = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double centerY = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int xMax = this.roiX + this.roiWidth - 1;
        double angleRadians = -angle / 57.29577951308232;
        double ca = Math.cos(angleRadians);
        double sa = Math.sin(angleRadians);
        double tmp1 = centerY * sa - centerX * ca;
        double tmp2 = -centerX * sa - centerY * ca;
        double dwidth = this.width;
        double dheight = this.height;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int index = y * this.width + this.roiX;
            double tmp3 = tmp1 - (double)y * sa + centerX;
            double tmp4 = tmp2 + (double)y * ca + centerY;
            int x = this.roiX;
            while (x <= xMax) {
                double xs = (double)x * ca + tmp3;
                double ys = (double)x * sa + tmp4;
                if (xs >= -0.01 && xs < dwidth && ys >= -0.01 && ys < dheight) {
                    if (this.interpolate) {
                        if (xs < 0.0) {
                            xs = 0.0;
                        }
                        if (xs >= xlimit) {
                            xs = xlimit2;
                        }
                        if (ys < 0.0) {
                            ys = 0.0;
                        }
                        if (ys >= ylimit) {
                            ys = ylimit2;
                        }
                        this.pixels[index++] = (float)this.getInterpolatedPixel(xs, ys, pixels2);
                    } else {
                        int ixs = (int)(xs + 0.5);
                        int iys = (int)(ys + 0.5);
                        if (ixs >= this.width) {
                            ixs = this.width - 1;
                        }
                        if (iys >= this.height) {
                            iys = this.height - 1;
                        }
                        this.pixels[index++] = pixels2[this.width * iys + ixs];
                    }
                } else {
                    this.pixels[index++] = 0.0f;
                }
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
    }

    public void flipVertical() {
        int y = 0;
        while (y < this.roiHeight / 2) {
            int index1 = (this.roiY + y) * this.width + this.roiX;
            int index2 = (this.roiY + this.roiHeight - 1 - y) * this.width + this.roiX;
            int i = 0;
            while (i < this.roiWidth) {
                float tmp = this.pixels[index1];
                this.pixels[index1++] = this.pixels[index2];
                this.pixels[index2++] = tmp;
                ++i;
            }
            ++y;
        }
        this.newSnapshot = false;
    }

    public void noise(double range) {
        Random rnd = new Random();
        int y = this.roiY;
        while (y < this.roiY + this.roiHeight) {
            int i = y * this.width + this.roiX;
            int x = this.roiX;
            while (x < this.roiX + this.roiWidth) {
                float RandomBrightness = (float)(rnd.nextGaussian() * range);
                this.pixels[i] = this.pixels[i] + RandomBrightness;
                ++i;
                ++x;
            }
            ++y;
        }
        this.resetMinAndMax();
    }

    public ImageProcessor crop() {
        ImageProcessor ip2 = this.createProcessor(this.roiWidth, this.roiHeight);
        float[] pixels2 = (float[])ip2.getPixels();
        int ys = this.roiY;
        while (ys < this.roiY + this.roiHeight) {
            int offset1 = (ys - this.roiY) * this.roiWidth;
            int offset2 = ys * this.width + this.roiX;
            int xs = 0;
            while (xs < this.roiWidth) {
                pixels2[offset1++] = this.pixels[offset2++];
                ++xs;
            }
            ++ys;
        }
        return ip2;
    }

    public synchronized ImageProcessor duplicate() {
        ImageProcessor ip2 = this.createProcessor(this.width, this.height);
        float[] pixels2 = (float[])ip2.getPixels();
        System.arraycopy(this.pixels, 0, pixels2, 0, this.width * this.height);
        return ip2;
    }

    public void scale(double xScale, double yScale) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        double xCenter = (double)this.roiX + (double)this.roiWidth / 2.0;
        double yCenter = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (xScale > 1.0 && yScale > 1.0) {
            xmin = (int)(xCenter - (xCenter - (double)this.roiX) * xScale);
            if (xmin < 0) {
                xmin = 0;
            }
            if ((xmax = xmin + (int)((double)this.roiWidth * xScale) - 1) >= this.width) {
                xmax = this.width - 1;
            }
            if ((ymin = (int)(yCenter - (yCenter - (double)this.roiY) * yScale)) < 0) {
                ymin = 0;
            }
            if ((ymax = ymin + (int)((double)this.roiHeight * yScale) - 1) >= this.height) {
                ymax = this.height - 1;
            }
        } else {
            xmin = this.roiX;
            xmax = this.roiX + this.roiWidth - 1;
            ymin = this.roiY;
            ymax = this.roiY + this.roiHeight - 1;
        }
        float[] pixels2 = (float[])this.getPixelsCopy();
        boolean checkCoordinates = xScale < 1.0 || yScale < 1.0;
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        int y = ymin;
        while (y <= ymax) {
            double ys = ((double)y - yCenter) / yScale + yCenter;
            int ysi = (int)ys;
            if (ys < 0.0) {
                ys = 0.0;
            }
            if (ys >= ylimit) {
                ys = ylimit2;
            }
            int index1 = y * this.width + xmin;
            int index2 = this.width * (int)ys;
            int x = xmin;
            while (x <= xmax) {
                double xs = ((double)x - xCenter) / xScale + xCenter;
                int xsi = (int)xs;
                if (checkCoordinates && (xsi < xmin || xsi > xmax || ysi < ymin || ysi > ymax)) {
                    this.pixels[index1++] = this.min;
                } else if (this.interpolate) {
                    if (xs < 0.0) {
                        xs = 0.0;
                    }
                    if (xs >= xlimit) {
                        xs = xlimit2;
                    }
                    this.pixels[index1++] = (float)this.getInterpolatedPixel(xs, ys, pixels2);
                } else {
                    this.pixels[index1++] = pixels2[index2 + xsi];
                }
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)(y - ymin) / (double)this.height);
            }
            ++y;
        }
        this.hideProgress();
    }

    private final double getInterpolatedPixel(double x, double y, float[] pixels) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        int offset = ybase * this.width + xbase;
        double lowerLeft = pixels[offset];
        double lowerRight = pixels[offset + 1];
        double upperRight = pixels[offset + this.width + 1];
        double upperLeft = pixels[offset + this.width];
        double upperAverage = upperLeft + xFraction * (upperRight - upperLeft);
        double lowerAverage = lowerLeft + xFraction * (lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    public ImageProcessor resize(int dstWidth, int dstHeight) {
        double srcCenterX = (double)this.roiX + (double)this.roiWidth / 2.0;
        double srcCenterY = (double)this.roiY + (double)this.roiHeight / 2.0;
        double dstCenterX = (double)dstWidth / 2.0;
        double dstCenterY = (double)dstHeight / 2.0;
        double xScale = (double)dstWidth / (double)this.roiWidth;
        double yScale = (double)dstHeight / (double)this.roiHeight;
        if (this.interpolate) {
            dstCenterX += xScale / 2.0;
            dstCenterY += yScale / 2.0;
        }
        ImageProcessor ip2 = this.createProcessor(dstWidth, dstHeight);
        float[] pixels2 = (float[])ip2.getPixels();
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        int y = 0;
        while (y <= dstHeight - 1) {
            double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
            if (this.interpolate) {
                if (ys < 0.0) {
                    ys = 0.0;
                }
                if (ys >= ylimit) {
                    ys = ylimit2;
                }
            }
            int index1 = this.width * (int)ys;
            int index2 = y * dstWidth;
            int x = 0;
            while (x <= dstWidth - 1) {
                double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                if (this.interpolate) {
                    if (xs < 0.0) {
                        xs = 0.0;
                    }
                    if (xs >= xlimit) {
                        xs = xlimit2;
                    }
                    pixels2[index2++] = (float)this.getInterpolatedPixel(xs, ys, this.pixels);
                } else {
                    pixels2[index2++] = this.pixels[index1 + (int)xs];
                }
                ++x;
            }
            if (y % 20 == 0) {
                this.showProgress((double)y / (double)dstHeight);
            }
            ++y;
        }
        this.hideProgress();
        return ip2;
    }

    public void setColor(Color color) {
        int bestIndex = this.getBestIndex(color);
        if (bestIndex > 0 && this.getMin() == 0.0 && this.getMax() == 0.0) {
            this.fillColor = bestIndex;
            this.setMinAndMax(0.0, 255.0);
        } else {
            this.fillColor = bestIndex == 0 && this.getMin() > 0.0 && (color.getRGB() & 0xFFFFFF) == 0 ? 0.0f : (float)((double)this.min + (double)(this.max - this.min) * ((double)bestIndex / 255.0));
        }
    }

    public void setValue(double value) {
        this.fillColor = (float)value;
    }

    public void setBackgroundValue(double value) {
    }

    public void setThreshold(double minThreshold, double maxThreshold, int lutUpdate) {
        if (minThreshold != -808080.0 && this.max > this.min) {
            double minT = Math.round((minThreshold - (double)this.min) / (double)(this.max - this.min) * 255.0);
            double maxT = Math.round((maxThreshold - (double)this.min) / (double)(this.max - this.min) * 255.0);
            super.setThreshold(minT, maxT, lutUpdate);
            this.minThreshold = minThreshold;
            this.maxThreshold = maxThreshold;
        } else {
            super.resetThreshold();
        }
    }

    public void convolve(float[] kernel, int kernelWidth, int kernelHeight) {
        this.snapshot();
        new Convolver().convolve(this, kernel, kernelWidth, kernelHeight);
    }

    public void threshold(int level) {
    }

    public void autoThreshold() {
    }

    public void medianFilter() {
    }

    public int[] getHistogram() {
        return null;
    }

    public void erode() {
    }

    public void dilate() {
    }
}

