/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;

public class ArrayChamferDistanceAnalysis
extends Analysis {
    private static final int[][] chamfer13 = new int[][]{{1, 0, 68}, {1, 1, 96}, {2, 1, 152}, {3, 1, 215}, {3, 2, 245}, {4, 1, 280}, {4, 3, 340}, {5, 1, 346}, {6, 1, 413}};
    private int[][] chamfer = chamfer13;
    private int normalizer = this.chamfer[0][2];
    private int width = 0;
    private int height = 0;
    private float[] outDatas;
    private float cellSize;

    public ArrayChamferDistanceAnalysis(float[] outDatas, int width, int height, float cellSize) {
        this.outDatas = outDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
    }

    @Override
    protected void doRun() {
        this.setResult(this.compute());
    }

    private void testAndSet(int x, int y, float newvalue) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        double v = this.outDatas[y * this.width + x];
        if (v == (double)Raster.getNoDataValue() || v >= 0.0 && v < (double)newvalue) {
            return;
        }
        this.outDatas[y * this.width + x] = newvalue;
    }

    private float[] compute() {
        int dt;
        int dy;
        int dx;
        int k;
        float v;
        int x;
        int y;
        for (y = 0; y <= this.height - 1; ++y) {
            for (x = 0; x <= this.width - 1; ++x) {
                v = this.outDatas[y * this.width + x];
                if (v < 0.0f) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    dx = this.chamfer[k][0];
                    dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(x + dx, y + dy, v + (float)dt);
                    if (dy != 0) {
                        this.testAndSet(x - dx, y + dy, v + (float)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(x + dy, y + dx, v + (float)dt);
                    if (dy == 0) continue;
                    this.testAndSet(x - dy, y + dx, v + (float)dt);
                }
            }
        }
        for (y = this.height - 1; y >= 0; --y) {
            for (x = this.width - 1; x >= 0; --x) {
                v = this.outDatas[y * this.width + x];
                if (v < 0.0f) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    dx = this.chamfer[k][0];
                    dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(x - dx, y - dy, v + (float)dt);
                    if (dy != 0) {
                        this.testAndSet(x + dx, y - dy, v + (float)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(x - dy, y - dx, v + (float)dt);
                    if (dy == 0) continue;
                    this.testAndSet(x + dy, y - dx, v + (float)dt);
                }
            }
        }
        return this.outDatas;
    }

    public float[] normalize() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                float v = this.outDatas[y * this.width + x];
                if (v == (float)Raster.getNoDataValue()) continue;
                this.outDatas[y * this.width + x] = v / (float)this.normalizer * this.cellSize;
            }
        }
        return this.outDatas;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doClose() {
    }
}

