/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.JaiMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.Collection;

public class ChamferDistanceCalculation
extends MatrixCalculation {
    private static final int[][] chamfer13 = new int[][]{{1, 0, 68}, {1, 1, 96}, {2, 1, 152}, {3, 1, 215}, {3, 2, 245}, {4, 1, 280}, {4, 3, 340}, {5, 1, 346}, {6, 1, 413}};
    private int[][] chamfer = chamfer13;
    private int normalizer = this.chamfer[0][2];
    private int width = 0;
    private int height = 0;
    private Matrix matrix;
    private Collection<Integer> codes;
    private double threshold;

    public ChamferDistanceCalculation(Matrix input, Collection<Integer> codes) {
        this(input, codes, Raster.getNoDataValue());
    }

    public ChamferDistanceCalculation(Matrix input, Collection<Integer> codes, double threshold) {
        super(input);
        this.matrix = input;
        this.codes = codes;
        this.threshold = threshold;
    }

    @Override
    protected void doRun() {
        this.setResult(this.compute(this.matrix, this.codes));
    }

    private void testAndSet(Matrix output, int x, int y, double newvalue) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        double v = output.get(x, y);
        if (v >= 0.0 && v < newvalue) {
            return;
        }
        output.put(x, y, newvalue);
    }

    private Matrix compute(Matrix input, Collection<Integer> codes) {
        int[] tab = new int[codes.size()];
        int index = 0;
        for (int i : codes) {
            tab[index++] = i;
        }
        return this.compute(input, tab);
    }

    private Matrix compute(Matrix input, int ... code) {
        int dt;
        int dy;
        int k;
        double v;
        int x;
        int y;
        Matrix output = JaiMatrixFactory.get().create(input.width(), input.height(), input.cellsize(), input.minX(), input.maxX(), input.minY(), input.maxY(), input.noDataValue());
        this.width = input.width();
        this.height = input.height();
        int total = this.width * this.height * 5;
        boolean hasCode = false;
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                v = input.get(x, y);
                boolean ok = false;
                if (v != (double)Raster.getNoDataValue()) {
                    for (int c : code) {
                        if ((double)c != v) continue;
                        ok = true;
                        hasCode = true;
                        break;
                    }
                }
                if (ok) {
                    output.put(x, y, 0.0);
                } else {
                    output.put(x, y, Raster.getNoDataValue());
                }
                this.updateProgression(total);
            }
        }
        if (!hasCode) {
            return output;
        }
        for (y = 0; y <= this.height - 1; ++y) {
            for (x = 0; x <= this.width - 1; ++x) {
                v = output.get(x, y);
                if (v == (double)Raster.getNoDataValue()) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    int dx = this.chamfer[k][0];
                    dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(output, x + dx, y + dy, v + (double)dt);
                    if (dy != 0) {
                        this.testAndSet(output, x - dx, y + dy, v + (double)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(output, x + dy, y + dx, v + (double)dt);
                    if (dy == 0) continue;
                    this.testAndSet(output, x - dy, y + dx, v + (double)dt);
                }
                this.updateProgression(total);
            }
        }
        for (y = this.height - 1; y >= 0; --y) {
            for (x = this.width - 1; x >= 0; --x) {
                v = output.get(x, y);
                if (v == (double)Raster.getNoDataValue()) continue;
                for (k = 0; k < this.chamfer.length; ++k) {
                    int dx = this.chamfer[k][0];
                    dy = this.chamfer[k][1];
                    dt = this.chamfer[k][2];
                    this.testAndSet(output, x - dx, y - dy, v + (double)dt);
                    if (dy != 0) {
                        this.testAndSet(output, x + dx, y - dy, v + (double)dt);
                    }
                    if (dx == dy) continue;
                    this.testAndSet(output, x - dy, y - dx, v + (double)dt);
                    if (dy == 0) continue;
                    this.testAndSet(output, x + dy, y - dx, v + (double)dt);
                }
                this.updateProgression(total);
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                v = output.get(x, y);
                if (v == (double)Raster.getNoDataValue()) continue;
                output.put(x, y, v / (double)this.normalizer * input.cellsize());
                this.updateProgression(total);
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                v = input.get(x, y);
                if (v == (double)Raster.getNoDataValue()) {
                    output.put(x, y, Raster.getNoDataValue());
                } else {
                    double v2 = output.get(x, y);
                    if (this.threshold != (double)Raster.getNoDataValue() && v2 > this.threshold) {
                        output.put(x, y, this.threshold);
                    }
                }
                this.updateProgression(total);
            }
        }
        return output;
    }
}

