/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix;

import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class RCMDistanceCalculationOld2
extends MatrixCalculation {
    private Collection<Integer> values;
    private boolean map;
    private Friction frictionMap;
    private Matrix frictionMat;
    private double threshold;

    public RCMDistanceCalculationOld2(Matrix m, Friction f, Collection<Integer> values) {
        this(m, f, values, (double)Raster.getNoDataValue());
    }

    public RCMDistanceCalculationOld2(Matrix m, Friction f, Collection<Integer> values, double threshold) {
        super(m);
        this.frictionMap = f;
        this.map = true;
        this.values = values;
        this.threshold = threshold;
    }

    public RCMDistanceCalculationOld2(Matrix m, Matrix f, Collection<Integer> values) {
        this(m, f, values, (double)Raster.getNoDataValue());
    }

    public RCMDistanceCalculationOld2(Matrix m, Matrix f, Collection<Integer> values, double threshold) {
        super(m);
        this.frictionMat = f;
        this.map = false;
        this.values = values;
        this.threshold = threshold;
    }

    @Override
    public void doInit() {
    }

    @Override
    public void doRun() {
        int v;
        Matrix dist = MatrixFactory.get(this.matrix().getType()).create(this.matrix().width(), this.matrix().height(), this.matrix().cellsize(), this.matrix().minX(), this.matrix().maxX(), this.matrix().minY(), this.matrix().maxY(), this.matrix().noDataValue());
        if (this.threshold != (double)Raster.getNoDataValue()) {
            dist.init(this.threshold);
        } else {
            dist.init(2.147483647E9);
        }
        int width = this.matrix().width();
        int height = this.matrix().height();
        int total = width * height * 2;
        LinkedList<Pixel> wp = new LinkedList<Pixel>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                v = new Double(this.matrix().get(x, y)).intValue();
                if (this.values.contains(v)) {
                    dist.put(x, y, 0.0);
                    int v0 = new Double(this.matrix().get(x - 1, y)).intValue();
                    if (v0 == Raster.getNoDataValue() || this.values.contains(v0)) {
                        int v1 = new Double(this.matrix().get(x - 1, y - 1)).intValue();
                        if (v1 == Raster.getNoDataValue() || this.values.contains(v1)) {
                            int v2 = new Double(this.matrix().get(x - 1, y + 1)).intValue();
                            if (v2 == Raster.getNoDataValue() || this.values.contains(v2)) {
                                int v3 = new Double(this.matrix().get(x, y + 1)).intValue();
                                if (v3 == Raster.getNoDataValue() || this.values.contains(v3)) {
                                    int v4 = new Double(this.matrix().get(x, y - 1)).intValue();
                                    if (v4 == Raster.getNoDataValue() || this.values.contains(v4)) {
                                        int v5 = new Double(this.matrix().get(x + 1, y - 1)).intValue();
                                        if (v5 == Raster.getNoDataValue() || this.values.contains(v5)) {
                                            int v6 = new Double(this.matrix().get(x + 1, y)).intValue();
                                            if (v6 == Raster.getNoDataValue() || this.values.contains(v6)) {
                                                int v7 = new Double(this.matrix().get(x + 1, y + 1)).intValue();
                                                if (v7 != Raster.getNoDataValue() && !this.values.contains(v7)) {
                                                    Pixel p = new Pixel(x, y);
                                                    wp.add(p);
                                                }
                                            } else {
                                                Pixel p = new Pixel(x, y);
                                                wp.add(p);
                                            }
                                        } else {
                                            Pixel p = new Pixel(x, y);
                                            wp.add(p);
                                        }
                                    } else {
                                        Pixel p = new Pixel(x, y);
                                        wp.add(p);
                                    }
                                } else {
                                    Pixel p = new Pixel(x, y);
                                    wp.add(p);
                                }
                            } else {
                                Pixel p = new Pixel(x, y);
                                wp.add(p);
                            }
                        } else {
                            Pixel p = new Pixel(x, y);
                            wp.add(p);
                        }
                    } else {
                        Pixel p = new Pixel(x, y);
                        wp.add(p);
                    }
                }
                this.updateProgression(total);
            }
        }
        Pixel lp = new Pixel(-1, -1);
        while (wp.size() > 0) {
            if (wp.size() % 10000 == 0) {
                System.out.println(wp.size());
            }
            lp = this.diffusion(this.matrix(), dist, wp, lp);
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                v = new Double(this.matrix().get(x, y)).intValue();
                if (v == Raster.getNoDataValue()) {
                    dist.put(x, y, Raster.getNoDataValue());
                }
                this.updateProgression(total);
            }
        }
        this.setResult(dist);
    }

    private Pixel diffusion(Matrix m, Matrix dist, LinkedList<Pixel> wp, Pixel lastP) {
        Pixel p = wp.poll();
        if (p != lastP) {
            double dd = dist.get(p);
            if (this.threshold == (double)Raster.getNoDataValue() || this.threshold > dd) {
                double vdn;
                double d;
                double fc;
                double v;
                Pixel np;
                double vd = m.get(p);
                double fd = this.friction(vd, p.x(), p.y());
                Iterator<Pixel> ite = p.getCardinalMargins();
                while (ite.hasNext()) {
                    np = ite.next();
                    v = m.get(np);
                    if (v == (double)Raster.getNoDataValue()) continue;
                    fc = this.friction(v, np.x(), np.y());
                    d = dd + m.cellsize() / 2.0 * fd + m.cellsize() / 2.0 * fc;
                    if (!(d < (vdn = dist.get(np)))) continue;
                    dist.put(np, d);
                    wp.addLast(np);
                }
                ite = p.getDiagonalMargins();
                while (ite.hasNext()) {
                    np = ite.next();
                    v = m.get(np);
                    if (v == (double)Raster.getNoDataValue()) continue;
                    fc = this.friction(v, np.x(), np.y());
                    d = dd + m.cellsize() * Math.sqrt(2.0) / 2.0 * fd + m.cellsize() * Math.sqrt(2.0) / 2.0 * fc;
                    if (!(d < (vdn = dist.get(np)))) continue;
                    dist.put(np, d);
                    wp.addLast(np);
                }
            }
            return p;
        }
        return lastP;
    }

    private double friction(double v, int x, int y) {
        if (this.map) {
            return this.frictionMap.get(v);
        }
        return this.frictionMat.get(x, y);
    }

    @Override
    public void doClose() {
    }

    private class GComparator<G>
    implements Comparator<G> {
        private Map<G, Double> w;

        public GComparator(Map<G, Double> w) {
            this.w = w;
        }

        @Override
        public int compare(G g1, G g2) {
            return this.w.get(g1).compareTo(this.w.get(g2));
        }
    }
}

