/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Count;
import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.Pixel2PixelMatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ClusterOverlay
extends Pixel2PixelMatrixCalculation {
    private Set<Integer> values;
    private String csv;
    private Map<Integer, Map<Integer, Count>> patchs;

    public ClusterOverlay(Set<Integer> values, String csv, Matrix ... matrix) {
        super(matrix);
        this.values = values;
        this.csv = csv;
    }

    @Override
    protected void doInit() {
        this.patchs = new TreeMap<Integer, Map<Integer, Count>>();
        for (int vC : this.matrix(0).values()) {
            if (vC == 0 || vC == Raster.getNoDataValue()) continue;
            this.patchs.put(vC, new TreeMap());
            for (int vM : this.matrix(1).values()) {
                if (vM == 0 || vM == Raster.getNoDataValue()) continue;
                this.patchs.get(vC).put(vM, new Count());
            }
        }
    }

    @Override
    protected double treatPixel(Pixel p) {
        int vM = new Double(this.matrix(1).get(p)).intValue();
        if (vM != Raster.getNoDataValue()) {
            int vC = new Double(this.matrix(0).get(p)).intValue();
            if (vC != 0 && vC != Raster.getNoDataValue() && this.values.contains(vM)) {
                this.patchs.get(vC).get(vM).add();
                return this.matrix(0).get(p);
            }
            return 0.0;
        }
        return Raster.getNoDataValue();
    }

    @Override
    protected void doClose() {
        try {
            CsvWriter cw = new CsvWriter(this.csv);
            cw.setDelimiter(';');
            cw.write("id");
            cw.write("nb_pixels_patch");
            cw.write("surface_patch");
            for (int vM : this.values) {
                if (vM == 0 || vM == Raster.getNoDataValue()) continue;
                cw.write("nb_pixels_patch_" + vM);
                cw.write("surface_patch_" + vM);
                cw.write("rate_patch_" + vM);
            }
            cw.endRecord();
            for (int vC : this.matrix(0).values()) {
                if (vC == 0 || vC == Raster.getNoDataValue()) continue;
                cw.write(vC + "");
                int nbpp = 0;
                for (int vM : this.values) {
                    if (vM == 0 || vM == Raster.getNoDataValue()) continue;
                    nbpp += this.patchs.get(vC).get(vM).get();
                }
                cw.write(nbpp + "");
                cw.write((double)nbpp * Math.pow(Raster.getCellSize(), 2.0) + "");
                int nbpsp = 0;
                for (int vM : this.values) {
                    if (vM == 0 || vM == Raster.getNoDataValue()) continue;
                    nbpsp = this.patchs.get(vC).get(vM).get();
                    cw.write(nbpsp + "");
                    cw.write((double)nbpsp * Math.pow(Raster.getCellSize(), 2.0) + "");
                    cw.write((double)nbpsp * 100.0 / (double)nbpp + "");
                }
                cw.endRecord();
            }
            cw.close();
        }
        catch (CsvWriter.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }
}

