/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.cluster;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.ChamferDistanceCalculation;
import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.MatrixCalculation;
import fr.inra.sad.bagap.apiland.analysis.matrix.RCMDistanceCalculation;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusterOverlay;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringQueenAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.Pixel2PixelMatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import java.util.HashSet;
import java.util.Set;

public class ClusteringDistanceAnalysis
extends MatrixAnalysis
implements AnalysisObserver {
    private double[] distances;
    private Set<Integer> interest;
    private String path;
    private String name;
    private int gTotal;
    private Friction frictionMap;
    private Matrix frictionMat;

    public ClusteringDistanceAnalysis(Matrix m, double[] distances, Set<Integer> interest, String path, String name, Friction frictionMap) {
        this(m, distances, interest, path, name);
        this.frictionMap = frictionMap;
    }

    public ClusteringDistanceAnalysis(Matrix m, double[] distances, Set<Integer> interest, String path, String name, Matrix frictionMat) {
        this(m, distances, interest, path, name);
        this.frictionMat = frictionMat;
    }

    public ClusteringDistanceAnalysis(Matrix m, double[] distances, Set<Integer> interest, String path, String name) {
        super(m);
        this.distances = distances;
        this.interest = interest;
        if (path == null || path.equalsIgnoreCase("")) {
            this.name = !name.endsWith(".asc") ? name + ".asc" : name;
        } else {
            this.path = !path.endsWith("/") ? path + "/" : path;
            this.name = name;
        }
        this.gTotal = this.frictionMap != null || this.frictionMat != null ? 3 * this.matrix().size() : 8 * this.matrix().size();
    }

    private double getMaxDistance() {
        double d = 0.0;
        for (double distance : this.distances) {
            d = Math.max(d, distance);
        }
        return d;
    }

    @Override
    protected void doRun() {
        try {
            Matrix mD = this.distance(this.matrix());
            for (double distance : this.distances) {
                Matrix mClassif = this.classification(mD, distance);
                Matrix mCluster = this.cluster(mClassif);
                this.overlay(this.matrix(), mCluster, distance);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private Matrix distance(Matrix matrix) {
        MatrixCalculation cdistance = null;
        cdistance = this.frictionMap != null ? new RCMDistanceCalculation(matrix, this.frictionMap, this.interest, this.getMaxDistance() / 2.0) : (this.frictionMat != null ? new RCMDistanceCalculation(matrix, this.frictionMat, this.interest, this.getMaxDistance() / 2.0) : new ChamferDistanceCalculation(matrix, this.interest));
        cdistance.addObserver(this);
        Matrix d = cdistance.allRun();
        return d;
    }

    private Matrix classification(Matrix mD, final double distance) {
        try {
            Pixel2PixelMatrixCalculation classif = new Pixel2PixelMatrixCalculation(new Matrix[]{mD}){

                @Override
                protected double treatPixel(Pixel p) {
                    double v = this.matrix().get(p);
                    if (v == (double)Raster.getNoDataValue()) {
                        return Raster.getNoDataValue();
                    }
                    if (v <= (distance - Raster.getCellSize()) / 2.0) {
                        return 1.0;
                    }
                    return 0.0;
                }
            };
            classif.addObserver(this);
            Matrix m = classif.allRun();
            return m;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Matrix cluster(Matrix mClassif) {
        try {
            HashSet<Integer> vcluster = new HashSet<Integer>();
            vcluster.add(1);
            ClusteringQueenAnalysis cqa = new ClusteringQueenAnalysis(mClassif, vcluster);
            cqa.addObserver(this);
            Matrix mCluster = RasterManager.exportMatrix((Raster)cqa.allRun(), mClassif);
            return mCluster;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void overlay(Matrix mOccsol, Matrix mCluster, double distance) {
        try {
            String csv = null;
            String ascii = null;
            if (this.path == null || this.path.equalsIgnoreCase("")) {
                csv = this.name.replace(".asc", ".csv");
                ascii = this.name;
            } else {
                String[] splitdistances = new Double(distance).toString().split("\\.");
                String d = splitdistances[0];
                csv = this.path + "cluster_" + this.name + "_" + d + ".csv";
                ascii = this.path + "cluster_" + this.name + "_" + d + ".asc";
            }
            ClusterOverlay co = new ClusterOverlay(this.interest, csv, mCluster, mOccsol);
            co.addObserver(this);
            MatrixManager.exportAsciiGrid(co.allRun(), ascii);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }

    @Override
    public void updateProgression(Analysis a, int total) {
        this.updateProgression(this.gTotal);
    }
}

