/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class AsciiGridOutput
extends AbstractMetricOutput {
    private String ascii;
    private int delta;
    private BufferedWriter writer;
    private String metric;
    private int yGlobal;

    public AsciiGridOutput(String metric, String output) {
        this(metric, output, 1);
    }

    public AsciiGridOutput(String metric, String output, int delta) {
        this.metric = metric;
        this.ascii = output;
        this.delta = delta;
        this.yGlobal = -1;
    }

    public String toString() {
        return "ascii_" + this.metric;
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis wa) {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.ascii));
            int nc = new Double(wa.matrix().width() / this.delta).intValue();
            if (wa.matrix().width() % this.delta != 0) {
                ++nc;
            }
            this.writer.write("ncols " + nc);
            this.writer.newLine();
            int nr = new Double(wa.matrix().height() / this.delta).intValue();
            if (wa.matrix().height() % this.delta != 0) {
                ++nr;
            }
            this.writer.write("nrows " + nr);
            this.writer.newLine();
            this.writer.write("xllcorner " + wa.matrix().minX());
            this.writer.newLine();
            this.writer.write("yllcorner " + wa.matrix().minY());
            this.writer.newLine();
            this.writer.write("cellsize " + (double)this.delta * wa.matrix().cellsize());
            this.writer.newLine();
            this.writer.write("NODATA_value " + Raster.getNoDataValue());
            this.writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisFinish(WindowMatrixAnalysis wa) {
        try {
            this.writer.newLine();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(DynamicLayerFactory.class.getResourceAsStream(MatrixManager.epsg()), this.ascii.replace(".asc", "") + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean acceptMetric(String metric) {
        return this.metric.equalsIgnoreCase(metric);
    }

    @Override
    public void notify(Metric m, String n, double v, Process p) {
        if (this.acceptMetric(n)) {
            try {
                if (this.yGlobal == -1) {
                    this.writer.write(this.format(v) + "");
                    this.yGlobal = 0;
                } else if (((WindowMatrixProcess)p).y() != this.yGlobal) {
                    this.writer.newLine();
                    this.writer.write(this.format(v) + "");
                    this.yGlobal = ((WindowMatrixProcess)p).y();
                } else {
                    this.writer.write(" " + this.format(v));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

