/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.FilteredRectangularWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.SimpleWindow;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.MetricOutput;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ClusteredCsvOutput
extends AbstractMetricOutput
implements MetricOutput {
    private CsvWriter out;
    private Set<String> metrics;
    private String file;
    private Map<Pixel, Map<String, Double>> values;
    private Map<Pixel, String> names;

    public ClusteredCsvOutput(Set<String> metrics, String f) {
        this.metrics = metrics;
        this.file = f;
        this.names = new TreeMap<Pixel, String>();
        this.values = new TreeMap<Pixel, Map<String, Double>>();
    }

    public String toString() {
        return "csv";
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
        switch (state) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis ma) {
        try {
            this.out = new CsvWriter(this.file);
            this.out.setDelimiter(';');
            this.out.write("cluster");
            for (String m : this.metrics) {
                this.out.write(m);
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisFinish(WindowMatrixAnalysis a) {
        this.out.close();
    }

    @Override
    public void notify(Process wp, ProcessState state) {
        switch (state) {
            case READY: {
                this.notifyProcessReady((WindowMatrixProcess)wp);
                break;
            }
            case DONE: {
                this.notifyProcessDone((WindowMatrixProcess)wp);
            }
        }
    }

    private void notifyProcessReady(WindowMatrixProcess wp) {
        this.names.put(wp.pixel(), ((FilteredRectangularWindow)((SimpleWindow)wp.window()).shape()).getValue() + "");
        this.values.put(wp.pixel(), new TreeMap());
    }

    private void notifyProcessDone(WindowMatrixProcess wp) {
        try {
            this.out.write(this.names.get(wp.pixel()));
            for (double v : this.values.get(wp.pixel()).values()) {
                this.out.write(this.format(v));
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean acceptMetric(String metric) {
        return this.metrics.contains(metric);
    }

    @Override
    public void notify(Metric m, String metric, double v, Process wp) {
        if (this.acceptMetric(metric)) {
            this.values.get(((WindowMatrixProcess)wp).pixel()).put(metric, v);
        }
    }
}

