/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class HeaderGridAsciiGridOutput
extends AbstractMetricOutput {
    private int size;
    private String ascii;
    private int delta;
    private BufferedWriter writer;
    private String metric;

    public HeaderGridAsciiGridOutput(int size, String f) {
        this.size = size;
        this.ascii = f;
        this.delta = size;
    }

    public String toString() {
        return "ascii_" + this.metric;
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis wa) {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.ascii));
            int nc = new Double(wa.matrix().width() / this.delta).intValue();
            if (wa.matrix().width() % this.delta != 0) {
                ++nc;
            }
            this.writer.write("ncols " + nc);
            this.writer.newLine();
            int nr = new Double(wa.matrix().height() / this.delta).intValue();
            if (wa.matrix().height() % this.delta != 0) {
                ++nr;
            }
            this.writer.write("nrows " + nr);
            this.writer.newLine();
            this.writer.write("xllcorner " + wa.matrix().minX());
            this.writer.newLine();
            if (wa.matrix().height() % this.size != 0) {
                double decalage = (double)(this.size - wa.matrix().height() % this.size) * Raster.getCellSize();
                this.writer.write("yllcorner " + (wa.matrix().minY() - decalage));
            } else {
                this.writer.write("yllcorner " + wa.matrix().minY());
            }
            this.writer.newLine();
            this.writer.write("cellsize " + (double)this.delta * wa.matrix().cellsize());
            this.writer.newLine();
            this.writer.write("NODATA_value " + Raster.getNoDataValue());
            this.writer.newLine();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

