/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.SchedulerOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.SplineCubic;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class InterpolateCubicSplineAsciiGridOutput
extends SchedulerOutput {
    private String ascii;
    private int delta;
    private BufferedWriter writer;
    private String metric;
    private int yGlobal;
    private int width;
    private int maxWidth;
    private int height;
    private int maxHeight;
    private Map<Integer, Double[]> values;
    private Double[] line;
    private Map<Integer, Count> vhIndex;

    public InterpolateCubicSplineAsciiGridOutput(String metric, String f, int d) {
        this.metric = metric;
        this.ascii = f;
        this.delta = d;
        this.yGlobal = -1;
    }

    public String toString() {
        return "ascii_" + this.metric;
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        super.notify(ma, s);
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis wa) {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.ascii));
            this.writer.write("ncols " + wa.matrix().width() + "\n");
            this.writer.write("nrows " + wa.matrix().height() + "\n");
            this.writer.write("xllcorner " + wa.matrix().minX() + "\n");
            this.writer.write("yllcorner " + wa.matrix().minY() + "\n");
            this.writer.write("cellsize " + wa.matrix().cellsize() + "\n");
            this.writer.write("NODATA_value " + Raster.getNoDataValue() + "\n");
            this.width = wa.matrix().width();
            this.maxWidth = this.width - (this.width - 1) % this.delta - 1;
            this.height = wa.matrix().height();
            this.maxHeight = this.height - (this.height - 1) % this.delta - 1;
            this.line = new Double[this.width];
            for (int i = 0; i < this.width; ++i) {
                this.line[i] = Raster.getNoDataValue();
            }
            this.vhIndex = new TreeMap<Integer, Count>();
            this.values = new TreeMap<Integer, Double[]>();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisFinish(WindowMatrixAnalysis wa) {
        try {
            this.writer.write(10);
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(DynamicLayerFactory.class.getResourceAsStream(MatrixManager.epsg()), this.ascii.replace(".asc", "") + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean acceptMetric(String metric) {
        return this.metric.equalsIgnoreCase(metric);
    }

    @Override
    protected void notifyChildMetric(String m, double v, WindowMatrixProcess p) {
        int j;
        int x = p.x();
        int y = p.y();
        if (x == 0) {
            if (y >= this.delta) {
                for (j = y - this.delta + 1; j < y; ++j) {
                    this.vhIndex.put(j, new Count());
                }
            }
            this.vhIndex.put(y, new Count());
        }
        if (!this.values.containsKey(y)) {
            if (y >= this.delta) {
                for (j = y - this.delta + 1; j < y; ++j) {
                    this.values.put(j, (Double[])this.line.clone());
                }
            }
            this.values.put(y, (Double[])this.line.clone());
        }
        this.values.get((Object)Integer.valueOf((int)y))[x] = v;
        if (v != (double)Raster.getNoDataValue()) {
            ++this.vhIndex.get((Object)Integer.valueOf((int)y)).n;
        }
        if (x == this.maxWidth && y >= 3 * this.delta) {
            this.interpolateVerticalLines(y);
            this.interpolateHorizontalLines(y);
            for (j = y - 3 * this.delta; j < y - 2 * this.delta; ++j) {
                this.values.remove(j);
                this.vhIndex.remove(j);
            }
        }
    }

    private void interpolateHorizontalLines(int y) {
        int j;
        if (y == 3 * this.delta) {
            for (j = 0; j <= this.delta; ++j) {
                this.interpolateHorizontalLine(j);
            }
        }
        for (j = y - 2 * this.delta + 1; j <= y - this.delta; ++j) {
            this.interpolateHorizontalLine(j);
        }
        if (y == this.maxHeight) {
            for (j = y - this.delta + 1; j <= y; ++j) {
                this.interpolateHorizontalLine(j);
            }
            for (j = y + 1; j < this.height; ++j) {
                this.vhIndex.put(j, new Count());
                this.interpolateHorizontalLine(j);
            }
        }
    }

    private void interpolateVerticalLines(int y) {
        for (int i = 0; i < this.width; i += this.delta) {
            int j;
            int[] yy = new int[4];
            double[] ff = new double[4];
            yy[0] = y - 3 * this.delta;
            double v = this.values.get(y - 3 * this.delta)[i];
            if (v == (double)Raster.getNoDataValue()) continue;
            ff[0] = v;
            yy[1] = y - 2 * this.delta;
            v = this.values.get(y - 2 * this.delta)[i];
            if (v == (double)Raster.getNoDataValue()) continue;
            ff[1] = v;
            yy[2] = y - this.delta;
            v = this.values.get(y - this.delta)[i];
            if (v == (double)Raster.getNoDataValue()) continue;
            ff[2] = v;
            yy[3] = y;
            v = this.values.get(y)[i];
            if (v == (double)Raster.getNoDataValue()) continue;
            ff[3] = v;
            SplineCubic spline = new SplineCubic(yy, ff);
            if (y == 3 * this.delta) {
                for (j = 1; j < this.delta; ++j) {
                    this.values.get((Object)Integer.valueOf((int)j))[i] = spline.spline_positive_value(j);
                    ++this.vhIndex.get((Object)Integer.valueOf((int)j)).n;
                }
            }
            for (j = y - 2 * this.delta + 1; j < y - this.delta; ++j) {
                this.values.get((Object)Integer.valueOf((int)j))[i] = spline.spline_positive_value(j);
                ++this.vhIndex.get((Object)Integer.valueOf((int)j)).n;
            }
            if (y != this.maxHeight) continue;
            for (j = y - this.delta + 1; j < y; ++j) {
                this.values.get((Object)Integer.valueOf((int)j))[i] = spline.spline_positive_value(j);
                ++this.vhIndex.get((Object)Integer.valueOf((int)j)).n;
            }
        }
    }

    private void interpolateHorizontalLine(int y) {
        int vi = this.vhIndex.get((Object)Integer.valueOf((int)y)).n;
        if (vi > 3) {
            int[] xx = new int[vi];
            double[] ff = new double[vi];
            int index = 0;
            int i = 0;
            while (i * this.delta < this.width) {
                double v = this.values.get(y)[i * this.delta];
                if (v != (double)Raster.getNoDataValue()) {
                    xx[index] = i * this.delta;
                    ff[index] = v;
                    ++index;
                }
                ++i;
            }
            SplineCubic spline = new SplineCubic(xx, ff);
            for (int i2 = 0; i2 < this.width; ++i2) {
                this.write(spline.spline_positive_value(i2), y);
            }
        } else {
            for (int i = 0; i < this.width; ++i) {
                this.write(Raster.getNoDataValue(), y);
            }
        }
    }

    private void write(double v, int y) {
        try {
            if (this.yGlobal == -1) {
                this.writer.write(this.format(v) + "");
                this.yGlobal = 0;
            } else if (y != this.yGlobal) {
                this.writer.write("\n" + this.format(v));
                this.yGlobal = y;
            } else {
                this.writer.write(" " + this.format(v));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void notifyProcessDone(WindowMatrixProcess key) {
    }

    private static class Count {
        int n = 0;

        private Count() {
        }
    }
}

