/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class InterpolateLinearSplineAsciiGridOutput
extends AbstractMetricOutput {
    private String ascii;
    private int delta;
    private BufferedWriter writer;
    private String metric;
    private int yGlobal;
    private int width;
    private int height;
    private int maxWidth;
    private int maxHeight;
    private Double[] values_d;
    private Map<Integer, Double[]> values;

    public InterpolateLinearSplineAsciiGridOutput(String metric, String f, int d) {
        this.metric = metric;
        this.ascii = f;
        this.delta = d;
        this.yGlobal = -1;
    }

    public String toString() {
        return "ascii_" + this.metric;
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis wa) {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.ascii));
            this.writer.write("ncols " + wa.matrix().width());
            this.writer.newLine();
            this.writer.write("nrows " + wa.matrix().height());
            this.writer.newLine();
            this.writer.write("xllcorner " + wa.matrix().minX());
            this.writer.newLine();
            this.writer.write("yllcorner " + wa.matrix().minY());
            this.writer.newLine();
            this.writer.write("cellsize " + wa.matrix().cellsize());
            this.writer.newLine();
            this.writer.write("NODATA_value " + Raster.getNoDataValue());
            this.writer.newLine();
            this.width = wa.matrix().width();
            this.maxWidth = this.width - (this.width - 1) % this.delta - 1;
            this.height = wa.matrix().height();
            this.maxHeight = this.height - (this.height - 1) % this.delta - 1;
            this.values = new TreeMap<Integer, Double[]>();
            this.values_d = new Double[this.width];
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisFinish(WindowMatrixAnalysis wa) {
        try {
            this.writer.newLine();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(DynamicLayerFactory.class.getResourceAsStream(MatrixManager.epsg()), this.ascii.replace(".asc", "") + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean acceptMetric(String metric) {
        return this.metric.equalsIgnoreCase(metric);
    }

    private double droite(double v_delta, double v, double yv) {
        if (v == (double)Raster.getNoDataValue() || v_delta == (double)Raster.getNoDataValue()) {
            return Raster.getNoDataValue();
        }
        return yv * (v - v_delta) / (double)this.delta + v_delta;
    }

    @Override
    public void notify(Metric m, String name, double v, Process p) {
        block20: {
            int yv;
            int y;
            int x;
            block22: {
                int yv2;
                int n;
                block21: {
                    if (!this.acceptMetric(name)) break block20;
                    x = ((WindowMatrixProcess)p).x();
                    y = ((WindowMatrixProcess)p).y();
                    if (y != 0) break block21;
                    if (x == 0) {
                        this.values.put(0, new Double[this.width]);
                        this.values.get((Object)Integer.valueOf((int)0))[0] = v;
                        for (int i = 1; i < this.width; ++i) {
                            this.values.get((Object)Integer.valueOf((int)0))[i] = Raster.getNoDataValue();
                        }
                    } else {
                        this.values.get((Object)Integer.valueOf((int)0))[x] = v;
                        for (int xv = 1; xv < this.delta; ++xv) {
                            this.values.get((Object)Integer.valueOf((int)0))[x - this.delta + xv] = this.droite(this.values.get(0)[x - this.delta], v, xv);
                        }
                    }
                    break block20;
                }
                if (x != 0) break block22;
                if (y > this.delta) {
                    for (int yv3 = 1; yv3 <= this.delta; ++yv3) {
                        Double[] doubleArray = this.values.get(y - 2 * this.delta + yv3);
                        n = doubleArray.length;
                        for (int i = 0; i < n; ++i) {
                            double d = doubleArray[i];
                            this.write(d, y - 2 * this.delta + yv3);
                        }
                    }
                } else {
                    Double[] yv3 = this.values.get(0);
                    int n2 = yv3.length;
                    for (n = 0; n < n2; ++n) {
                        double d = yv3[n];
                        this.write(d, 0);
                    }
                }
                for (int i = 0; i < this.width; ++i) {
                    this.values_d[i] = this.values.get(y - this.delta)[i];
                }
                this.values.clear();
                for (yv2 = 1; yv2 <= this.delta; ++yv2) {
                    this.values.put(y - this.delta + yv2, new Double[this.width]);
                    for (int i = 0; i < this.width; ++i) {
                        this.values.get((Object)Integer.valueOf((int)(y - this.delta + yv2)))[i] = Raster.getNoDataValue();
                    }
                }
                this.values.get((Object)Integer.valueOf((int)y))[0] = v;
                for (yv2 = 1; yv2 < this.delta; ++yv2) {
                    this.values.get((Object)Integer.valueOf((int)(y - this.delta + yv2)))[0] = this.droite(this.values_d[0], v, yv2);
                }
                break block20;
            }
            this.values.get((Object)Integer.valueOf((int)y))[x] = v;
            for (int xv = 1; xv < this.delta; ++xv) {
                this.values.get((Object)Integer.valueOf((int)y))[x - this.delta + xv] = this.droite(this.values.get(y)[x - this.delta], v, xv);
            }
            for (yv = 1; yv < this.delta; ++yv) {
                double vh = this.droite(this.values_d[x], v, yv);
                this.values.get((Object)Integer.valueOf((int)(y - this.delta + yv)))[x] = vh;
                for (int xv = 1; xv < this.delta; ++xv) {
                    this.values.get((Object)Integer.valueOf((int)(y - this.delta + yv)))[x - this.delta + xv] = this.droite(this.values.get(y - this.delta + yv)[x - this.delta], vh, xv);
                }
            }
            if (y != this.maxHeight || x != this.maxWidth) break block20;
            for (yv = 1; yv <= this.delta; ++yv) {
                Double[] xv = this.values.get(y - this.delta + yv);
                int n = xv.length;
                for (int i = 0; i < n; ++i) {
                    double d = xv[i];
                    this.write(d, y - this.delta + yv);
                }
            }
            for (int j = this.maxHeight + 1; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    this.write(Raster.getNoDataValue(), j);
                }
            }
        }
    }

    private void write(double v, int y) {
        try {
            if (this.yGlobal == -1) {
                this.writer.write(this.format(v) + "");
                this.yGlobal = 0;
            } else if (y != this.yGlobal) {
                this.writer.newLine();
                this.writer.write(this.format(v));
                this.yGlobal = y;
            } else {
                this.writer.write(" " + this.format(v));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

