/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.MetricOutput;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MapCsvOutput
extends AbstractMetricOutput
implements MetricOutput {
    private CsvWriter out;
    private Map<String, Double> values;

    public MapCsvOutput(String metric, CsvWriter cw) {
        this.out = cw;
        this.values = new TreeMap<String, Double>();
        this.values.put(metric, -1.0);
    }

    public MapCsvOutput(Set<String> metrics, CsvWriter cw) {
        this.out = cw;
        this.values = new TreeMap<String, Double>();
        for (String me : metrics) {
            this.values.put(me, -1.0);
        }
    }

    public String toString() {
        return "csv";
    }

    private void flush() {
        this.values.clear();
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
        switch (state) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis ma) {
        try {
            String f = new File(ma.matrix().getFile()).getName();
            this.out.write(f);
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notify(Process wp, ProcessState state) {
        switch (state) {
            case DONE: {
                this.notifyProcessDone((WindowMatrixProcess)wp);
            }
        }
    }

    private void notifyProcessDone(WindowMatrixProcess wp) {
        try {
            for (String v : this.values.keySet()) {
                this.out.write(this.format(this.values.get(v)));
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.flush();
    }

    @Override
    public boolean acceptMetric(String metric) {
        return this.values.containsKey(metric);
    }

    @Override
    public void notify(Metric m, String metric, double v, Process wp) {
        if (this.acceptMetric(metric)) {
            this.values.put(metric, v);
        } else {
            m.removeObserver(this);
        }
    }
}

