/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.VolatileWindowAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public abstract class SchedulerOutput
extends AbstractMetricOutput {
    private Map<WindowMatrixProcess, Map<String, Double>> processes;
    private Map<WindowMatrixProcess, Map<String, Double>> currents;
    private Pixel next;
    private VolatileWindowAnalysis analysis;

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis wa) {
        this.processes = new TreeMap<WindowMatrixProcess, Map<String, Double>>();
        this.currents = new TreeMap<WindowMatrixProcess, Map<String, Double>>();
        this.next = new Pixel(0, 0);
        this.analysis = (VolatileWindowAnalysis)((Object)wa);
    }

    private void notifyAnalysisFinish(WindowMatrixAnalysis wa) {
        this.processes = null;
        this.currents = null;
    }

    @Override
    public void notify(Process p, ProcessState s) {
        if (p instanceof WindowMatrixProcess) {
            switch (s) {
                case DONE: {
                    this.updateDone((WindowMatrixProcess)p);
                }
            }
        }
    }

    private void updateDone(WindowMatrixProcess wp) {
        Map<String, Double> c = this.currents.remove(wp);
        if (c != null) {
            this.processes.put(wp, c);
            Iterator<Map.Entry<WindowMatrixProcess, Map<String, Double>>> ite = this.processes.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<WindowMatrixProcess, Map<String, Double>> e = ite.next();
                if (e.getKey().x() == this.next.x() && e.getKey().y() == this.next.y()) {
                    this.next = this.analysis.next(this.next);
                    for (Map.Entry<String, Double> e2 : e.getValue().entrySet()) {
                        this.notifyChildMetric(e2.getKey(), e2.getValue(), e.getKey());
                    }
                    this.notifyProcessDone(e.getKey());
                    ite.remove();
                    if (this.next != null) continue;
                    return;
                }
                return;
            }
        }
    }

    protected abstract void notifyChildMetric(String var1, double var2, WindowMatrixProcess var4);

    @Override
    public void notify(Metric m, String metric, double v, Process p) {
        if (this.acceptMetric(metric)) {
            if (!this.currents.containsKey((WindowMatrixProcess)p)) {
                this.currents.put((WindowMatrixProcess)p, new HashMap());
            }
            this.currents.get((WindowMatrixProcess)p).put(metric, v);
        }
    }

    protected abstract void notifyProcessDone(WindowMatrixProcess var1);
}

