/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.output;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.MetricOutput;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.manager.Tool;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SelectedAsciiGridOutput
extends AbstractMetricOutput
implements MetricOutput {
    private String ascii;
    private BufferedWriter writer;
    private String metric;
    private Set<Pixel> pixels;
    private Map<Pixel, Double> values;
    private int y;
    private int nc;
    private int nr;
    private Pixel pp;

    public SelectedAsciiGridOutput(String metric, String f, int w, int h) {
        this.metric = metric;
        this.ascii = f;
        this.nc = w;
        this.nr = h;
        this.pixels = new TreeSet<Pixel>();
        this.y = -1;
        this.values = new TreeMap<Pixel, Double>();
    }

    public String toString() {
        return "ascii_" + this.metric;
    }

    @Override
    public void notify(Analysis ma, AnalysisState s) {
        switch (s) {
            case INIT: {
                this.notifyAnalysisInit((WindowMatrixAnalysis)ma);
                break;
            }
            case DONE: {
                this.notifyAnalysisDone((WindowMatrixAnalysis)ma);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowMatrixAnalysis)ma);
            }
        }
    }

    private void notifyAnalysisInit(WindowMatrixAnalysis wa) {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.ascii));
            this.writer.write("ncols " + this.nc);
            this.writer.newLine();
            this.writer.write("nrows " + this.nr);
            this.writer.newLine();
            this.writer.write("xllcorner " + wa.matrix().minX());
            this.writer.newLine();
            this.writer.write("yllcorner " + wa.matrix().minY());
            this.writer.newLine();
            this.writer.write("cellsize " + wa.matrix().cellsize());
            this.writer.newLine();
            this.writer.write("NODATA_value " + Raster.getNoDataValue());
            this.writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisDone(WindowMatrixAnalysis wa) {
        if (this.pixels.size() > 0) {
            this.pp = new Pixel(0, 0);
            Pixel end = new Pixel(this.nc - 1, this.nr - 1);
            Iterator<Pixel> ite = this.pixels.iterator();
            Pixel p = ite.next();
            while (this.pp.compareTo(end) <= 0) {
                if (p != null && p.equals(this.pp)) {
                    this.write(this.values.get(p), p.y());
                    p = ite.hasNext() ? ite.next() : null;
                } else {
                    this.write(Raster.getNoDataValue(), this.pp.y());
                }
                this.next();
            }
        }
    }

    private void notifyAnalysisFinish(WindowMatrixAnalysis wa) {
        try {
            this.writer.newLine();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Tool.copy(DynamicLayerFactory.class.getResourceAsStream(MatrixManager.epsg()), this.ascii.replace(".asc", "") + ".prj");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean acceptMetric(String metric) {
        return this.metric.equalsIgnoreCase(metric);
    }

    @Override
    public void notify(Process p, ProcessState s) {
        if (p instanceof WindowMatrixProcess) {
            switch (s) {
                case DONE: {
                    this.notifyProcessDone((WindowMatrixProcess)p);
                    break;
                }
            }
        }
    }

    protected void notifyProcessDone(WindowMatrixProcess wp) {
        this.pixels.add(wp.pixel());
    }

    @Override
    public void notify(Metric m, String metric, double v, Process wp) {
        if (this.acceptMetric(metric)) {
            this.values.put(((WindowMatrixProcess)wp).pixel(), v);
        } else {
            m.removeObserver(this);
        }
    }

    private void next() {
        this.pp = this.pp.x() + 1 >= this.nc ? new Pixel(0, this.pp.y() + 1) : new Pixel(this.pp.x() + 1, this.pp.y());
    }

    private void write(double v, int py) {
        try {
            if (this.y == -1) {
                this.writer.write(this.format(v) + "");
                this.y = 0;
            } else if (py != this.y) {
                this.writer.newLine();
                this.writer.write(this.format(v));
                this.y = py;
            } else {
                this.writer.write(" " + this.format(v));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

