/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.pixel;

import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.Pixel2PixelMatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class AbsoluteDifferenceCalculation
extends Pixel2PixelMatrixCalculation {
    private DecimalFormat format;

    public AbsoluteDifferenceCalculation(Matrix ... m) {
        super(m);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        this.format = new DecimalFormat("0.00000", symbols);
    }

    @Override
    protected double treatPixel(Pixel p) {
        double v1;
        double v0 = this.matrix(0).get(p);
        if (v0 != (double)Raster.getNoDataValue() && (v1 = this.matrix(1).get(p)) != (double)Raster.getNoDataValue()) {
            return new Double(this.format(Math.abs(v0 - v1)));
        }
        return 0.0;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doClose() {
    }

    protected String format(double v) {
        int f = new Double(Math.floor(v)).intValue();
        if (v == (double)f) {
            return f + "";
        }
        return this.format.format(v);
    }
}

