/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.util.Couple;
import java.util.Arrays;

public class SimpleWindowMatrixProcess
extends WindowMatrixProcess {
    private double[][] values;

    public SimpleWindowMatrixProcess(Window w, Pixel p, WindowMatrixProcessType wpt) {
        super(w, p, wpt);
        this.values = new double[w.height()][w.width()];
        for (int y = 0; y < this.values.length; ++y) {
            Arrays.fill(this.values[y], (double)Raster.getNoDataValue());
        }
    }

    public void resetValues() {
        this.values = null;
    }

    public double[][] values() {
        return this.values;
    }

    @Override
    public void init() {
        if (this.state().equals((Object)ProcessState.IDLE)) {
            this.setMaxSize(this.window().size(this.processType().matrix().width(), this.processType().matrix().height()));
            super.init();
        }
    }

    @Override
    public boolean add(int x, int y, double v) {
        this.window().locate(this.pixel());
        boolean ok = false;
        if (this.window().accept(x, y)) {
            ok = true;
            this.init();
            this.addCurrentSize();
            int inX = this.window().toXWindow(x);
            int inY = this.window().toYWindow(y);
            this.values[inY][inX] = v;
            int f = this.window().filter(inX, inY);
            if (f != 0) {
                this.counting.add(v, inX, inY, f, this.processType().getHorizontal(null), this.processType().getVertical(null));
            }
            if (this.currentSize() == this.maxSize()) {
                this.setState(ProcessState.READY);
            }
        }
        return ok;
    }

    public boolean addQuiet(int x, int y, double v) {
        this.window().locate(this.pixel());
        boolean ok = false;
        if (this.window().accept(x, y)) {
            int f;
            ok = true;
            this.init();
            this.addCurrentSize();
            int inX = this.window().toXWindow(x);
            int inY = this.window().toYWindow(y);
            if (this.values != null) {
                this.values[inY][inX] = v;
            }
            if ((f = this.window().filter(inX, inY)) != 0) {
                this.counting.add(v, inX, inY, f, this.processType().getHorizontal(null), this.processType().getVertical(null));
            }
        }
        return ok;
    }

    @Override
    public void delete() {
        super.delete();
        this.values = null;
    }

    @Override
    public void down(int delta) {
        if (this.pixel().y() < this.processType().matrix().height() - delta) {
            for (int d = 0; d < delta; ++d) {
                this.doDown(d);
            }
            this.window().locate(this.pixel());
            this.setMaxSize(this.window().size(this.processType().matrix().width(), this.processType().matrix().height()));
            if (this.currentSize() == this.maxSize()) {
                this.setState(ProcessState.FINISH);
            } else {
                this.setState(ProcessState.INIT);
            }
        }
    }

    private void doDown(int d) {
        this.window().locate(this.pixel());
        this.counting.down(d, 0);
        this.window().reinit();
        if (this.pixel().y() >= this.window().height() / 2) {
            for (int x = 0; x < this.window().width(); ++x) {
                if (this.pixel().x() - this.window().width() / 2 + x < 0 || this.pixel().x() - this.window().width() / 2 + x >= this.processType().matrix().width()) continue;
                this.minusCurrentSize();
            }
        }
        for (int y = 1; y < this.values.length; ++y) {
            for (int x = 0; x < this.values[y].length; ++x) {
                this.values[y - 1][x] = this.values[y][x];
            }
        }
        Arrays.fill(this.values[this.values.length - 1], (double)Raster.getNoDataValue());
        this.pixel().setY(this.pixel().y() + 1);
    }

    public void downQuiet(int delta, double[][] vs, int place) {
        if (this.pixel().y() < this.processType().matrix().height() - delta) {
            for (int d = 0; d < delta; ++d) {
                this.doDownQuiet(vs, place, d, delta);
            }
            this.window().locate(this.pixel());
            this.setMaxSize(this.window().size(this.processType().matrix().width(), this.processType().matrix().height()));
        }
    }

    private void doDownQuiet(double[][] vs, int place, int d, int delta) {
        this.window().locate(this.pixel());
        this.counting.down(d, place);
        this.window().reinit();
        if (this.pixel().y() >= this.window().height() / 2) {
            for (int x = 0; x < this.window().width(); ++x) {
                if (this.pixel().x() - this.window().width() / 2 + x < 0 || this.pixel().x() - this.window().width() / 2 + x >= this.processType().matrix().width()) continue;
                this.minusCurrentSize();
            }
        }
        for (int y = 1; y < this.values.length; ++y) {
            for (int x = 0; x < this.values[y].length; ++x) {
                this.values[y - 1][x] = this.values[y][x];
            }
        }
        this.values[this.values.length - 1] = Arrays.copyOfRange(vs[vs.length - 1 - delta - place + d + 1], place, vs[vs.length - 1].length - place);
        if (place >= 1 + d && this.window().pixel().y() + this.window().diameter() / 2 + 1 < this.processType().matrix().height()) {
            for (int i = this.window().pixel().x() - this.window().diameter() / 2 < 0 ? this.window().diameter() / 2 - this.window().pixel().x() : 0; i < (this.window().pixel().x() + this.window().diameter() / 2 >= this.processType().matrix().width() ? this.values[this.values.length - 1].length - (this.window().pixel().x() + this.window().diameter() / 2 - this.processType().matrix().width()) - 1 : this.values[this.values.length - 1].length); ++i) {
                int f = this.window().filter(i, this.values.length - 1);
                if (f == 0) continue;
                this.counting.add(this.values[this.values.length - 1][i], i, this.values.length - 1, f, i == 0 ? (double)Raster.getNoDataValue() : Couple.get(this.values[this.values.length - 1][i - 1], this.values[this.values.length - 1][i]), Couple.get(this.values[this.values.length - 2][i], this.values[this.values.length - 1][i]));
            }
        }
        this.pixel().setY(this.pixel().y() + 1);
    }
}

