/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.distance;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.SimpleWindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class BasicDistanceCounting
extends Counting {
    private int size;
    private int[][] values;
    private double total;
    private double valid;
    private double count;
    private boolean calculated;

    public BasicDistanceCounting(int size) {
        this.size = size;
    }

    @Override
    public void delete() {
        super.delete();
        this.values = null;
    }

    @Override
    public void init() {
        this.values = new int[this.size][this.size];
        for (int j = 0; j < this.size; ++j) {
            Arrays.fill(this.values[j], 0);
        }
        this.calculated = false;
    }

    @Override
    public SimpleWindowMatrixProcess process() {
        return (SimpleWindowMatrixProcess)super.process();
    }

    @Override
    public void add(double value, int x, int y, int filter, double ch, double cv) {
        this.addValue(value, x, y);
    }

    @Override
    public void addValue(double value, int x, int y) {
        this.values[y][x] = value != (double)Raster.getNoDataValue() ? (value != 0.0 ? 3 : 2) : 1;
    }

    @Override
    public void removeValue(double value, int x, int y) {
        this.values[y][x] = 0;
    }

    @Override
    public void addCouple(double couple, int x1, int y1, int x2, int y2) {
    }

    @Override
    public void removeCouple(double couple, int x1, int y1, int x2, int y2) {
    }

    @Override
    public void down(int d, int place) {
        int outy;
        int outx;
        for (Pixel p : this.process().window().removeDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width()) continue;
            this.process().counting().removeValue(this.process().values()[p.y()][p.x()], p.x(), p.y());
        }
        for (Pixel p : this.process().window().addDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width() || p.y() >= this.process().window().diameter() - d + place) continue;
            this.process().counting().addValue(this.process().values()[p.y()][p.x()], p.x(), p.y());
        }
        int[] tnewFill = new int[this.size];
        Arrays.fill(tnewFill, 0);
        this.values = (int[][])Arrays.copyOfRange(this.values, 1, this.values.length);
        this.values = (int[][])ArrayUtils.addAll((Object[])this.values, (Object[])new int[][]{tnewFill});
        this.calculated = false;
    }

    @Override
    public int theoreticalSize() {
        return this.process().window().theoreticalSize();
    }

    private void calculate() {
        this.total = 0.0;
        this.valid = 0.0;
        this.count = 0.0;
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                double v = this.values[j][i];
                double weight = this.process().window().weighted()[j][i];
                if (!(weight > 0.0) || !(v > 0.0)) continue;
                this.total += weight;
                if (!(v > 1.0)) continue;
                this.valid += weight;
                if (v != 3.0) continue;
                this.count += weight;
            }
        }
        this.calculated = true;
    }

    @Override
    public double totalValues() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.total;
    }

    @Override
    public double validValues() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.valid;
    }

    @Override
    public double countValues() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.count;
    }
}

