/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.distance;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.util.Couple;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;

public class CoupleDistanceCounting
extends CountingDecorator {
    private int size;
    private int[][] basicCouplesH;
    private int[][] basicCouplesV;
    private double[][] datasH;
    private double[][] datasV;
    private double total;
    private double valid;
    private double count;
    private double homo;
    private double hetero;
    private Map<Double, Double> couples;
    private boolean calculated;

    public CoupleDistanceCounting(Counting decorate, int size) {
        super(decorate);
        this.size = size;
    }

    @Override
    public void doInit() {
        int j;
        this.basicCouplesH = new int[this.size][this.size - 1];
        for (j = 0; j < this.size; ++j) {
            Arrays.fill(this.basicCouplesH[j], 0);
        }
        this.basicCouplesV = new int[this.size - 1][this.size];
        for (j = 0; j < this.size - 1; ++j) {
            Arrays.fill(this.basicCouplesV[j], 0);
        }
        this.datasH = new double[this.size][this.size - 1];
        for (j = 0; j < this.size; ++j) {
            Arrays.fill(this.datasH[j], 0.0);
        }
        this.datasV = new double[this.size - 1][this.size];
        for (j = 0; j < this.size - 1; ++j) {
            Arrays.fill(this.datasV[j], 0.0);
        }
        this.couples = new TreeMap<Double, Double>();
        this.calculated = false;
    }

    @Override
    protected void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        if (filter != 4) {
            if (filter != 3) {
                if (ch != (double)Raster.getNoDataValue()) {
                    if (ch != 0.0) {
                        this.datasH[y][x - 1] = ch;
                        this.basicCouplesH[y][x - 1] = Couple.isHomogeneous(ch) ? 3 : 4;
                    } else {
                        this.basicCouplesH[y][x - 1] = 2;
                    }
                } else {
                    this.basicCouplesH[y][x - 1] = 1;
                }
            }
            if (filter != 2) {
                if (cv != (double)Raster.getNoDataValue()) {
                    if (cv != 0.0) {
                        this.datasV[y - 1][x] = cv;
                        this.basicCouplesV[y - 1][x] = Couple.isHomogeneous(cv) ? 3 : 4;
                    } else {
                        this.basicCouplesV[y - 1][x] = 2;
                    }
                } else {
                    this.basicCouplesV[y - 1][x] = 1;
                }
            }
        }
    }

    @Override
    protected void doAddCouple(double couple, int x1, int y1, int x2, int y2) {
        if (y1 == y2) {
            int x = Math.min(x1, x2);
            if (couple != (double)Raster.getNoDataValue()) {
                if (couple != 0.0) {
                    this.datasH[y1][x] = couple;
                    this.basicCouplesH[y1][x] = Couple.isHomogeneous(couple) ? 3 : 4;
                } else {
                    this.basicCouplesH[y1][x] = 2;
                }
            } else {
                this.basicCouplesH[y1][x] = 1;
            }
        } else {
            int y = Math.min(y1, y2);
            if (couple != (double)Raster.getNoDataValue()) {
                if (couple != 0.0) {
                    this.datasV[y][x1] = couple;
                    this.basicCouplesV[y][x1] = Couple.isHomogeneous(couple) ? 3 : 4;
                } else {
                    this.basicCouplesV[y][x1] = 2;
                }
            } else {
                this.basicCouplesV[y][x1] = 1;
            }
        }
    }

    @Override
    protected void doRemoveCouple(double couple, int x1, int y1, int x2, int y2) {
        if (y1 == y2) {
            int x = Math.min(x1, x2);
            this.basicCouplesH[y1][x] = 0;
            if (couple != (double)Raster.getNoDataValue() && couple != 0.0) {
                this.datasH[y1][x] = 0.0;
            }
        } else {
            int y = Math.min(y1, y2);
            this.basicCouplesV[y][x1] = 0;
            if (couple != (double)Raster.getNoDataValue() && couple != 0.0) {
                this.datasV[y][x1] = 0.0;
            }
        }
    }

    @Override
    public void doDelete() {
        this.basicCouplesH = null;
        this.basicCouplesV = null;
        this.datasH = null;
        this.datasV = null;
        this.couples.clear();
        this.couples = null;
    }

    @Override
    protected void doDown(int d, int place) {
        int outy;
        int outx;
        for (Pixel p : this.process().window().removeHorizontalDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width()) continue;
            this.process().counting().removeCouple(Couple.get(this.process().values()[p.y()][p.x() - 1], this.process().values()[p.y()][p.x()]), p.x() - 1, p.y(), p.x(), p.y());
        }
        for (Pixel p : this.process().window().addHorizontalDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width() || p.y() >= this.process().window().diameter() - d + place) continue;
            this.process().counting().addCouple(Couple.get(this.process().values()[p.y()][p.x() - 1], this.process().values()[p.y()][p.x()]), p.x() - 1, p.y(), p.x(), p.y());
        }
        for (Pixel p : this.process().window().removeVerticalDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width()) continue;
            this.process().counting().removeCouple(Couple.get(this.process().values()[p.y() - 1][p.x()], this.process().values()[p.y()][p.x()]), p.x(), p.y() - 1, p.x(), p.y());
        }
        for (Pixel p : this.process().window().addVerticalDownList()) {
            outx = this.process().window().outXWindow(p.x());
            outy = this.process().window().outYWindow(p.y());
            if (outy < 0 || outy >= this.process().processType().matrix().height() || outx < 0 || outx >= this.process().processType().matrix().width() || p.y() >= this.process().window().diameter() - d + place) continue;
            this.process().counting().addCouple(Couple.get(this.process().values()[p.y() - 1][p.x()], this.process().values()[p.y()][p.x()]), p.x(), p.y() - 1, p.x(), p.y());
        }
        int[] th = new int[this.size - 1];
        Arrays.fill(th, 0);
        this.basicCouplesH = (int[][])Arrays.copyOfRange(this.basicCouplesH, 1, this.basicCouplesH.length);
        this.basicCouplesH = (int[][])ArrayUtils.addAll((Object[])this.basicCouplesH, (Object[])new int[][]{th});
        int[] tv = new int[this.size];
        Arrays.fill(tv, 0);
        this.basicCouplesV = (int[][])Arrays.copyOfRange(this.basicCouplesV, 1, this.basicCouplesV.length);
        this.basicCouplesV = (int[][])ArrayUtils.addAll((Object[])this.basicCouplesV, (Object[])new int[][]{tv});
        double[] tdh = new double[this.size - 1];
        Arrays.fill(tdh, 0.0);
        this.datasH = (double[][])Arrays.copyOfRange(this.datasH, 1, this.datasH.length);
        this.datasH = (double[][])ArrayUtils.addAll((Object[])this.datasH, (Object[])new double[][]{tdh});
        double[] tdv = new double[this.size];
        Arrays.fill(tdv, 0.0);
        this.datasV = (double[][])Arrays.copyOfRange(this.datasV, 1, this.datasV.length);
        this.datasV = (double[][])ArrayUtils.addAll((Object[])this.datasV, (Object[])new double[][]{tdv});
        this.calculated = false;
    }

    private void calculate() {
        double v;
        double weight;
        double c;
        int i;
        int j;
        this.total = 0.0;
        this.valid = 0.0;
        this.count = 0.0;
        this.homo = 0.0;
        this.hetero = 0.0;
        this.couples.clear();
        for (j = 0; j < this.size; ++j) {
            for (i = 0; i < this.size - 1; ++i) {
                c = this.datasH[j][i];
                if (c > 0.0 && !this.couples.containsKey(c)) {
                    this.couples.put(c, 0.0);
                }
                weight = this.process().window().weightedH()[j][i];
                if (c > 0.0) {
                    this.couples.put(c, this.couples.get(c) + weight);
                }
                if (!((v = (double)this.basicCouplesH[j][i]) > 0.0)) continue;
                this.total += weight;
                if (!(v > 1.0)) continue;
                this.valid += weight;
                if (!(v > 2.0)) continue;
                this.count += weight;
                if (v > 3.0) {
                    this.hetero += weight;
                    continue;
                }
                this.homo += weight;
            }
        }
        for (j = 0; j < this.size - 1; ++j) {
            for (i = 0; i < this.size; ++i) {
                c = this.datasV[j][i];
                if (c > 0.0 && !this.couples.containsKey(c)) {
                    this.couples.put(c, 0.0);
                }
                weight = this.process().window().weightedV()[j][i];
                if (c > 0.0) {
                    this.couples.put(c, this.couples.get(c) + weight);
                }
                if (!((v = (double)this.basicCouplesV[j][i]) > 0.0)) continue;
                this.total += weight;
                if (!(v > 1.0)) continue;
                this.valid += weight;
                if (!(v > 2.0)) continue;
                this.count += weight;
                if (v > 3.0) {
                    this.hetero += weight;
                    continue;
                }
                this.homo += weight;
            }
        }
        this.calculated = true;
    }

    @Override
    public Set<Double> couples() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.couples.keySet();
    }

    @Override
    public double totalCouples() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.total;
    }

    @Override
    public double validCouples() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.valid;
    }

    @Override
    public double countCouples() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.count;
    }

    @Override
    public double homogeneousCouples() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.homo;
    }

    @Override
    public double heterogeneousCouples() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.hetero;
    }

    @Override
    public double countCouple(double c) {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.couples.containsKey(c)) {
            return this.couples.get(c);
        }
        return 0.0;
    }
}

