/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.distance;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.patch.Patch;
import fr.inra.sad.bagap.apiland.patch.PatchComposite;
import java.util.HashMap;
import java.util.Map;

public class PatchDistanceCounting
extends CountingDecorator {
    private PatchComposite patches;
    private boolean calculated;
    private double count;
    private double sum;
    private double max;
    private Map<Integer, Double> counts;
    private Map<Integer, Double> sums;
    private Map<Integer, Double> maxs;
    private Map<Patch, Double> areas;

    public PatchDistanceCounting(Counting decorate) {
        super(decorate);
    }

    @Override
    protected void doDown(int d, int place) {
        this.patches.upPixels();
        this.calculated = false;
    }

    @Override
    protected void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        this.doAddValue(value, x, y);
    }

    @Override
    protected void doAddValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.patches.addPixel(new Pixel(x, y), (int)value);
        }
    }

    @Override
    protected void doRemoveValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.patches.removePixel(new Pixel(x, y), (int)value);
        }
    }

    @Override
    protected void doInit() {
        this.patches = new PatchComposite();
        this.counts = new HashMap<Integer, Double>();
        this.sums = new HashMap<Integer, Double>();
        this.maxs = new HashMap<Integer, Double>();
        this.areas = new HashMap<Patch, Double>();
        this.calculated = false;
    }

    @Override
    protected void doDelete() {
        this.patches = null;
        this.counts = null;
        this.sums = null;
        this.maxs = null;
        this.areas = null;
    }

    @Override
    public PatchComposite patches() {
        return this.patches;
    }

    public void calculate() {
        this.count = 0.0;
        this.max = 0.0;
        this.sum = 0.0;
        this.counts.clear();
        this.sums.clear();
        this.maxs.clear();
        this.areas.clear();
        double s = Math.pow(Raster.getCellSize(), 2.0);
        for (Patch p : this.patches.patches()) {
            double v = p.getValue();
            if (v == 0.0) continue;
            if (!this.counts.containsKey((int)v)) {
                this.counts.put((int)v, 0.0);
                this.sums.put((int)v, 0.0);
                this.maxs.put((int)v, 0.0);
            }
            int size = p.pixels().size();
            double sumWeighted = 0.0;
            for (Pixel pixel : p.pixels()) {
                sumWeighted += this.process().window().weighted()[pixel.y()][pixel.x()];
            }
            if (!(sumWeighted > 0.0)) continue;
            this.count += sumWeighted / (double)size;
            this.counts.put((int)v, this.counts.get((int)v) + sumWeighted / (double)size);
            double area = sumWeighted * s / 10000.0;
            this.areas.put(p, area);
            this.max = Math.max(this.max, area);
            this.maxs.put((int)v, Math.max(this.maxs.get((int)v), area));
            this.sum += area;
            this.sums.put((int)v, this.sums.get((int)v) + area);
        }
        this.calculated = true;
    }

    @Override
    public double getShannonDiversityPatchSize() {
        if (!this.calculated) {
            this.calculate();
        }
        double shdi = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() == 0 || !this.areas.containsKey(p)) continue;
            double area = this.areas.get(p);
            shdi += area / this.sum * Math.log(area / this.sum);
        }
        if (shdi != 0.0) {
            shdi *= -1.0;
        }
        return shdi;
    }

    @Override
    public double getShannonDiversityPatchSize(int classe) {
        if (!this.calculated) {
            this.calculate();
        }
        double shdi = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() != classe || !this.areas.containsKey(p)) continue;
            double area = this.areas.get(p);
            double sumClasse = this.sums.get(classe);
            shdi += area / sumClasse * Math.log(area / sumClasse);
        }
        if (shdi != 0.0) {
            shdi *= -1.0;
        }
        return shdi;
    }

    @Override
    public double getPatchNumber() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.count;
    }

    @Override
    public double getPatchNumber(int classe) {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.counts.containsKey(classe)) {
            return this.counts.get(classe);
        }
        return 0.0;
    }

    @Override
    public double getLargestPatchSize() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.max;
    }

    @Override
    public double getLargestPatchSize(int classe) {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.maxs.containsKey(classe)) {
            return this.maxs.get(classe);
        }
        return 0.0;
    }

    @Override
    public double getMeanPatchSize() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.sum / this.count;
    }

    @Override
    public double getMeanPatchSize(int classe) {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.sums.containsKey(classe)) {
            return this.sums.get(classe) / this.counts.get(classe);
        }
        return 0.0;
    }
}

